/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class OUpdateRecordResponse
implements OBinaryResponse {
    private int version;
    private Map<UUID, OBonsaiCollectionPointer> changes;

    public OUpdateRecordResponse(int version, Map<UUID, OBonsaiCollectionPointer> changes) {
        this.version = version;
        this.changes = changes;
    }

    public OUpdateRecordResponse() {
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeVersion(this.version);
        if (protocolVersion >= 20) {
            OMessageHelper.writeCollectionChanges(channel, this.changes);
        }
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        this.version = network.readVersion();
        this.changes = OMessageHelper.readCollectionChanges(network);
    }

    public int getVersion() {
        return this.version;
    }

    public Map<UUID, OBonsaiCollectionPointer> getChanges() {
        return this.changes;
    }
}

