/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.UntypedObjectDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.javatuples.Pair;

public class OrientIoRegistry
extends AbstractIoRegistry {
    private static final String CLUSTER_ID = "clusterId";
    private static final String CLUSTER_POSITION = "clusterPosition";
    private static final OrientIoRegistry INSTANCE = new OrientIoRegistry();

    private OrientIoRegistry() {
        this.register(GryoIo.class, ORecordId.class, (Object)new ORecordIdKyroSerializer());
        this.register(GryoIo.class, ORidBag.class, (Object)new ORidBagKyroSerializer());
        SimpleModule serializer = new SimpleModule();
        serializer.addSerializer(ORecordId.class, (JsonSerializer)new ORecordIdJacksonSerializer());
        serializer.addDeserializer(ORecordId.class, (JsonDeserializer)new ORecordIdDeserializer());
        serializer.addSerializer(ORidBag.class, (JsonSerializer)new ORidBagJacksonSerializer());
        serializer.addDeserializer(ORidBag.class, (JsonDeserializer)new ORidBagDeserializer());
        serializer.addDeserializer(Object.class, (JsonDeserializer)new OObjectJacksonDeserializer());
        serializer.addDeserializer(Edge.class, (JsonDeserializer)new EdgeJacksonDeserializer());
        serializer.addDeserializer(Vertex.class, (JsonDeserializer)new VertexJacksonDeserializer());
        serializer.addDeserializer(Map.class, (JsonDeserializer)new ORecordIdDeserializer());
        this.register(GraphSONIo.class, ORecordId.class, serializer);
        this.register(GraphSONIo.class, Map.class, serializer);
    }

    public static OrientIoRegistry getInstance() {
        return INSTANCE;
    }

    private static ORecordId newORecordId(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ORecordId) {
            return (ORecordId)obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return new ORecordId(((Number)map.get(CLUSTER_ID)).intValue(), ((Number)map.get(CLUSTER_POSITION)).longValue());
        }
        throw new IllegalArgumentException("Unable to convert unknow type to ORecordId " + obj.getClass());
    }

    private static boolean isORecord(Object result) {
        if (!(result instanceof Map)) {
            return false;
        }
        Map map = (Map)result;
        return map.containsKey(CLUSTER_ID) && map.containsKey(CLUSTER_POSITION);
    }

    static class VertexJacksonDeserializer
    extends AbstractObjectDeserializer<Vertex> {
        public VertexJacksonDeserializer() {
            super(Vertex.class);
        }

        public Vertex createObject(Map<String, Object> vertexData) {
            return new DetachedVertex((Object)OrientIoRegistry.newORecordId(vertexData.get("id")), vertexData.get("label").toString(), (Map)vertexData.get("properties"));
        }
    }

    static class EdgeJacksonDeserializer
    extends AbstractObjectDeserializer<Edge> {
        public EdgeJacksonDeserializer() {
            super(Edge.class);
        }

        public Edge createObject(Map<String, Object> edgeData) {
            return new DetachedEdge((Object)OrientIoRegistry.newORecordId(edgeData.get("id")), edgeData.get("label").toString(), (Map)edgeData.get("properties"), Pair.with((Object)OrientIoRegistry.newORecordId(edgeData.get("outV")), (Object)edgeData.get("outVLabel").toString()), Pair.with((Object)OrientIoRegistry.newORecordId(edgeData.get("inV")), (Object)edgeData.get("inVLabel").toString()));
        }
    }

    static final class ORidBagKyroSerializer
    extends Serializer<ORidBag> {
        ORidBagKyroSerializer() {
        }

        public ORidBag read(Kryo kryo, Input input, Class<ORidBag> tinkerGraphClass) {
            String[] ids;
            ORidBag bag = new ORidBag();
            for (String id : ids = input.readString().split(";")) {
                bag.add((OIdentifiable)new ORecordId(id));
            }
            return bag;
        }

        public void write(Kryo kryo, Output output, ORidBag bag) {
            StringBuilder ids = new StringBuilder();
            bag.forEach(rid -> ids.append(rid.getIdentity()).append(";"));
            output.writeString((CharSequence)ids);
        }
    }

    static final class ORecordIdKyroSerializer
    extends Serializer<ORecordId> {
        ORecordIdKyroSerializer() {
        }

        public ORecordId read(Kryo kryo, Input input, Class<ORecordId> tinkerGraphClass) {
            return new ORecordId(input.readString());
        }

        public void write(Kryo kryo, Output output, ORecordId rid) {
            output.writeString(rid.toString());
        }
    }

    static final class ORecordIdDeserializer
    extends UntypedObjectDeserializer.Vanilla {
        ORecordIdDeserializer() {
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object result = super.deserialize(p, ctxt);
            if (OrientIoRegistry.isORecord(result)) {
                return OrientIoRegistry.newORecordId(result);
            }
            return result;
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return super.deserializeWithType(p, ctxt, typeDeserializer);
        }
    }

    static final class ORidBagDeserializer
    extends UntypedObjectDeserializer.Vanilla {
        ORidBagDeserializer() {
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map;
            Object result = super.deserialize(p, ctxt);
            if (result instanceof Map && (map = (Map)result).containsKey(OrientIoRegistry.CLUSTER_ID) && map.containsKey(OrientIoRegistry.CLUSTER_POSITION)) {
                return new ORecordId(((Number)map.get(OrientIoRegistry.CLUSTER_ID)).intValue(), ((Number)map.get(OrientIoRegistry.CLUSTER_POSITION)).longValue());
            }
            return result;
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return super.deserializeWithType(p, ctxt, typeDeserializer);
        }
    }

    static final class ORidBagJacksonSerializer
    extends JsonSerializer<ORidBag> {
        ORidBagJacksonSerializer() {
        }

        public void serialize(ORidBag value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            this.serializeWithType(value, jgen, provider, (TypeSerializer)null);
        }

        public void serializeWithType(ORidBag value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            jgen.writeStartArray();
            if (typeSer != null) {
                jgen.writeStringField("@class", ORidBag.class.getName());
            }
            for (OIdentifiable id : value) {
                jgen.writeString(id.getIdentity().toString());
            }
            jgen.writeEndArray();
        }
    }

    static final class ORecordIdJacksonSerializer
    extends JsonSerializer<ORecordId> {
        ORecordIdJacksonSerializer() {
        }

        public void serialize(ORecordId value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            this.serializeWithType(value, jgen, provider, (TypeSerializer)null);
        }

        public void serializeWithType(ORecordId value, JsonGenerator jgen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            if (typeSer != null) {
                typeSer.writeTypePrefixForObject((Object)value, jgen);
            } else {
                jgen.writeStartObject();
            }
            jgen.writeFieldName(OrientIoRegistry.CLUSTER_ID);
            jgen.writeNumber(value.getClusterId());
            jgen.writeFieldName(OrientIoRegistry.CLUSTER_POSITION);
            jgen.writeNumber(value.getClusterPosition());
            if (typeSer != null) {
                typeSer.writeTypeSuffixForObject((Object)value, jgen);
            } else {
                jgen.writeEndObject();
            }
        }
    }

    static final class OObjectJacksonDeserializer
    extends UntypedObjectDeserializer.Vanilla {
        OObjectJacksonDeserializer() {
        }

        public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return super.deserializeWithType(jp, ctxt, typeDeserializer);
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map;
            Object result = super.deserialize(p, ctxt);
            if (result instanceof Map && (map = (Map)result).containsKey(OrientIoRegistry.CLUSTER_ID) && map.containsKey(OrientIoRegistry.CLUSTER_POSITION)) {
                return new ORecordId(((Number)map.get(OrientIoRegistry.CLUSTER_ID)).intValue(), ((Number)map.get(OrientIoRegistry.CLUSTER_POSITION)).longValue());
            }
            return result;
        }
    }
}

