/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientEdge;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphUtils;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertexProperty;
import org.apache.tinkerpop.gremlin.orientdb.StreamUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class OrientVertex
extends OrientElement
implements Vertex {
    private static final List<String> INTERNAL_FIELDS = Arrays.asList("@rid", "@class");

    public OrientVertex(OrientGraph graph, OVertex rawElement) {
        super(graph, (OElement)rawElement);
    }

    public OrientVertex(OrientGraph graph, OIdentifiable identifiable) {
        this(graph, (OVertex)new ODocument(identifiable.getIdentity()).asVertex().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get a Vertex for identity %s", identifiable))));
    }

    public OrientVertex(OrientGraph graph, String label) {
        this(graph, OrientVertex.createRawElement(graph, label));
    }

    protected static OVertex createRawElement(OrientGraph graph, String label) {
        graph.createVertexClass(label);
        return graph.getRawDatabase().newVertex(label);
    }

    public Iterator<Vertex> vertices(Direction direction, String ... labels) {
        this.graph.tx().readWrite();
        Stream<Vertex> vertexStream = StreamUtils.asStream(this.getRawElement().getVertices(OrientGraphUtils.mapDirection(direction), labels).iterator()).map(v -> new OrientVertex(this.graph, (OVertex)v));
        return vertexStream.iterator();
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        Iterator properties = super.properties(propertyKeys);
        return StreamUtils.asStream(properties).filter(p -> !INTERNAL_FIELDS.contains(p.key())).filter(p -> !p.key().startsWith("out_")).filter(p -> !p.key().startsWith("in_")).filter(p -> !p.key().startsWith("_meta_")).map(p -> new OrientVertexProperty<Object>(p.key(), p.value(), (OrientVertex)p.element())).iterator();
    }

    public OVertex getRawElement() {
        return (OVertex)this.rawElement.asVertex().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get a Vertex for element %s", this.rawElement)));
    }

    public <V> VertexProperty<V> property(String key, V value) {
        return new OrientVertexProperty<V>(super.property(key, value), this);
    }

    public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        VertexProperty<V> vertexProperty = this.property(key, value);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw VertexProperty.Exceptions.userSuppliedIdsNotSupported();
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        ElementHelper.attachProperties(vertexProperty, (Object[])keyValues);
        return vertexProperty;
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        return this.property(key, value, keyValues);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        if (inVertex == null) {
            throw new IllegalArgumentException("destination vertex is null");
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)label) ? 1 : 0) != 0, (Object)"label is invalid");
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        if (Graph.Hidden.isHidden((String)label)) {
            throw Element.Exceptions.labelCanNotBeAHiddenKey((String)label);
        }
        this.graph.createEdgeClass(label);
        this.graph.tx().readWrite();
        OEdge oEdge = this.getRawElement().addEdge(((OrientVertex)inVertex).getRawElement(), label);
        OrientEdge edge = new OrientEdge(this.graph, oEdge);
        edge.property(keyValues);
        edge.save();
        return edge;
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        this.graph.tx().readWrite();
        Stream<Edge> edgeStream = StreamUtils.asStream(this.getRawElement().getEdges(OrientGraphUtils.mapDirection(direction), edgeLabels).iterator()).map(e -> new OrientEdge(this.graph, (OEdge)e));
        return edgeStream.collect(Collectors.toList()).iterator();
    }
}

