/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.traversal.step.map;

import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class OrientClassCountStep<S>
extends AbstractStep<S, Long> {
    private String klass;
    protected boolean done = false;

    public OrientClassCountStep(Traversal.Admin traversal, GraphStep prev) {
        this(traversal, "");
        this.klass = this.baseClass(prev);
    }

    public OrientClassCountStep(Traversal.Admin traversal, String klass) {
        super(traversal);
        this.klass = klass;
    }

    protected String baseClass(GraphStep step) {
        return Vertex.class.isAssignableFrom(step.getReturnClass()) ? "V" : "E";
    }

    protected Traverser.Admin<Long> processNextStart() throws NoSuchElementException {
        if (!this.done) {
            this.done = true;
            OrientGraph graph = (OrientGraph)this.traversal.getGraph().get();
            Long v = graph.getRawDatabase().countClass(this.klass);
            return this.traversal.getTraverserGenerator().generate((Object)v, (Step)this, 1L);
        }
        throw FastNoSuchElementException.instance();
    }

    public String getKlass() {
        return this.klass;
    }
}

