/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Genson;
import com.owlike.genson.Trilean;
import com.owlike.genson.annotation.JsonCreator;
import com.owlike.genson.reflect.AbstractBeanDescriptorProvider;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanMutatorAccessorResolver;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.BeanPropertyFactory;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.reflect.PropertyNameResolver;
import com.owlike.genson.reflect.TypeUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BaseBeanDescriptorProvider
extends AbstractBeanDescriptorProvider {
    private static final Comparator<BeanCreator> _beanCreatorsComparator = new Comparator<BeanCreator>(){

        @Override
        public int compare(BeanCreator o1, BeanCreator o2) {
            return o1.parameters.size() - o2.parameters.size();
        }
    };
    private final BeanPropertyFactory propertyFactory;
    protected final BeanMutatorAccessorResolver mutatorAccessorResolver;
    protected final PropertyNameResolver nameResolver;
    protected final boolean useGettersAndSetters;
    protected final boolean useFields;
    protected final boolean favorEmptyCreators;

    public BaseBeanDescriptorProvider(AbstractBeanDescriptorProvider.ContextualConverterFactory ctxConverterFactory, BeanPropertyFactory propertyFactory, BeanMutatorAccessorResolver mutatorAccessorResolver, PropertyNameResolver nameResolver, boolean useGettersAndSetters, boolean useFields, boolean favorEmptyCreators) {
        super(ctxConverterFactory);
        if (mutatorAccessorResolver == null) {
            throw new IllegalArgumentException("mutatorAccessorResolver must be not null!");
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException("nameResolver must be not null!");
        }
        if (propertyFactory == null) {
            throw new IllegalArgumentException("propertyFactory must be not null!");
        }
        this.propertyFactory = propertyFactory;
        this.mutatorAccessorResolver = mutatorAccessorResolver;
        this.nameResolver = nameResolver;
        this.useFields = useFields;
        this.useGettersAndSetters = useGettersAndSetters;
        if (!useFields && !useGettersAndSetters) {
            throw new IllegalArgumentException("You must allow at least one mode: with fields or methods.");
        }
        this.favorEmptyCreators = favorEmptyCreators;
    }

    @Override
    public List<BeanCreator> provideBeanCreators(Type ofType, Genson genson) {
        ArrayList<BeanCreator> creators = new ArrayList<BeanCreator>();
        Class<?> ofClass = TypeUtil.getRawClass(ofType);
        if (ofClass.isMemberClass() && (ofClass.getModifiers() & 8) == 0) {
            return creators;
        }
        this.provideConstructorCreators(ofType, creators, genson);
        for (Class<?> clazz = ofClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            this.provideMethodCreators(clazz, creators, ofType, genson);
        }
        return creators;
    }

    @Override
    public void provideBeanPropertyAccessors(Type ofType, Map<String, LinkedList<PropertyAccessor>> accessorsMap, Genson genson) {
        for (Class<?> clazz = TypeUtil.getRawClass(ofType); clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            if (this.useFields) {
                this.provideFieldAccessors(clazz, accessorsMap, ofType, genson);
            }
            if (!this.useGettersAndSetters) continue;
            this.provideMethodAccessors(clazz, accessorsMap, ofType, genson);
        }
    }

    @Override
    public void provideBeanPropertyMutators(Type ofType, Map<String, LinkedList<PropertyMutator>> mutatorsMap, Genson genson) {
        for (Class<?> clazz = TypeUtil.getRawClass(ofType); clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            if (this.useFields) {
                this.provideFieldMutators(clazz, mutatorsMap, ofType, genson);
            }
            if (!this.useGettersAndSetters) continue;
            this.provideMethodMutators(clazz, mutatorsMap, ofType, genson);
        }
    }

    protected void provideConstructorCreators(Type ofType, List<BeanCreator> creators, Genson genson) {
        Constructor<?>[] ctrs;
        Class<?> ofClass = TypeUtil.getRawClass(ofType);
        for (Constructor<?> ctr : ctrs = ofClass.getDeclaredConstructors()) {
            String name;
            int idx;
            if (Trilean.TRUE != this.mutatorAccessorResolver.isCreator(ctr, ofClass)) continue;
            Type[] parameterTypes = ctr.getGenericParameterTypes();
            int paramCnt = parameterTypes.length;
            String[] parameterNames = new String[paramCnt];
            for (idx = 0; idx < paramCnt && (name = this.nameResolver.resolve(idx, ctr)) != null; ++idx) {
                parameterNames[idx] = name;
            }
            if (idx != paramCnt) continue;
            BeanCreator creator = this.propertyFactory.createCreator(ofType, ctr, parameterNames, genson);
            creators.add(creator);
        }
    }

    protected void provideMethodCreators(Class<?> ofClass, List<BeanCreator> creators, Type ofType, Genson genson) {
        Method[] ctrs;
        for (Method ctr : ctrs = ofClass.getDeclaredMethods()) {
            String name;
            int idx;
            if (Trilean.TRUE != this.mutatorAccessorResolver.isCreator(ctr, TypeUtil.getRawClass(ofType))) continue;
            Type[] parameterTypes = ctr.getGenericParameterTypes();
            int paramCnt = parameterTypes.length;
            String[] parameterNames = new String[paramCnt];
            for (idx = 0; idx < paramCnt && (name = this.nameResolver.resolve(idx, ctr)) != null; ++idx) {
                parameterNames[idx] = name;
            }
            if (idx != paramCnt) continue;
            BeanCreator creator = this.propertyFactory.createCreator(ofType, ctr, parameterNames, genson);
            creators.add(creator);
        }
    }

    protected void provideFieldAccessors(Class<?> ofClass, Map<String, LinkedList<PropertyAccessor>> accessorsMap, Type ofType, Genson genson) {
        Field[] fields;
        for (Field field : fields = ofClass.getDeclaredFields()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isAccessor(field, TypeUtil.getRawClass(ofType))) continue;
            String name = this.nameResolver.resolve(field);
            if (name == null) {
                throw new IllegalStateException("Field '" + field.getName() + "' from class " + ofClass.getName() + " has been discovered as accessor but its name couldn't be resolved!");
            }
            PropertyAccessor accessor = this.propertyFactory.createAccessor(name, field, ofType, genson);
            this.update(accessor, accessorsMap);
        }
    }

    protected void provideMethodAccessors(Class<?> ofClass, Map<String, LinkedList<PropertyAccessor>> accessorsMap, Type ofType, Genson genson) {
        Method[] methods;
        for (Method method : methods = ofClass.getDeclaredMethods()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isAccessor(method, TypeUtil.getRawClass(ofType))) continue;
            String name = this.nameResolver.resolve(method);
            if (name == null) {
                throw new IllegalStateException("Method '" + method.getName() + "' from class " + ofClass.getName() + " has been discovered as accessor but its name couldn't be resolved!");
            }
            PropertyAccessor accessor = this.propertyFactory.createAccessor(name, method, ofType, genson);
            this.update(accessor, accessorsMap);
        }
    }

    protected void provideFieldMutators(Class<?> ofClass, Map<String, LinkedList<PropertyMutator>> mutatorsMap, Type ofType, Genson genson) {
        Field[] fields;
        for (Field field : fields = ofClass.getDeclaredFields()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isMutator(field, TypeUtil.getRawClass(ofType))) continue;
            String name = this.nameResolver.resolve(field);
            if (name == null) {
                throw new IllegalStateException("Field '" + field.getName() + "' from class " + ofClass.getName() + " has been discovered as mutator but its name couldn't be resolved!");
            }
            PropertyMutator mutator = this.propertyFactory.createMutator(name, field, ofType, genson);
            this.update(mutator, mutatorsMap);
        }
    }

    protected void provideMethodMutators(Class<?> ofClass, Map<String, LinkedList<PropertyMutator>> mutatorsMap, Type ofType, Genson genson) {
        Method[] methods;
        for (Method method : methods = ofClass.getDeclaredMethods()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isMutator(method, TypeUtil.getRawClass(ofType))) continue;
            String name = this.nameResolver.resolve(method);
            if (name == null) {
                throw new IllegalStateException("Method '" + method.getName() + "' from class " + ofClass.getName() + " has been discovered as mutator but its name couldn't be resolved!");
            }
            PropertyMutator mutator = this.propertyFactory.createMutator(name, method, ofType, genson);
            this.update(mutator, mutatorsMap);
        }
    }

    protected <T extends BeanProperty> void update(T property, Map<String, LinkedList<T>> map) {
        LinkedList<Object> accessors = map.get(property.name);
        if (accessors == null) {
            accessors = new LinkedList();
            map.put(property.name, accessors);
        }
        accessors.add(property);
    }

    @Override
    protected BeanCreator checkAndMerge(Type ofType, List<BeanCreator> creators) {
        Class<?> ofClass = TypeUtil.getRawClass(ofType);
        if (creators == null || creators.isEmpty()) {
            return null;
        }
        if (this.favorEmptyCreators) {
            Collections.sort(creators, _beanCreatorsComparator);
        }
        boolean hasCreatorAnnotation = false;
        BeanCreator creator = null;
        for (int i = 0; i < creators.size(); ++i) {
            BeanCreator ctr = creators.get(i);
            if (!ctr.isAnnotationPresent(JsonCreator.class)) continue;
            if (!hasCreatorAnnotation) {
                hasCreatorAnnotation = true;
                continue;
            }
            this._throwCouldCreateBeanDescriptor(ofClass, " only one @JsonCreator annotation per class is allowed.");
        }
        if (hasCreatorAnnotation) {
            for (BeanCreator ctr : creators) {
                if (!ctr.isAnnotationPresent(JsonCreator.class)) continue;
                return ctr;
            }
        } else {
            creator = creators.get(0);
        }
        return creator;
    }

    protected void _throwCouldCreateBeanDescriptor(Class<?> ofClass, String reason) {
        throw new IllegalStateException("Could not create BeanDescriptor for type " + ofClass.getName() + "," + reason);
    }

    @Override
    protected PropertyAccessor checkAndMergeAccessors(String name, LinkedList<PropertyAccessor> accessors) {
        PropertyAccessor accessor = this._mostSpecificPropertyDeclaringClass(name, accessors);
        return accessor;
    }

    @Override
    protected PropertyMutator checkAndMergeMutators(String name, LinkedList<PropertyMutator> mutators) {
        PropertyMutator mutator = this._mostSpecificPropertyDeclaringClass(name, mutators);
        return mutator;
    }

    protected <T extends BeanProperty> T _mostSpecificPropertyDeclaringClass(String name, LinkedList<T> properties) {
        Iterator it = properties.iterator();
        BeanProperty property = (BeanProperty)it.next();
        while (it.hasNext()) {
            BeanProperty next = (BeanProperty)it.next();
            if ((!property.declaringClass.equals(next.declaringClass) || property.priority() >= next.priority()) && !property.declaringClass.isAssignableFrom(next.declaringClass)) continue;
            next.updateWith(property);
            property = next;
        }
        return (T)property;
    }

    @Override
    protected void mergeMutatorsWithCreatorProperties(Type ofType, Map<String, PropertyMutator> mutators, BeanCreator creator) {
        for (Map.Entry<String, BeanCreator.BeanCreatorProperty> entry : creator.parameters.entrySet()) {
            PropertyMutator muta = mutators.get(entry.getKey());
            if (muta == null) {
                BeanCreator.BeanCreatorProperty ctrProperty = entry.getValue();
                mutators.put(entry.getKey(), ctrProperty);
                continue;
            }
            entry.getValue().updateWith(muta);
        }
    }

    @Override
    protected void mergeAccessorsWithCreatorProperties(Type ofType, List<PropertyAccessor> accessors, BeanCreator creator) {
    }
}

