/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

public class FloatBinding
extends TupleBinding {
    private static final int FLOAT_SIZE = 4;

    public Object entryToObject(TupleInput input) {
        return new Float(input.readFloat());
    }

    public void objectToEntry(Object object, TupleOutput output) {
        output.writeFloat(((Number)object).floatValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(DatabaseEntry entry) {
        return FloatBinding.entryToInput(entry).readFloat();
    }

    public static void floatToEntry(float val, DatabaseEntry entry) {
        FloatBinding.outputToEntry(FloatBinding.sizedOutput().writeFloat(val), entry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

