/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DumpFileReader
extends FileReader {
    private Set targetEntryTypes = new HashSet();
    protected Set targetTxnIds;
    protected boolean verbose;

    public DumpFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, String entryTypes, String txnIds, boolean verbose) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, null, -1L, finishLsn);
        StringTokenizer tokenizer;
        if (entryTypes != null) {
            tokenizer = new StringTokenizer(entryTypes, ",");
            while (tokenizer.hasMoreTokens()) {
                String typeString = tokenizer.nextToken();
                this.targetEntryTypes.add(new Byte(typeString.trim()));
            }
        }
        this.targetTxnIds = new HashSet();
        if (txnIds != null) {
            tokenizer = new StringTokenizer(txnIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String txnIdString = tokenizer.nextToken();
                this.targetTxnIds.add(new Long(txnIdString.trim()));
            }
        }
        this.verbose = verbose;
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        if (this.targetEntryTypes.size() == 0) {
            return true;
        }
        return this.targetEntryTypes.contains(new Byte(logEntryTypeNumber));
    }

    public void summarize() {
    }
}

