/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.recovery.DirtyINMap;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread {
    private EnvironmentImpl envImpl;
    private long checkpointId;
    private long logSizeBytesInterval;
    private long logFileMax;
    private long timeInterval;
    private long lastCheckpointMillis;
    private volatile int highestFlushLevel;
    private int nCheckpoints;
    private long lastFirstActiveLsn;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private FlushStats flushStats;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, envImpl);
        this.envImpl = envImpl;
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.nCheckpoints = 0;
        this.flushStats = new FlushStats();
        this.highestFlushLevel = -1;
    }

    public void initIntervals(long lastCheckpointEnd, long lastCheckpointMillis) {
        this.lastCheckpointEnd = lastCheckpointEnd;
        this.lastCheckpointMillis = lastCheckpointMillis;
    }

    public int getHighestFlushLevel() {
        return this.highestFlushLevel;
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException, DatabaseException {
        long wakeupPeriod = PropUtil.microsToMillis(configManager.getLong(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL));
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName() + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    public synchronized void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Checkpointer name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNCheckpoints(this.nCheckpoints);
        stat.setLastCheckpointStart(this.lastCheckpointStart);
        stat.setLastCheckpointEnd(this.lastCheckpointEnd);
        stat.setLastCheckpointId(this.checkpointId);
        stat.setNFullINFlush(this.flushStats.nFullINFlush);
        stat.setNFullBINFlush(this.flushStats.nFullBINFlush);
        stat.setNDeltaINFlush(this.flushStats.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0;
            this.flushStats.nFullINFlush = 0;
            this.flushStats.nFullBINFlush = 0;
            this.flushStats.nDeltaINFlush = 0;
        }
    }

    public long getFirstActiveLsn() {
        return this.lastFirstActiveLsn;
    }

    public void setFirstActiveLsn(long lastFirstActiveLsn) {
        this.lastFirstActiveLsn = lastFirstActiveLsn;
    }

    public synchronized void clearEnv() {
        this.envImpl = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    protected void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, false, "daemon");
    }

    public void wakeupAfterWrite() {
        long nextLsn;
        if (this.logSizeBytesInterval != 0L && DbLsn.getNoCleaningDistance(nextLsn = this.envImpl.getFileManager().getNextLsn(), this.lastCheckpointEnd, this.logFileMax) >= this.logSizeBytesInterval) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunnable(CheckpointConfig config) throws DatabaseException {
        boolean runnable;
        long nextLsn;
        long useTimeInterval;
        long useBytesInterval;
        block19: {
            StringBuffer sb2;
            boolean bl;
            useBytesInterval = 0L;
            useTimeInterval = 0L;
            nextLsn = -1L;
            runnable = false;
            try {
                if (!config.getForce()) break block19;
                bl = runnable = true;
                Object var12_9 = null;
                sb2 = new StringBuffer();
                sb2.append("size interval=").append(useBytesInterval);
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                StringBuffer sb2 = new StringBuffer();
                sb2.append("size interval=").append(useBytesInterval);
                if (nextLsn != -1L) {
                    sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                }
                if (this.lastCheckpointEnd != -1L) {
                    sb2.append(" lastCkpt=");
                    sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                }
                sb2.append(" time interval=").append(useTimeInterval);
                sb2.append(" force=").append(config.getForce());
                sb2.append(" runnable=").append(runnable);
                Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                throw throwable;
            }
            if (nextLsn != -1L) {
                sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
            }
            if (this.lastCheckpointEnd != -1L) {
                sb2.append(" lastCkpt=");
                sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
            }
            sb2.append(" time interval=").append(useTimeInterval);
            sb2.append(" force=").append(config.getForce());
            sb2.append(" runnable=").append(runnable);
            Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
            return bl;
        }
        if (config.getKBytes() != 0) {
            useBytesInterval = config.getKBytes() << 10;
        } else if (config.getMinutes() != 0) {
            useTimeInterval = config.getMinutes() * 60 * 1000;
        } else if (this.logSizeBytesInterval != 0L) {
            useBytesInterval = this.logSizeBytesInterval;
        } else {
            useTimeInterval = this.timeInterval;
        }
        if (useBytesInterval != 0L) {
            nextLsn = this.envImpl.getFileManager().getNextLsn();
            runnable = DbLsn.getNoCleaningDistance(nextLsn, this.lastCheckpointEnd, this.logFileMax) >= useBytesInterval;
        } else if (useTimeInterval != 0L) {
            long lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
            runnable = System.currentTimeMillis() - this.lastCheckpointMillis >= useTimeInterval && DbLsn.compareTo(lastUsedLsn, this.lastCheckpointEnd) != 0;
        } else {
            runnable = false;
        }
        boolean bl = runnable;
        Object var12_10 = null;
        StringBuffer sb2 = new StringBuffer();
        sb2.append("size interval=").append(useBytesInterval);
        if (nextLsn != -1L) {
            sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
        }
        if (this.lastCheckpointEnd != -1L) {
            sb2.append(" lastCkpt=");
            sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
        }
        sb2.append(" time interval=").append(useTimeInterval);
        sb2.append(" force=").append(config.getForce());
        sb2.append(" runnable=").append(runnable);
        Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCheckpoint(CheckpointConfig config, boolean flushAll, String invokingSource) throws DatabaseException {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        if (!this.isRunnable(config)) {
            return;
        }
        boolean flushExtraLevel = false;
        Cleaner cleaner = this.envImpl.getCleaner();
        FileSelector.CheckpointStartCleanerState cleanerState = cleaner.getFilesAtCheckpointStart();
        if (!cleanerState.isEmpty()) {
            flushExtraLevel = true;
        }
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.flushStats.resetPerRunCounters();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        LogManager logManager = this.envImpl.getLogManager();
        DirtyINMap dirtyMap = new DirtyINMap(this.envImpl);
        try {
            long checkpointStart = -1L;
            long firstActiveLsn = -1L;
            Evictor evictor = this.envImpl.getEvictor();
            synchronized (evictor) {
                SingleItemEntry startEntry = new SingleItemEntry(LogEntryType.LOG_CKPT_START, new CheckpointStart(this.checkpointId, invokingSource));
                checkpointStart = logManager.log(startEntry);
                firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
                if (firstActiveLsn == -1L) {
                    firstActiveLsn = checkpointStart;
                } else if (DbLsn.compareTo(checkpointStart, firstActiveLsn) < 0) {
                    firstActiveLsn = checkpointStart;
                }
                dirtyMap.selectDirtyINsForCheckpoint(cleanerState.getDeferredWriteDbs());
            }
            dirtyMap.addCostToMemoryBudget();
            if (dirtyMap.getNumLevels() > 0) {
                if (flushAll) {
                    this.highestFlushLevel = this.envImpl.getDbMapTree().getHighestLevel();
                } else {
                    this.highestFlushLevel = dirtyMap.getHighestLevel();
                    if (flushExtraLevel) {
                        ++this.highestFlushLevel;
                    }
                }
            } else {
                this.highestFlushLevel = Integer.MAX_VALUE;
            }
            boolean allowDeltas = !config.getMinimizeRecoveryTime();
            boolean cleaningDeferredWriteDbs = cleanerState.getDeferredWriteDbsSize() > 0;
            Checkpointer.flushDirtyNodes(this.envImpl, dirtyMap, allowDeltas, checkpointStart, this.highestFlushLevel, this.flushStats, cleaningDeferredWriteDbs);
            this.flushUtilizationInfo();
            SingleItemEntry endEntry = new SingleItemEntry(LogEntryType.LOG_CKPT_END, new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, Node.getLastId(), this.envImpl.getDbMapTree().getLastDbId(), this.envImpl.getTxnManager().getLastTxnId(), this.checkpointId));
            this.trace(this.envImpl, invokingSource, true);
            traced = true;
            this.lastCheckpointEnd = logManager.logForceFlush(endEntry, true);
            this.lastFirstActiveLsn = firstActiveLsn;
            this.lastCheckpointStart = checkpointStart;
            this.highestFlushLevel = -1;
            success = true;
            cleaner.updateFilesAtCheckpointEnd(cleanerState);
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
            throw e;
        }
        finally {
            dirtyMap.removeCostFromMemoryBudget();
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuffer sb = new StringBuffer();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=");
        sb.append(this.flushStats.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=");
        sb.append(this.flushStats.nDeltaINFlushThisRun);
        Tracer.trace(Level.CONFIG, envImpl, sb.toString());
    }

    private void flushUtilizationInfo() throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.envImpl.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        TrackedFileSummary[] activeFiles = this.envImpl.getUtilizationTracker().getTrackedFiles();
        for (int i = 0; i < activeFiles.length; ++i) {
            profile.flushFileSummary(activeFiles[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncDatabase(EnvironmentImpl envImpl, DatabaseImpl dbImpl, boolean flushLog) throws DatabaseException {
        if (envImpl.isReadOnly()) {
            return;
        }
        DirtyINMap dirtyMap = new DirtyINMap(envImpl);
        FlushStats fstats = new FlushStats();
        try {
            Evictor evictor = envImpl.getEvictor();
            synchronized (evictor) {
                dirtyMap.selectDirtyINsForDb(dbImpl);
            }
            dirtyMap.addCostToMemoryBudget();
            Checkpointer.flushDirtyNodes(envImpl, dirtyMap, false, 0L, envImpl.getDbMapTree().getHighestLevel(dbImpl), fstats, false);
            if (flushLog) {
                envImpl.getLogManager().flush();
            }
        }
        catch (DatabaseException e) {
            Tracer.trace(envImpl, "Checkpointer", "syncDatabase", "of " + dbImpl.getDebugName(), e);
            throw e;
        }
        finally {
            dirtyMap.removeCostFromMemoryBudget();
        }
    }

    private static void flushDirtyNodes(EnvironmentImpl envImpl, DirtyINMap dirtyMap, boolean allowDeltas, long checkpointStart, int maxFlushLevel, FlushStats fstats, boolean cleaningDeferredWriteDbs) throws DatabaseException {
        TrackedFileSummary[] summaries;
        LogManager logManager = envImpl.getLogManager();
        boolean onlyFlushDeferredWriteDbs = false;
        UtilizationTracker tracker = new UtilizationTracker(envImpl);
        while (dirtyMap.getNumLevels() > 0) {
            Integer currentLevel = dirtyMap.getLowestLevelSet();
            int currentLevelVal = currentLevel;
            boolean logProvisionally = currentLevelVal != maxFlushLevel;
            Set nodeSet = dirtyMap.getSet(currentLevel);
            Iterator iter = nodeSet.iterator();
            while (iter.hasNext()) {
                CheckpointReference targetRef = (CheckpointReference)iter.next();
                if (!onlyFlushDeferredWriteDbs || onlyFlushDeferredWriteDbs && targetRef.db.isDeferredWrite()) {
                    envImpl.getEvictor().doCriticalEviction(true);
                    if (!targetRef.db.isDeleted()) {
                        Checkpointer.flushIN(envImpl, logManager, targetRef, dirtyMap, currentLevelVal, logProvisionally, allowDeltas, checkpointStart, fstats, tracker);
                    }
                    envImpl.sleepAfterBackgroundIO();
                }
                iter.remove();
            }
            dirtyMap.removeSet(currentLevel);
            if (currentLevelVal != maxFlushLevel) continue;
            if (!cleaningDeferredWriteDbs) break;
            onlyFlushDeferredWriteDbs = true;
        }
        if ((summaries = tracker.getTrackedFiles()).length > 0) {
            envImpl.getUtilizationProfile().countAndLogSummaries(summaries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushIN(EnvironmentImpl envImpl, LogManager logManager, CheckpointReference targetRef, DirtyINMap dirtyMap, int currentLevel, boolean logProvisionally, boolean allowDeltas, long checkpointStart, FlushStats fstats, UtilizationTracker tracker) throws DatabaseException {
        Tree tree = targetRef.db.getTree();
        boolean targetWasRoot = false;
        if (targetRef.isDbRoot) {
            RootFlusher flusher = new RootFlusher(targetRef.db, logManager, targetRef.nodeId);
            tree.withRootLatchedExclusive(flusher);
            boolean flushed = flusher.getFlushed();
            targetWasRoot = flusher.stillRoot();
            if (flushed) {
                DbTree dbTree = targetRef.db.getDbEnvironment().getDbMapTree();
                dbTree.modifyDbRoot(targetRef.db);
                ++fstats.nFullINFlushThisRun;
                ++fstats.nFullINFlush;
            }
        }
        if (!targetWasRoot) {
            SearchResult result = tree.getParentINForChildIN(targetRef.nodeId, targetRef.containsDuplicates, false, targetRef.mainTreeKey, targetRef.dupTreeKey, false, false, -1, null, false);
            if (result.parent != null) {
                boolean mustLogParent = false;
                try {
                    if (result.exactParentFound) {
                        IN renewedTarget = (IN)result.parent.getTarget(result.index);
                        mustLogParent = renewedTarget == null ? true : Checkpointer.logTargetAndUpdateParent(envImpl, renewedTarget, result.parent, result.index, allowDeltas, checkpointStart, logProvisionally, fstats, tracker);
                    } else if (result.childNotResident && result.parent.getLevel() > currentLevel) {
                        mustLogParent = true;
                    }
                    if (mustLogParent) {
                        if (!$assertionsDisabled && !Checkpointer.checkParentChildRelationship(result, currentLevel)) {
                            throw new AssertionError((Object)Checkpointer.dumpParentChildInfo(result, result.parent, targetRef.nodeId, currentLevel, tree));
                        }
                        dirtyMap.addDirtyIN(result.parent, true);
                    }
                }
                finally {
                    result.parent.releaseLatch();
                }
            }
        }
    }

    private static boolean checkParentChildRelationship(SearchResult result, int childLevel) {
        if (result.childNotResident && !result.exactParentFound) {
            return true;
        }
        int parentLevel = result.parent.getLevel();
        boolean isMapTree = (childLevel & 0x20000) != 0;
        boolean isMainTree = (childLevel & 0x10000) != 0;
        boolean checkOk = false;
        if (isMapTree || isMainTree) {
            if (parentLevel == childLevel + 1) {
                checkOk = true;
            }
        } else if (childLevel == 1) {
            if (parentLevel == 2) {
                checkOk = true;
            }
        } else if (parentLevel == 65537 || parentLevel == childLevel + 1) {
            checkOk = true;
        }
        return checkOk;
    }

    private static String dumpParentChildInfo(SearchResult result, IN parent, long childNodeId, int currentLevel, Tree tree) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(" result=").append(result);
        sb.append(" parent node=").append(parent.getNodeId());
        sb.append(" level=").append(parent.getLevel());
        sb.append(" child node=").append(childNodeId);
        sb.append(" level=").append(currentLevel);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean logTargetAndUpdateParent(EnvironmentImpl envImpl, IN target, IN parent, int index, boolean allowDeltas, long checkpointStart, boolean logProvisionally, FlushStats fstats, UtilizationTracker tracker) throws DatabaseException {
        long newLsn = -1L;
        boolean mustLogParent = true;
        target.latch(false);
        try {
            envImpl.lazyCompress(target, tracker);
            if (target.getDirty()) {
                if (target.getDatabase().isDeferredWrite()) {
                    target.logDirtyChildren();
                }
                newLsn = target.log(envImpl.getLogManager(), allowDeltas, logProvisionally, true, true, parent);
                if (allowDeltas && newLsn == -1L) {
                    ++fstats.nDeltaINFlushThisRun;
                    ++fstats.nDeltaINFlush;
                    long lastFullLsn = target.getLastFullVersion();
                    if (DbLsn.compareTo(lastFullLsn, checkpointStart) < 0) {
                        mustLogParent = false;
                    }
                }
            }
        }
        finally {
            target.releaseLatch();
        }
        if (newLsn != -1L) {
            ++fstats.nFullINFlushThisRun;
            ++fstats.nFullINFlush;
            if (target instanceof BIN) {
                ++fstats.nFullBINFlush;
                ++fstats.nFullBINFlushThisRun;
            }
            parent.updateEntry(index, newLsn);
        }
        return mustLogParent;
    }

    static {
        $assertionsDisabled = !Checkpointer.class.desiredAssertionStatus();
    }

    public static class FlushStats {
        public int nFullINFlush;
        public int nFullBINFlush;
        public int nDeltaINFlush;
        public int nFullINFlushThisRun;
        public int nFullBINFlushThisRun;
        public int nDeltaINFlushThisRun;

        void resetPerRunCounters() {
            this.nFullINFlushThisRun = 0;
            this.nFullBINFlushThisRun = 0;
            this.nDeltaINFlushThisRun = 0;
        }
    }

    public static class CheckpointReference {
        DatabaseImpl db;
        long nodeId;
        boolean containsDuplicates;
        boolean isDbRoot;
        byte[] mainTreeKey;
        byte[] dupTreeKey;

        public CheckpointReference(DatabaseImpl db, long nodeId, boolean containsDuplicates, boolean isDbRoot, byte[] mainTreeKey, byte[] dupTreeKey) {
            this.db = db;
            this.nodeId = nodeId;
            this.containsDuplicates = containsDuplicates;
            this.isDbRoot = isDbRoot;
            this.mainTreeKey = mainTreeKey;
            this.dupTreeKey = dupTreeKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointReference)) {
                return false;
            }
            CheckpointReference other = (CheckpointReference)o;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("db=").append(this.db.getId());
            sb.append(" nodeId=").append(this.nodeId);
            return sb.toString();
        }
    }

    private static class RootFlusher
    implements WithRootLatched {
        private DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private LogManager logManager;
        private long targetNodeId;

        RootFlusher(DatabaseImpl db, LogManager logManager, long targetNodeId) {
            this.db = db;
            this.flushed = false;
            this.logManager = logManager;
            this.targetNodeId = targetNodeId;
            this.stillRoot = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch(false);
            try {
                if (rootIN.getNodeId() == this.targetNodeId) {
                    if (rootIN.getDatabase().isDeferredWrite()) {
                        rootIN.logDirtyChildren();
                    }
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        long newLsn = rootIN.log(this.logManager);
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
            }
            finally {
                rootIN.releaseLatch();
            }
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

