/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil;

import java.nio.ByteBuffer;

public final class HexDumper {
    private HexDumper() {
    }

    public static String format(byte[] bytes) {
        return HexDumper.format(ByteBuffer.wrap(bytes));
    }

    public static String format(byte[] bytes, int limit) {
        return HexDumper.format(ByteBuffer.wrap(bytes), limit);
    }

    public static String format(ByteBuffer buf) {
        return HexDumper.format(buf, 0);
    }

    public static String format(ByteBuffer buf, int limit) {
        if (!buf.hasRemaining()) {
            return "[]";
        }
        boolean truncate = false;
        ByteBuffer readBuf = buf.slice().asReadOnlyBuffer();
        if (limit > 0 && limit < buf.remaining()) {
            truncate = true;
            readBuf.limit(limit);
        }
        StringBuilder s = new StringBuilder(3 * readBuf.remaining() + (truncate ? 3 : 0) + 1);
        s.append('[');
        s.append(String.format("%02x", readBuf.get()));
        while (readBuf.hasRemaining()) {
            s.append(String.format(" %02x", readBuf.get()));
        }
        if (truncate) {
            s.append("...");
        }
        s.append(']');
        return s.toString();
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            buf.append(String.format("%02x", b));
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String hexByte = hexString.substring(2 * i, 2 * i + 2);
            bytes[i] = Integer.valueOf(hexByte, 16).byteValue();
        }
        return bytes;
    }
}

