/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerWrapper {
    private static final String CLASS_NAME = LoggerWrapper.class.getName();
    private final Logger logger;

    public LoggerWrapper(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("null logger");
        }
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, String message) {
        if (this.logger.isLoggable(level)) {
            this.log(new LogRecord(level, message));
        }
    }

    public void log(Level level, String message, Object param) {
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, message);
            lr.setParameters(new Object[]{param});
            this.log(lr);
        }
    }

    public void log(Level level, String message, Object ... params) {
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, message);
            lr.setParameters(params);
            this.log(lr);
        }
    }

    public void logThrow(Level level, Throwable thrown, String message) {
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, message);
            lr.setThrown(thrown);
            this.log(lr);
        }
    }

    public void logThrow(Level level, Throwable thrown, String message, Object param) {
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, message);
            lr.setThrown(thrown);
            lr.setParameters(new Object[]{param});
            this.log(lr);
        }
    }

    public void logThrow(Level level, Throwable thrown, String message, Object ... params) {
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, message);
            lr.setThrown(thrown);
            lr.setParameters(params);
            this.log(lr);
        }
    }

    @Deprecated
    public void log(Level level, String message, Throwable param) {
        this.log(level, message, (Object)param);
    }

    @Deprecated
    public void log(Level level, String message, Throwable param, Object ... otherParams) {
        this.log(level, message, new Object[]{param, otherParams});
    }

    private void log(LogRecord lr) {
        StackTraceElement callerFrame = null;
        for (StackTraceElement frame : new Throwable().getStackTrace()) {
            if (CLASS_NAME.equals(frame.getClassName())) continue;
            callerFrame = frame;
            break;
        }
        if (callerFrame != null) {
            lr.setSourceClassName(callerFrame.getClassName());
            lr.setSourceMethodName(callerFrame.getMethodName());
        }
        try {
            this.logger.log(lr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

