/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil;

import java.io.UTFDataFormatException;

public class MessageBuffer {
    private final byte[] buf;
    private final int capacity;
    private int pos = 0;
    private int limit;

    public static int getSize(String str) {
        int utfLen = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c > '\u07ff') {
                utfLen += 3;
                continue;
            }
            utfLen += 2;
        }
        return utfLen + 2;
    }

    public MessageBuffer(int capacity) {
        this(new byte[capacity]);
        if (capacity == 0) {
            throw new IllegalArgumentException("capacity must be greater than 0");
        }
        this.limit = 1;
    }

    public MessageBuffer(byte[] buf) {
        this.buf = buf;
        this.capacity = buf.length;
        this.limit = buf.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public int limit() {
        return this.limit;
    }

    public int position() {
        return this.pos;
    }

    public void rewind() {
        this.pos = 0;
    }

    public MessageBuffer putByte(int b) {
        if (this.pos == this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buf[this.pos++] = (byte)b;
        this.limit = this.pos == this.capacity ? this.pos : this.pos + 1;
        return this;
    }

    public MessageBuffer putByteArray(byte[] bytes) {
        if (this.pos + 2 + bytes.length > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putShort(bytes.length);
        this.putBytes(bytes);
        return this;
    }

    public MessageBuffer putBytes(byte[] bytes) {
        if (this.pos + bytes.length > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        for (byte b : bytes) {
            this.putByte(b);
        }
        return this;
    }

    public MessageBuffer putChar(int v) {
        if (this.pos + 2 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putByte(v >>> 8 & 0xFF);
        this.putByte(v >>> 0 & 0xFF);
        return this;
    }

    public MessageBuffer putShort(int v) {
        if (this.pos + 2 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putByte(v >>> 8 & 0xFF);
        this.putByte(v >>> 0 & 0xFF);
        return this;
    }

    public MessageBuffer putInt(int v) {
        if (this.pos + 4 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putByte(v >>> 24 & 0xFF);
        this.putByte(v >>> 16 & 0xFF);
        this.putByte(v >>> 8 & 0xFF);
        this.putByte(v >>> 0 & 0xFF);
        return this;
    }

    public MessageBuffer putLong(long v) {
        if (this.pos + 8 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putByte((byte)(v >>> 56));
        this.putByte((byte)(v >>> 48));
        this.putByte((byte)(v >>> 40));
        this.putByte((byte)(v >>> 32));
        this.putByte((byte)(v >>> 24));
        this.putByte((byte)(v >>> 16));
        this.putByte((byte)(v >>> 8));
        this.putByte((byte)(v >>> 0));
        return this;
    }

    public MessageBuffer putString(String str) {
        char c;
        int size = MessageBuffer.getSize(str);
        if (this.pos + size > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.putShort(size - 2);
        int strlen = str.length();
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.buf[this.pos++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.pos++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buf[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.buf[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buf[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.limit = this.pos == this.capacity ? this.pos : this.pos + 1;
        return this;
    }

    public byte getByte() {
        if (this.pos == this.limit) {
            throw new IndexOutOfBoundsException();
        }
        byte b = this.buf[this.pos++];
        return b;
    }

    public byte[] getByteArray() {
        int savePos = this.pos;
        try {
            return this.getBytes(this.getUnsignedShort());
        }
        catch (IndexOutOfBoundsException e) {
            this.pos = savePos;
            throw e;
        }
    }

    public byte[] getBytes(int size) {
        if (this.pos + size > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = this.getByte();
        }
        return bytes;
    }

    public short getShort() {
        if (this.pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return (short)((this.getByte() << 8) + (this.getByte() & 0xFF));
    }

    public int getUnsignedShort() {
        if (this.pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return ((this.getByte() & 0xFF) << 8) + ((this.getByte() & 0xFF) << 0);
    }

    public int getInt() {
        if (this.pos + 4 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return ((this.getByte() & 0xFF) << 24) + ((this.getByte() & 0xFF) << 16) + ((this.getByte() & 0xFF) << 8) + ((this.getByte() & 0xFF) << 0);
    }

    public long getLong() {
        if (this.pos + 8 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return ((long)(this.getByte() & 0xFF) << 56) + ((long)(this.getByte() & 0xFF) << 48) + ((long)(this.getByte() & 0xFF) << 40) + ((long)(this.getByte() & 0xFF) << 32) + ((long)(this.getByte() & 0xFF) << 24) + ((long)(this.getByte() & 0xFF) << 16) + ((long)(this.getByte() & 0xFF) << 8) + ((long)(this.getByte() & 0xFF) << 0);
    }

    public char getChar() {
        if (this.pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return (char)((this.getByte() << 8) + (this.getByte() & 0xFF));
    }

    public String getString() {
        int c;
        if (this.pos + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int savePos = this.pos;
        int utfLen = this.getUnsignedShort();
        int utfEnd = utfLen + this.pos;
        if (utfEnd > this.limit) {
            this.pos = savePos;
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[utfLen * 2];
        int index = 0;
        while (this.pos < utfEnd && (c = this.buf[this.pos] & 0xFF) <= 127) {
            ++this.pos;
            chars[index++] = (char)c;
        }
        try {
            block8: while (this.pos < utfEnd) {
                c = this.buf[this.pos] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++this.pos;
                        chars[index++] = (char)c;
                        continue block8;
                    }
                    case 12: 
                    case 13: {
                        this.pos += 2;
                        if (this.pos > utfEnd) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = this.buf[this.pos - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + this.pos);
                        }
                        chars[index++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block8;
                    }
                    case 14: {
                        this.pos += 3;
                        if (this.pos > utfEnd) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = this.buf[this.pos - 2];
                        byte char3 = this.buf[this.pos - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (this.pos - 1));
                        }
                        chars[index++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block8;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + this.pos);
            }
        }
        catch (UTFDataFormatException e) {
            this.pos = savePos;
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return new String(chars, 0, index);
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

