/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil;

import com.sun.sgs.impl.sharedutil.Objects;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesWrapper {
    private final Properties properties;

    public PropertiesWrapper(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("The argument must not be null");
        }
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.properties.getProperty(name);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public int getIntProperty(String name, int defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw (NumberFormatException)new NumberFormatException("The value of the " + name + " property must be a valid " + "int: \"" + value + "\"").initCause(e);
        }
    }

    public int getRequiredIntProperty(String name) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("The " + name + " property must be specified");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw (NumberFormatException)new NumberFormatException("The value of the " + name + " property must be a valid " + "int: \"" + value + "\"").initCause(e);
        }
    }

    public int getIntProperty(String name, int defaultValue, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("The min must not be greater than the max");
        }
        if (min > defaultValue || defaultValue > max) {
            throw new IllegalArgumentException("The default value must be between the min and the max");
        }
        int result = this.getIntProperty(name, defaultValue);
        if (min > result) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be less " + "than " + min + ": " + result);
        }
        if (result > max) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be greater " + "than " + max + ": " + result);
        }
        return result;
    }

    public int getRequiredIntProperty(String name, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("The min must not be greater than the max");
        }
        int result = this.getRequiredIntProperty(name);
        if (min > result) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be less " + "than " + min + ": " + result);
        }
        if (result > max) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be greater " + "than " + max + ": " + result);
        }
        return result;
    }

    public long getLongProperty(String name, long defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw (NumberFormatException)new NumberFormatException("The value of the " + name + " property must be a valid " + "long: \"" + value + "\"").initCause(e);
        }
    }

    public long getLongProperty(String name, long defaultValue, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("The min must not be greater than the max");
        }
        if (min > defaultValue || defaultValue > max) {
            throw new IllegalArgumentException("The default value must be between the min and the max");
        }
        long result = this.getLongProperty(name, defaultValue);
        if (min > result) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be less " + "than " + min + ": " + result);
        }
        if (result > max) {
            throw new IllegalArgumentException("The value of the " + name + " property must not be greater " + "than " + max + ": " + result);
        }
        return result;
    }

    public <T> T getClassInstanceProperty(String name, Class<T> type, Class<?>[] paramTypes, Object ... args) {
        String className = this.properties.getProperty(name);
        if (className == null) {
            return null;
        }
        return this.getClassInstance(name, className, type, paramTypes, args);
    }

    public <T> T getClassInstanceProperty(String name, String defaultClass, Class<T> type, Class<?>[] paramTypes, Object ... args) {
        T instance = this.getClassInstanceProperty(name, type, paramTypes, args);
        if (instance != null) {
            return instance;
        }
        if (defaultClass == null) {
            return null;
        }
        return this.getClassInstance(name, defaultClass, type, paramTypes, args);
    }

    private <T> T getClassInstance(String name, String className, Class<T> type, Class<?>[] paramTypes, Object ... args) {
        if (className == null) {
            throw new NullPointerException("null className");
        }
        try {
            return Class.forName(className).asSubclass(type).getConstructor(paramTypes).newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The class " + className + this.getPropertyText(name) + " was not found", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The class " + className + this.getPropertyText(name) + " does not implement " + type.getName(), e);
        }
        catch (NoSuchMethodException e) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Class<?> paramType : paramTypes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(paramType.getName());
            }
            throw new IllegalArgumentException("The class " + className + this.getPropertyText(name) + " does not have a constructor with required parameters: " + sb, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalArgumentException("Calling the constructor for the class " + className + this.getPropertyText(name) + " throws: " + cause, cause);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Creating an instance of the class " + className + this.getPropertyText(name) + " throws: " + e, e);
        }
    }

    private String getPropertyText(String name) {
        return name != null ? ", specified by the property: " + name + "," : "";
    }

    public <T extends Enum<T>> T getEnumProperty(String name, Class<T> enumType, T defaultValue) {
        Objects.checkNull("name", name);
        Objects.checkNull("enumType", enumType);
        Objects.checkNull("defaultValue", defaultValue);
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The value of the " + name + " property was \"" + value + "\", but must be one of: " + Arrays.toString(enumType.getEnumConstants()));
        }
    }

    public <T> List<T> getListProperty(String name, Class<T> type, T defaultElement) {
        Objects.checkNull("name", name);
        Objects.checkNull("type", type);
        ArrayList<T> list = new ArrayList<T>();
        String value = this.properties.getProperty(name);
        if (value == null) {
            return list;
        }
        String[] values = value.split(":", -1);
        Class[] constructorParams = new Class[]{String.class};
        Constructor<T> constructor = null;
        try {
            constructor = type.getConstructor(constructorParams);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("The class " + type.getName() + " does not have a " + "constructor with the required parameter : String", nsme);
        }
        for (String v : values) {
            if (v.equals("")) {
                list.add(defaultElement);
                continue;
            }
            try {
                list.add(constructor.newInstance(v));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Creating an instance of the class " + type.getName() + " throws: " + e, e);
            }
        }
        return list;
    }

    public <T extends Enum<T>> List<T> getEnumListProperty(String name, Class<T> enumType, T defaultElement) {
        String[] values;
        Objects.checkNull("name", name);
        Objects.checkNull("enumType", enumType);
        ArrayList<T> list = new ArrayList<T>();
        String value = this.properties.getProperty(name);
        if (value == null) {
            return list;
        }
        for (String v : values = value.split(":", -1)) {
            if (v.equals("")) {
                list.add(defaultElement);
                continue;
            }
            try {
                list.add(Enum.valueOf(enumType, v));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("A value in the list of items in the " + name + " property was \"" + v + "\", but must be one of: " + Arrays.toString(enumType.getEnumConstants()));
            }
        }
        return list;
    }

    public List<Class<?>> getClassListProperty(String name) {
        String[] values;
        Objects.checkNull("name", name);
        ArrayList list = new ArrayList();
        String value = this.properties.getProperty(name);
        if (value == null) {
            return list;
        }
        for (String v : values = value.split(":", -1)) {
            if (v.equals("")) {
                list.add(null);
                continue;
            }
            try {
                list.add(Class.forName(v));
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("A value in the list of items in the " + name + " property was \"" + v + "\", but a class was not found for this value", cnfe);
            }
        }
        return list;
    }
}

