/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ExceptionFilter
implements Filter {
    public static final String EXCEPTION_CLASS_PROPERTY = "com.sun.sgs.impl.sharedutil.logging.ExceptionFilter.exception";
    public static final String LEVEL_PROPERTY = "com.sun.sgs.impl.sharedutil.logging.ExceptionFilter.level";
    private final Class<? extends Throwable> exceptionClass;
    private final Level level;

    public ExceptionFilter() throws ClassNotFoundException {
        LogManager logManager = LogManager.getLogManager();
        String value = logManager.getProperty(EXCEPTION_CLASS_PROPERTY);
        this.exceptionClass = value != null ? Class.forName(value).asSubclass(Throwable.class) : Throwable.class;
        value = logManager.getProperty(LEVEL_PROPERTY);
        this.level = value != null ? Level.parse(value) : Level.INFO;
    }

    public boolean isLoggable(LogRecord record) {
        return this.exceptionClass.isInstance(record.getThrown()) || record.getLevel().intValue() >= this.level.intValue();
    }
}

