/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static final String DEFAULT_TIME_FORMAT = "%tF %1$tT.%1$tL";
    public static final String TIME_FORMAT_PROPERTY = "com.sun.sgs.impl.sharedutil.logging.LogFormatter.time.format";
    public static final String PRINT_STACK_PROPERTY = "com.sun.sgs.impl.sharedutil.logging.LogFormatter.print.stack";
    private final String timeFormat;
    private final boolean printStack;

    public LogFormatter() {
        LogManager logManager = LogManager.getLogManager();
        String value = logManager.getProperty(TIME_FORMAT_PROPERTY);
        this.timeFormat = value != null ? value : DEFAULT_TIME_FORMAT;
        value = logManager.getProperty(PRINT_STACK_PROPERTY);
        this.printStack = value == null || Boolean.parseBoolean(value);
    }

    public String format(LogRecord record) {
        java.util.Formatter formatter = new java.util.Formatter();
        formatter.format(this.timeFormat, record.getMillis());
        if (record.getSourceClassName() != null) {
            formatter.format(": %s", record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                formatter.format(".%s", record.getSourceMethodName());
            }
        } else {
            formatter.format(": %s", record.getLoggerName());
        }
        formatter.format("%n%s: %s%n", record.getLevel().getLocalizedName(), this.formatMessage(record));
        if (record.getThrown() != null) {
            if (this.printStack) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                formatter.format("%s%n", sw.toString());
            } else {
                formatter.format("%s%n", record.getThrown());
            }
        }
        return formatter.toString();
    }
}

