/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sgs.impl.sharedutil.logging;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ResamplingUrlLogConfiguration {
    private static final Logger logger = Logger.getLogger(ResamplingUrlLogConfiguration.class.getName());
    public static final String CONFIG_FILE_PROPERTY = "java.util.logging.config.file";
    private static final String CONFIG_FILE_DEFAULT = System.getProperty("java.home") + "/lib/logging.properties";
    public static final String RESAMPLE_INTERVAL_PROPERTY = "com.sun.sgs.impl.sharedutil.logging.ResamplingUrlLogConfiguration.interval";
    public static final long RESAMPLE_INTERVAL_DEFAULT = 30000L;
    private static final URL configFileContext;
    private static final Object lock;
    private static boolean initialized;
    private static long resampleInterval;
    private static long lastRead;
    private static String lastException;

    public ResamplingUrlLogConfiguration() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            boolean done = false;
            try {
                ResamplingUrlLogConfiguration.readConfiguration();
                ResamplingUrlLogConfiguration.resampleLoop();
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!done) {
                    initialized = false;
                }
            }
        }
    }

    private static void resampleLoop() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    long wait;
                    long last = System.currentTimeMillis();
                    long when = last + resampleInterval;
                    while ((wait = when - System.currentTimeMillis()) > 0L) {
                        try {
                            Thread.sleep(wait);
                        }
                        catch (InterruptedException e) {}
                    }
                    ResamplingUrlLogConfiguration.readConfiguration();
                }
            }
        }, "ResamplingUrlLogConfiguration.resampleLoop");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfiguration() {
        block10: {
            try {
                String configFile = System.getProperty(CONFIG_FILE_PROPERTY, CONFIG_FILE_DEFAULT);
                URL url = new URL(configFileContext, configFile);
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                connection.connect();
                long lastModified = connection.getLastModified();
                if (lastModified <= lastRead) break block10;
                lastRead = lastModified;
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(connection.getInputStream());
                    LogManager.getLogManager().readConfiguration(in);
                    ResamplingUrlLogConfiguration.updateResampleInterval();
                    lastException = null;
                    logger.log(Level.INFO, "Read configuration {0}", configFile);
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (Exception e) {
                ResamplingUrlLogConfiguration.printException("Error reading logging configuration file: " + e);
            }
        }
    }

    private static void updateResampleInterval() {
        String resampleIntervalProperty = LogManager.getLogManager().getProperty(RESAMPLE_INTERVAL_PROPERTY);
        if (resampleIntervalProperty != null) {
            try {
                resampleInterval = Long.parseLong(resampleIntervalProperty);
            }
            catch (NumberFormatException e) {
                ResamplingUrlLogConfiguration.printException("Problem parsing the com.sun.sgs.impl.sharedutil.logging.ResamplingUrlLogConfiguration.interval logging configuration property: " + e);
            }
        }
    }

    private static void printException(String message) {
        if (!message.equals(lastException)) {
            System.err.println(message);
            lastException = message;
        }
    }

    static {
        try {
            configFileContext = new URL("file://localhost/");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
        lock = new Object();
        resampleInterval = 30000L;
        lastRead = 0L;
        lastException = null;
    }
}

