/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public final class FileText
extends AbstractList<String> {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final Pattern LINE_TERMINATOR = Pattern.compile("\\n|\\r\\n?");
    private final File file;
    private final Charset charset;
    private final String fullText;
    private final String[] lines;
    private int[] lineBreaks;

    public FileText(File file, String charsetName) throws IOException {
        String line;
        CharsetDecoder decoder;
        this.file = file;
        try {
            this.charset = Charset.forName(charsetName);
            decoder = this.charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (UnsupportedCharsetException ex) {
            String message = "Unsupported charset: " + charsetName;
            UnsupportedEncodingException ex2 = new UnsupportedEncodingException(message);
            ex2.initCause(ex);
            throw ex2;
        }
        this.fullText = FileText.readFile(file, decoder);
        ArrayList<String> textLines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(this.fullText));
        while ((line = br.readLine()) != null) {
            textLines.add(line);
        }
        this.lines = textLines.toArray(new String[textLines.size()]);
    }

    private FileText(File file, List<String> lines) {
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            buf.append(line).append('\n');
        }
        buf.trimToSize();
        this.file = file;
        this.charset = null;
        this.fullText = buf.toString();
        this.lines = lines.toArray(new String[lines.size()]);
    }

    public FileText(FileText fileText) {
        this.file = fileText.file;
        this.charset = fileText.charset;
        this.fullText = fileText.fullText;
        this.lines = (String[])fileText.lines.clone();
        this.lineBreaks = ArrayUtils.clone((int[])fileText.lineBreaks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File inputFile, CharsetDecoder decoder) throws IOException {
        if (!inputFile.exists()) {
            throw new FileNotFoundException(inputFile.getPath() + " (No such file or directory)");
        }
        StringBuilder buf = new StringBuilder();
        FileInputStream stream = new FileInputStream(inputFile);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, decoder);
        try {
            int len;
            char[] chars = new char[1024];
            while ((len = reader.read(chars)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        finally {
            Closeables.closeQuietly((Reader)reader);
        }
        return buf.toString();
    }

    public static FileText fromLines(File file, List<String> lines) {
        if (lines instanceof FileText) {
            return (FileText)lines;
        }
        return new FileText(file, lines);
    }

    public File getFile() {
        return this.file;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public CharSequence getFullText() {
        return this.fullText;
    }

    public String[] toLinesArray() {
        return (String[])this.lines.clone();
    }

    private int[] findLineBreaks() {
        if (this.lineBreaks == null) {
            int[] lineBreakPositions = new int[this.size() + 1];
            lineBreakPositions[0] = 0;
            int lineNo = 1;
            Matcher matcher = LINE_TERMINATOR.matcher(this.fullText);
            while (matcher.find()) {
                lineBreakPositions[lineNo] = matcher.end();
                ++lineNo;
            }
            if (lineNo < lineBreakPositions.length) {
                lineBreakPositions[lineNo] = this.fullText.length();
            }
            this.lineBreaks = lineBreakPositions;
        }
        return this.lineBreaks;
    }

    public LineColumn lineColumn(int pos) {
        int[] lineBreakPositions = this.findLineBreaks();
        int lineNo = Arrays.binarySearch(lineBreakPositions, pos);
        if (lineNo < 0) {
            lineNo = -lineNo - 2;
        }
        int startOfLine = lineBreakPositions[lineNo];
        int columnNo = pos - startOfLine;
        return new LineColumn(lineNo + 1, columnNo);
    }

    @Override
    public String get(int lineNo) {
        return this.lines[lineNo];
    }

    @Override
    public int size() {
        return this.lines.length;
    }
}

