/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEvemtFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.Locale;

public class AuditEventDefaultFormatter
implements AuditEvemtFormatter {
    private static final int LENGTH_OF_ALL_SEPARATORS = 10;

    @Override
    public String format(AuditEvent event) {
        String fileName = event.getFileName();
        String message = event.getMessage();
        SeverityLevel severityLevel = event.getSeverityLevel();
        String severityLevelName = severityLevel == SeverityLevel.WARNING ? "WARN" : severityLevel.getName().toUpperCase(Locale.US);
        int bufLen = AuditEventDefaultFormatter.calculateBufferLength(event, severityLevelName.length());
        StringBuilder sb = new StringBuilder(bufLen);
        sb.append('[').append(severityLevelName).append("] ").append(fileName).append(':').append(event.getLine());
        if (event.getColumn() > 0) {
            sb.append(':').append(event.getColumn());
        }
        sb.append(": ").append(message);
        String checkShortName = AuditEventDefaultFormatter.getCheckShortName(event);
        sb.append(" [").append(checkShortName).append(']');
        return sb.toString();
    }

    private static int calculateBufferLength(AuditEvent event, int severityLevelNameLength) {
        return 10 + event.getFileName().length() + event.getMessage().length() + severityLevelNameLength + AuditEventDefaultFormatter.getCheckShortName(event).length();
    }

    private static String getCheckShortName(AuditEvent event) {
        String checkFullName = event.getSourceName();
        return checkFullName.substring(checkFullName.lastIndexOf(46) + 1, checkFullName.lastIndexOf("Check"));
    }
}

