/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.annotation.CachedGauge;
import com.ryantenney.metrics.spring.AbstractAnnotationBeanPostProcessor;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class CachedGaugeAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements Ordered {
    private static final AnnotationFilter FILTER = new AnnotationFilter(CachedGauge.class, 2487);
    private final MetricRegistry metrics;

    public CachedGaugeAnnotationBeanPostProcessor(MetricRegistry metrics) {
        super(AbstractAnnotationBeanPostProcessor.Members.METHODS, AbstractAnnotationBeanPostProcessor.Phase.POST_INIT, FILTER);
        this.metrics = metrics;
    }

    @Override
    protected void withMethod(final Object bean, String beanName, Class<?> targetClass, final Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Method " + method.getName() + " is annotated with @CachedGauge but requires parameters.");
        }
        CachedGauge annotation = method.getAnnotation(CachedGauge.class);
        String metricName = Util.forCachedGauge(targetClass, method, annotation);
        this.metrics.register(metricName, (Metric)new com.codahale.metrics.CachedGauge<Object>(annotation.timeout(), annotation.timeoutUnit()){

            protected Object loadValue() {
                return ReflectionUtils.invokeMethod((Method)method, (Object)bean);
            }
        });
        this.LOG.debug("Created cached gauge {} for method {}.{}", new Object[]{metricName, targetClass.getCanonicalName(), method.getName()});
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

