/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.annotation.Counted;
import com.ryantenney.metrics.spring.AbstractMetricMethodInterceptor;
import com.ryantenney.metrics.spring.AdviceFactory;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.util.ReflectionUtils;

class CountedMethodInterceptor
extends AbstractMetricMethodInterceptor<Counted, Counter> {
    public static final Class<Counted> ANNOTATION = Counted.class;
    public static final Pointcut POINTCUT = new AnnotationMatchingPointcut(null, ANNOTATION);
    public static final ReflectionUtils.MethodFilter METHOD_FILTER = new AnnotationFilter(ANNOTATION, 2469);

    public CountedMethodInterceptor(MetricRegistry metricRegistry, Class<?> targetClass) {
        super(metricRegistry, targetClass, ANNOTATION, METHOD_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invoke(MethodInvocation invocation, Counter counter, Counted annotation) throws Throwable {
        try {
            counter.inc();
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (!annotation.monotonic()) {
                counter.dec();
            }
        }
    }

    @Override
    protected Counter buildMetric(MetricRegistry metricRegistry, String metricName, Counted annotation) {
        return metricRegistry.counter(metricName);
    }

    @Override
    protected String buildMetricName(Class<?> targetClass, Method method, Counted annotation) {
        return Util.forCountedMethod(targetClass, method, annotation);
    }

    static AdviceFactory adviceFactory(final MetricRegistry metricRegistry) {
        return new AdviceFactory(){

            @Override
            public Advice getAdvice(Object bean, Class<?> targetClass) {
                return new CountedMethodInterceptor(metricRegistry, targetClass);
            }
        };
    }
}

