/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config.annotation;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.ryantenney.metrics.spring.MetricsBeanPostProcessorFactory;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import java.util.Map;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public class MetricsConfigurationSupport
implements ImportAware {
    private final Object lock = new Object();
    private volatile MetricRegistry metricRegistry;
    private volatile HealthCheckRegistry healthCheckRegistry;
    private ProxyConfig proxyConfig;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableMetrics = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMetrics.class.getName(), false));
        Assert.notNull((Object)enableMetrics, (String)("@" + EnableMetrics.class.getSimpleName() + " is not present on importing class " + importMetadata.getClassName()));
        this.proxyConfig = new ProxyConfig();
        this.proxyConfig.setExposeProxy(enableMetrics.getBoolean("exposeProxy"));
        this.proxyConfig.setProxyTargetClass(enableMetrics.getBoolean("proxyTargetClass"));
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor exceptionMeteredAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.exceptionMetered(this.getMetricRegistry(), this.proxyConfig);
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor meteredAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.metered(this.getMetricRegistry(), this.proxyConfig);
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor timedAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.timed(this.getMetricRegistry(), this.proxyConfig);
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor countedAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.counted(this.getMetricRegistry(), this.proxyConfig);
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor gaugeFieldAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.gaugeField(this.getMetricRegistry());
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor gaugeMethodAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.gaugeMethod(this.getMetricRegistry());
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor cachedGaugeAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.cachedGauge(this.getMetricRegistry());
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor metricAnnotationBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.metric(this.getMetricRegistry());
    }

    @Bean
    @Role(value=2)
    public BeanPostProcessor healthCheckBeanPostProcessor() {
        return MetricsBeanPostProcessorFactory.healthCheck(this.getHealthCheckRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.metricRegistry == null) {
                    this.metricRegistry = new MetricRegistry();
                }
            }
        }
        return this.metricRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheckRegistry getHealthCheckRegistry() {
        if (this.healthCheckRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.healthCheckRegistry == null) {
                    this.healthCheckRegistry = new HealthCheckRegistry();
                }
            }
        }
        return this.healthCheckRegistry;
    }
}

