/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class GangliaReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<GangliaReporter> {
    public static final String GROUP = "group";
    public static final String PORT = "port";
    public static final String UDP_MODE = "udp-mode";
    public static final String TTL = "ttl";
    public static final String PERIOD = "period";
    public static final String PREFIX = "prefix";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";
    public static final String PROTOCOL = "protocol";
    public static final String UUID = "uuid";
    public static final String SPOOF = "spoof";
    public static final String DMAX = "dmax";
    public static final String TMAX = "tmax";

    @Override
    public Class<GangliaReporter> getObjectType() {
        return GangliaReporter.class;
    }

    @Override
    protected GangliaReporter createInstance() throws Exception {
        GangliaReporter.Builder reporter = GangliaReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(PREFIX)) {
            reporter.prefixedWith(this.getProperty(PREFIX));
        }
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        if (this.hasProperty(DMAX)) {
            reporter.withDMax(this.getProperty(DMAX, Integer.TYPE).intValue());
        }
        if (this.hasProperty(TMAX)) {
            reporter.withTMax(this.getProperty(TMAX, Integer.TYPE).intValue());
        }
        GMetric gMetric = new GMetric(this.getProperty(GROUP), this.getProperty(PORT, Integer.TYPE).intValue(), this.getProperty(UDP_MODE, GMetric.UDPAddressingMode.class), this.getProperty(TTL, Integer.TYPE).intValue(), !this.hasProperty(PROTOCOL) || this.getProperty(PROTOCOL).contains("3.1"), this.hasProperty(UUID) ? java.util.UUID.fromString(this.getProperty(UUID)) : null, this.getProperty(SPOOF));
        return reporter.build(gMetric);
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }
}

