/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.MethodDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DefaultCallOptionsClientInterceptor
implements ClientInterceptor {
    private static final Field CUSTOM_OPTIONS_FIELD = DefaultCallOptionsClientInterceptor.getCustomOptionsField();
    private CallOptions defaultOptions;
    private boolean overwrite = false;

    private static Field getCustomOptionsField() {
        try {
            Field f = CallOptions.class.getDeclaredField("customOptions");
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public DefaultCallOptionsClientInterceptor(CallOptions options) {
        this.defaultOptions = Preconditions.checkNotNull(options, "defaultOptions");
    }

    public DefaultCallOptionsClientInterceptor overwriteExistingValues() {
        this.overwrite = true;
        return this;
    }

    public CallOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(CallOptions options) {
        this.defaultOptions = options;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return next.newCall(method, this.patchOptions(callOptions));
    }

    @VisibleForTesting
    CallOptions patchOptions(CallOptions baseOptions) {
        CallOptions patchedOptions = baseOptions;
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getAuthority, CallOptions::withAuthority);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getCredentials, CallOptions::withCallCredentials);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getCompressor, CallOptions::withCompression);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getDeadline, CallOptions::withDeadline);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::isWaitForReady, (callOptions, waitForReady) -> waitForReady != false ? callOptions.withWaitForReady() : callOptions.withoutWaitForReady());
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getMaxInboundMessageSize, CallOptions::withMaxInboundMessageSize);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getMaxOutboundMessageSize, CallOptions::withMaxOutboundMessageSize);
        patchedOptions = this.patchOption(patchedOptions, CallOptions::getExecutor, CallOptions::withExecutor);
        for (ClientStreamTracer.Factory factory : this.defaultOptions.getStreamTracerFactories()) {
            patchedOptions = patchedOptions.withStreamTracerFactory(factory);
        }
        for (CallOptions.Key key : this.customOptionKeys(this.defaultOptions)) {
            patchedOptions = this.patchOption(patchedOptions, co -> co.getOption(key), (co, o) -> co.withOption(key, o));
        }
        return patchedOptions;
    }

    private <T> CallOptions patchOption(CallOptions baseOptions, Function<CallOptions, T> getter, BiFunction<CallOptions, T, CallOptions> setter) {
        T patchValue;
        T baseValue = getter.apply(baseOptions);
        if ((baseValue == null || this.overwrite) && (patchValue = getter.apply(this.defaultOptions)) != null) {
            return setter.apply(baseOptions, (CallOptions)patchValue);
        }
        return baseOptions;
    }

    private List<CallOptions.Key<Object>> customOptionKeys(CallOptions callOptions) {
        try {
            Object[][] customOptions = (Object[][])CUSTOM_OPTIONS_FIELD.get(callOptions);
            ArrayList<CallOptions.Key<Object>> keys = new ArrayList<CallOptions.Key<Object>>(customOptions.length);
            for (Object[] arr : customOptions) {
                keys.add((CallOptions.Key)arr[0]);
            }
            return keys;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

