/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.xfcc;

import com.salesforce.grpc.contrib.xfcc.XForwardedClientCert;
import com.salesforce.grpc.contrib.xfcc.XfccMarshaller;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.List;

public final class XfccServerInterceptor
implements ServerInterceptor {
    private static final Metadata.Key<List<XForwardedClientCert>> XFCC_METADATA_KEY = Metadata.Key.of("x-forwarded-client-cert", new XfccMarshaller());

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Iterable<List<XForwardedClientCert>> values = headers.getAll(XFCC_METADATA_KEY);
        if (values != null) {
            ArrayList<XForwardedClientCert> xfccs = new ArrayList<XForwardedClientCert>();
            for (List<XForwardedClientCert> value : values) {
                xfccs.addAll(value);
            }
            Context xfccContext = Context.current().withValue(XForwardedClientCert.XFCC_CONTEXT_KEY, xfccs);
            return Contexts.interceptCall(xfccContext, call, headers, next);
        }
        return next.startCall(call, headers);
    }
}

