/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationSelector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
extends DaemonThread {
    private static final String CLEAN_IN = "CleanIN:";
    private static final String CLEAN_LN = "CleanLN:";
    private static final String CLEAN_DELTA = "CleanDelta:";
    private EnvironmentImpl env;
    private long lockTimeout;
    private Set filesToDelete;
    private int nCleanerRuns = 0;
    private int nCleanerDeletions = 0;
    private int nINsCleaned = 0;
    private int nINsMigrated = 0;
    private int nLNsCleaned = 0;
    private int nLNsDead = 0;
    private int nLNsLocked = 0;
    private int nLNsMigrated = 0;
    private int nDeltasCleaned = 0;
    private int nEntriesRead = 0;
    private long nRepeatIteratorReads = 0L;
    private int nINsCleanedThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nDeltasCleanedThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;
    private boolean expunge = false;
    private UtilizationSelector fileSelector;
    private UtilizationProfile profile;
    private Level detailedTraceLevel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Cleaner(EnvironmentImpl env, long waitTime, String name, UtilizationProfile profile) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.profile = profile;
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.CLEANER_LOCK_TIMEOUT));
        this.expunge = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.fileSelector = new UtilizationSelector(env, profile);
        this.filesToDelete = new HashSet();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_CLEANER);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cleaner name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Cleaner.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNCleanerRuns(this.nCleanerRuns);
        stat.setNCleanerDeletions(this.nCleanerDeletions);
        stat.setNINsCleaned(this.nINsCleaned);
        stat.setNINsMigrated(this.nINsMigrated);
        stat.setNLNsCleaned(this.nLNsCleaned);
        stat.setNLNsDead(this.nLNsDead);
        stat.setNLNsLocked(this.nLNsLocked);
        stat.setNLNsMigrated(this.nLNsMigrated);
        stat.setNDeltasCleaned(this.nDeltasCleaned);
        stat.setNCleanerEntriesRead(this.nEntriesRead);
        stat.setNRepeatIteratorReads(this.nRepeatIteratorReads);
        if (config.getClear()) {
            this.nCleanerRuns = 0;
            this.nCleanerDeletions = 0;
            this.nINsCleaned = 0;
            this.nINsMigrated = 0;
            this.nLNsCleaned = 0;
            this.nLNsDead = 0;
            this.nLNsLocked = 0;
            this.nLNsMigrated = 0;
            this.nDeltasCleaned = 0;
            this.nEntriesRead = 0;
            this.nRepeatIteratorReads = 0L;
        }
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
    }

    private boolean interruptCleaning() {
        return false;
    }

    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        int nOriginalLogFiles = this.profile.getNumberOfFiles();
        boolean anyProgress = false;
        int nFilesCleaned = 0;
        while (nFilesCleaned < nOriginalLogFiles && !this.isShutdownRequested()) {
            Object var21_20;
            boolean canDeleteFile;
            Long fileNum;
            boolean finished;
            UtilizationSelector.RetryInfo fileRetryInfo;
            block17: {
                Set set = this.filesToDelete;
                synchronized (set) {
                    fileRetryInfo = this.fileSelector.getFileToClean(this.filesToDelete, forceCleaning);
                }
                if (fileRetryInfo == null) break;
                this.resetPerRunCounters();
                finished = false;
                fileNum = null;
                long fileNumValue = 0L;
                canDeleteFile = false;
                try {
                    ++this.nCleanerRuns;
                    if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                        throw new AssertionError();
                    }
                    fileNum = fileRetryInfo.getFileNumber();
                    fileNumValue = fileNum;
                    Tracer.trace(Level.INFO, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + "0x" + Long.toHexString(fileNumValue) + " begins");
                    long[] pendingLsns = fileRetryInfo.getPendingLsns();
                    if (pendingLsns != null && this.processPending(pendingLsns, fileRetryInfo)) {
                        anyProgress = true;
                    }
                    if (!fileRetryInfo.isFileFullyProcessed()) {
                        long startLsn;
                        DbConfigManager cm = this.env.getConfigManager();
                        int readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
                        CleanerFileReader cleanerFileReader = new CleanerFileReader(this.env, readBufferSize, startLsn = fileRetryInfo.getFirstUnprocessedLsn(), fileNum);
                        if (this.processFile(cleanerFileReader, fileRetryInfo)) {
                            anyProgress = true;
                        }
                        this.nRepeatIteratorReadsThisRun = cleanerFileReader.getNRepeatIteratorReads();
                    }
                    if (fileRetryInfo.canFileBeDeleted()) {
                        Set set2 = this.filesToDelete;
                        synchronized (set2) {
                            this.filesToDelete.add(fileNum);
                        }
                        canDeleteFile = true;
                        ++nFilesCleaned;
                    }
                    this.accumulatePerRunCounters();
                    finished = true;
                    if (cleanMultipleFiles) break block17;
                    var21_20 = null;
                    fileRetryInfo.endProcessing(canDeleteFile);
                    Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                    break;
                }
                catch (Throwable throwable) {
                    var21_20 = null;
                    fileRetryInfo.endProcessing(canDeleteFile);
                    Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                    throw throwable;
                }
            }
            var21_20 = null;
            fileRetryInfo.endProcessing(canDeleteFile);
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
            {
                continue;
                catch (IOException IOE) {
                    Tracer.trace(this.env, "Cleaner", "doClean", "", IOE);
                    throw new DatabaseException(IOE);
                }
            }
        }
        return nFilesCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCleanedFiles() {
        Set set = this.filesToDelete;
        synchronized (set) {
            if (this.filesToDelete.size() == 0) {
                return null;
            }
            return new HashSet(this.filesToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCleanedFiles(Set cleanedFiles) throws DatabaseException {
        this.env.checkIfInvalid();
        if (this.env.mayNotWrite()) {
            return;
        }
        if (!this.env.getFileManager().lockEnvironment(false, true)) {
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun checkpoint complete but " + cleanedFiles.size() + " files not deleted because of read-only processes.");
            return;
        }
        int nFilesDeleted = 0;
        try {
            Iterator i = cleanedFiles.iterator();
            while (i.hasNext()) {
                Long fileNum = (Long)i.next();
                long fileNumValue = fileNum;
                Set set = this.filesToDelete;
                synchronized (set) {
                    if (!$assertionsDisabled && !this.filesToDelete.contains(fileNum)) {
                        throw new AssertionError();
                    }
                }
                try {
                    if (this.expunge) {
                        this.env.getFileManager().deleteFile(fileNumValue);
                    } else {
                        this.env.getFileManager().renameFile(fileNumValue, ".del");
                    }
                }
                catch (IOException e) {
                    Tracer.trace(this.env, "Cleaner", "deleteCleanedFiles", "", e);
                    throw new DatabaseException(e);
                }
                this.profile.removeFile(fileNum);
                set = this.filesToDelete;
                synchronized (set) {
                    this.filesToDelete.remove(fileNum);
                }
                ++nFilesDeleted;
                ++this.nCleanerDeletions;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.env.getFileManager().releaseExclusiveLock();
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun checkpoint complete nFilesDeleted=" + nFilesDeleted);
            throw throwable;
        }
        this.env.getFileManager().releaseExclusiveLock();
        Tracer.trace(Level.SEVERE, this.env, "CleanerRun checkpoint complete nFilesDeleted=" + nFilesDeleted);
    }

    private boolean processPending(long[] pendingLsns, UtilizationSelector.RetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        LogManager logManager = this.env.getLogManager();
        boolean anyProgress = false;
        for (int i = 0; i < pendingLsns.length; ++i) {
            long lsn = pendingLsns[i];
            if (this.interruptCleaning()) break;
            LogEntry entry = logManager.getLogEntry(lsn);
            ++this.nEntriesRead;
            if (entry instanceof LNLogEntry) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                LN targetLN = lnEntry.getLN();
                long nodeId = targetLN.getNodeId();
                DatabaseId dbId = lnEntry.getDbId();
                Key key = lnEntry.getKey();
                Key dupKey = lnEntry.getDupKey();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                if (!this.processLN(targetLN, db, key, dupKey, lsn, location)) continue;
                fileRetryInfo.setObsoleteLN(lsn, nodeId);
                anyProgress = true;
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)entry.getClass().getName());
            }
        }
        return anyProgress;
    }

    private boolean processFile(CleanerFileReader reader, UtilizationSelector.RetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        boolean anyProgress = false;
        boolean interrupted = false;
        while (reader.readNextEntry()) {
            ++this.nEntriesRead;
            long lsn = reader.getLastLsn();
            fileRetryInfo.setFirstUnprocessedLsn(lsn);
            if (this.interruptCleaning()) {
                interrupted = true;
                break;
            }
            if (reader.isLN()) {
                LN targetLN = reader.getLN();
                long nodeId = targetLN.getNodeId();
                if (!fileRetryInfo.isObsoleteLN(lsn, nodeId)) {
                    DatabaseId dbId = reader.getDatabaseId();
                    Key key = reader.getKey();
                    Key dupKey = reader.getDupTreeKey();
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    if (this.processLN(targetLN, db, key, dupKey, lsn, location)) {
                        fileRetryInfo.setObsoleteLN(lsn, nodeId);
                        anyProgress = true;
                    } else {
                        fileRetryInfo.setPendingLN(lsn, nodeId);
                    }
                }
            } else if (reader.isIN()) {
                IN targetIN = reader.getIN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                targetIN.setDatabase(db);
                this.processIN(targetIN, db, lsn);
                anyProgress = true;
            } else if (reader.isRoot()) {
                this.env.rewriteMapTreeRoot(lsn);
                anyProgress = true;
            } else if (reader.isDelta()) {
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                this.processDelta(reader, db, lsn);
                anyProgress = true;
            }
            this.env.getEvictor().doCriticalEviction();
        }
        if (!interrupted) {
            fileRetryInfo.setFileFullyProcessed();
        }
        this.nEntriesReadThisRun = reader.getNumRead();
        return anyProgress;
    }

    private boolean processLN(LN lnClone, DatabaseImpl db, Key key, Key dupKey, long logLsn, TreeLocation location) throws DatabaseException {
        boolean bl;
        LN lnInTree;
        boolean lnIsDupCountLN;
        boolean cleaned;
        boolean insPinned;
        DIN parentDIN;
        BasicLocker locker;
        boolean completed;
        boolean migrated;
        boolean obsolete;
        block35: {
            block34: {
                block33: {
                    block32: {
                        obsolete = false;
                        migrated = false;
                        completed = false;
                        locker = null;
                        parentDIN = null;
                        insPinned = false;
                        if (db != null && !db.getIsDeleted()) break block32;
                        obsolete = true;
                        completed = true;
                        boolean bl2 = true;
                        Object var28_16 = null;
                        this.unPinAndRelease(parentDIN, insPinned);
                        this.unPinAndRelease(location.bin, insPinned);
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                        return bl2;
                    }
                    cleaned = true;
                    ++this.nLNsCleanedThisRun;
                    Tree tree = db.getTree();
                    if (!$assertionsDisabled && tree == null) {
                        throw new AssertionError();
                    }
                    boolean found = tree.getParentBINForChildLN(location, key, dupKey, lnClone, false, true, false);
                    lnIsDupCountLN = lnClone.containsDuplicates();
                    if (found) break block33;
                    obsolete = true;
                    ++this.nLNsDeadThisRun;
                    completed = true;
                    boolean bl3 = cleaned;
                    Object var28_17 = null;
                    this.unPinAndRelease(parentDIN, insPinned);
                    this.unPinAndRelease(location.bin, insPinned);
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                    return bl3;
                }
                if (!location.bin.isEntryKnownDeleted(location.index)) break block34;
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                boolean bl4 = cleaned;
                Object var28_18 = null;
                this.unPinAndRelease(parentDIN, insPinned);
                this.unPinAndRelease(location.bin, insPinned);
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                return bl4;
            }
            Node refTarget = location.bin.fetchTarget(location.index);
            IN lnParent = null;
            if (lnIsDupCountLN) {
                parentDIN = (DIN)refTarget;
                parentDIN.latch();
                lnParent = parentDIN;
                refTarget = parentDIN.getDupCountLNRef().fetchTarget(db, lnParent);
            } else {
                lnParent = location.bin;
            }
            lnInTree = (LN)refTarget;
            insPinned = true;
            if (lnIsDupCountLN) {
                parentDIN.setEvictionProhibited(true);
                parentDIN.releaseLatch();
            }
            location.bin.setEvictionProhibited(true);
            locker = new BasicLocker(this.env);
            locker.setLockTimeout(this.lockTimeout);
            LockGrantType lock = locker.nonBlockingReadLock(lnInTree.getNodeId(), db);
            if (lock != LockGrantType.DENIED) break block35;
            location.bin.releaseLatch();
            long abortLsn = locker.getOwnerAbortLsn(lnInTree.getNodeId());
            if (abortLsn != -1L && DbLsn.compareTo(abortLsn, logLsn) > 0) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nLNsLockedThisRun;
                cleaned = false;
            }
            completed = true;
            boolean bl5 = cleaned;
            Object var28_19 = null;
            this.unPinAndRelease(parentDIN, insPinned);
            this.unPinAndRelease(location.bin, insPinned);
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
            return bl5;
        }
        try {
            location.bin.setEvictionProhibited(false);
            Node newRefTarget = null;
            long newRefLsn = -1L;
            if (lnIsDupCountLN) {
                newRefTarget = location.bin.fetchTarget(location.index);
                newRefLsn = location.bin.getLsn(location.index);
                if (newRefTarget instanceof DIN) {
                    parentDIN = (DIN)newRefTarget;
                    parentDIN.latch();
                    ChildReference dclRef = parentDIN.getDupCountLNRef();
                    newRefTarget = dclRef.getTarget();
                    newRefLsn = dclRef.getLsn();
                    parentDIN.setEvictionProhibited(false);
                }
            }
            insPinned = false;
            if (newRefTarget == null) {
                newRefTarget = location.bin.getTarget(location.index);
                newRefLsn = location.bin.getLsn(location.index);
            }
            if (newRefTarget == lnInTree) {
                if (lnInTree.isDeleted()) {
                    if (!$assertionsDisabled && lnIsDupCountLN) {
                        throw new AssertionError();
                    }
                    location.bin.setKnownDeletedLeaveTarget(location.index);
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                } else if (newRefLsn == logLsn) {
                    long newLNLsn = this.migrateLN(lnInTree, db, key, logLsn, locker);
                    if (lnIsDupCountLN) {
                        parentDIN.updateDupCountLNRef(newLNLsn);
                    } else {
                        location.bin.updateEntry(location.index, newLNLsn);
                    }
                    migrated = true;
                } else {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                }
            } else {
                cleaned = false;
            }
            completed = true;
            bl = cleaned;
            Object var28_20 = null;
        }
        catch (DatabaseException DBE) {
            try {
                DBE.printStackTrace();
                Tracer.trace(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
                throw DBE;
            }
            catch (Throwable throwable) {
                Object var28_21 = null;
                this.unPinAndRelease(parentDIN, insPinned);
                this.unPinAndRelease(location.bin, insPinned);
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                throw throwable;
            }
        }
        this.unPinAndRelease(parentDIN, insPinned);
        this.unPinAndRelease(location.bin, insPinned);
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
        return bl;
    }

    private void unPinAndRelease(IN in, boolean isPinned) throws DatabaseException {
        if (in != null) {
            if (isPinned) {
                if (!in.getLatch().isOwner()) {
                    in.latch();
                }
                in.setEvictionProhibited(false);
                in.releaseLatch();
            } else if (in.getLatch().isOwner()) {
                in.releaseLatch();
            }
        }
    }

    private long migrateLN(LN ln, DatabaseImpl db, Key key, long oldLsn, Locker locker) throws DatabaseException {
        long newLsn = ln.log(this.env, db.getId(), key, oldLsn, locker);
        ++this.nLNsMigratedThisRun;
        return newLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            if (db == null || db.getIsDeleted()) {
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            IN inInTree = this.findINInTree(tree, db, inClone, lsn);
            if (inInTree == null) {
                ++this.nINsCleanedThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setCleanedSinceLastLog();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        finally {
            this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        IN iN;
        block10: {
            SearchResult result;
            block8: {
                IN iN2;
                block9: {
                    block6: {
                        IN iN3;
                        block7: {
                            if (inClone.isDbRoot()) {
                                IN rootIN = this.isRoot(tree, db, inClone, lsn);
                                if (rootIN == null) {
                                    return null;
                                }
                                return rootIN;
                            }
                            inClone.latch();
                            result = null;
                            try {
                                result = tree.getParentINForChildIN(inClone, true);
                                if (result.exactParentFound) break block6;
                                iN3 = null;
                                Object var11_9 = null;
                                if (result == null || !result.exactParentFound) break block7;
                            }
                            catch (Throwable throwable) {
                                block11: {
                                    Object var11_12 = null;
                                    if (result == null || !result.exactParentFound) break block11;
                                    result.parent.releaseLatch();
                                }
                                throw throwable;
                            }
                            result.parent.releaseLatch();
                        }
                        return iN3;
                    }
                    int compareVal = DbLsn.compareTo(result.parent.getLsn(result.index), lsn);
                    if (compareVal <= 0) break block8;
                    iN2 = null;
                    Object var11_10 = null;
                    if (result == null || !result.exactParentFound) break block9;
                    result.parent.releaseLatch();
                }
                return iN2;
            }
            IN in = (IN)result.parent.fetchTarget(result.index);
            in.latch();
            iN = in;
            Object var11_11 = null;
            if (result == null || !result.exactParentFound) break block10;
            result.parent.releaseLatch();
        }
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelta(CleanerFileReader cleanerReader, DatabaseImpl db, long lsn) throws DatabaseException {
        IN owningBIN;
        boolean completed;
        boolean dirtied;
        boolean obsolete;
        block11: {
            obsolete = false;
            dirtied = false;
            completed = false;
            owningBIN = null;
            try {
                if (db != null && !db.getIsDeleted()) break block11;
                obsolete = true;
                completed = true;
                ++this.nDeltasCleanedThisRun;
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                return;
            }
            catch (Throwable throwable) {
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                throw throwable;
            }
        }
        IN reconstructed = null;
        try {
            reconstructed = cleanerReader.getReconstructedIN();
        }
        catch (LogFileNotFoundException e) {
            obsolete = true;
            completed = true;
            ++this.nDeltasCleanedThisRun;
            this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
            return;
        }
        if (reconstructed == null) {
            obsolete = true;
        } else {
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            owningBIN = this.findDeltaInTree(tree, db, reconstructed, lsn);
            if (owningBIN == null) {
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                owningBIN.setDirty(true);
                owningBIN.releaseLatch();
                dirtied = true;
            }
        }
        ++this.nDeltasCleanedThisRun;
        completed = true;
        this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
    }

    private IN findDeltaInTree(Tree tree, DatabaseImpl db, IN reconstructed, long lsn) throws DatabaseException {
        reconstructed.latch();
        SearchResult result = tree.getParentINForChildIN(reconstructed, true);
        if (!result.exactParentFound) {
            return null;
        }
        BIN binInTree = (BIN)result.parent.fetchTarget(result.index);
        binInTree.latch();
        result.parent.releaseLatch();
        long lastDeltaLsn = binInTree.getLastDeltaVersion();
        if (lastDeltaLsn != -1L && DbLsn.compareTo(lastDeltaLsn, lsn) <= 0) {
            return binInTree;
        }
        binInTree.releaseLatch();
        return null;
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatched(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsCleanedThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nDeltasCleanedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.nINsCleaned += this.nINsCleanedThisRun;
        this.nINsMigrated += this.nINsMigratedThisRun;
        this.nLNsCleaned += this.nLNsCleanedThisRun;
        this.nLNsDead += this.nLNsDeadThisRun;
        this.nLNsMigrated += this.nLNsMigratedThisRun;
        this.nLNsLocked += this.nLNsLockedThisRun;
        this.nDeltasCleaned += this.nDeltasCleanedThisRun;
        this.nRepeatIteratorReads += this.nRepeatIteratorReadsThisRun;
    }

    private void trace(Level level, String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Cleaner.class.desiredAssertionStatus();
    }

    private static class RootDoWork
    implements WithRootLatched {
        private DatabaseImpl db;
        private IN inClone;
        private long lsn;

        RootDoWork(DatabaseImpl db, IN inClone, long lsn) {
            this.db = db;
            this.inClone = inClone;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.fetchTarget(this.db, null).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.lsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch();
                return rootIN;
            }
            return null;
        }
    }
}

