/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "delete";
    private static final String TRACE_MOD = "Mod:";
    private volatile BIN bin = null;
    private volatile int index = -1;
    private volatile DBIN dupBin = null;
    private volatile int dupIndex = -1;
    private BIN targetBin;
    private int targetIndex;
    private Key dupKey;
    private DatabaseImpl database;
    private Locker locker;
    private CursorImpl lockerPrev;
    private CursorImpl lockerNext;
    private boolean releaseLocksOnClose;
    private byte status;
    private ThreadLocal treeStatsAccumulatorTL = new ThreadLocal();
    public static final int FOUND = 1;
    public static final int EXACT_KEY = 2;
    public static final int EXACT_DATA = 4;
    public static final int FOUND_LAST = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return (TreeWalkerStatsAccumulator)this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void incrementLNCount() {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (treeStatsAccumulator != null) {
            treeStatsAccumulator.incrementLNCount();
        }
    }

    public CursorImpl(DatabaseImpl database, Locker locker) throws DatabaseException {
        this(database, locker, true);
    }

    public CursorImpl(DatabaseImpl database, Locker locker, boolean retainNonTxnLocks) throws DatabaseException {
        if (!$assertionsDisabled && retainNonTxnLocks && locker instanceof ThreadLocker) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !retainNonTxnLocks && locker.getClass() == BasicLocker.class) {
            throw new AssertionError();
        }
        this.releaseLocksOnClose = !retainNonTxnLocks && !locker.isTransactional();
        this.database = database;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.status = 1;
    }

    public CursorImpl cloneCursor(boolean addCursor) throws DatabaseException {
        return this.cloneCursor(addCursor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorImpl cloneCursor(boolean addCursor, CursorImpl usePosition) throws DatabaseException {
        try {
            this.latchBINs();
            CursorImpl ret = (CursorImpl)super.clone();
            if (this.releaseLocksOnClose) {
                ret.locker = this.locker.newInstance();
            }
            ret.locker.registerCursor(ret);
            if (usePosition != null && usePosition.status == 2) {
                ret.bin = usePosition.bin;
                ret.index = usePosition.index;
                ret.dupBin = usePosition.dupBin;
                ret.dupIndex = usePosition.dupIndex;
            }
            if (addCursor) {
                ret.addCursor();
            }
            CursorImpl cursorImpl = ret;
            return cursorImpl;
        }
        catch (CloneNotSupportedException cannotOccur) {
            CursorImpl cursorImpl = null;
            return cursorImpl;
        }
        finally {
            this.releaseBINs();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setBIN(BIN newBin) {
        this.bin = newBin;
    }

    public int getDupIndex() {
        return this.dupIndex;
    }

    public void setDupIndex(int dupIdx) {
        this.dupIndex = dupIdx;
    }

    public DBIN getDupBIN() {
        return this.dupBin;
    }

    public void setDupBIN(DBIN newDupBin) {
        this.dupBin = newDupBin;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    private boolean setTargetBin() {
        this.targetBin = null;
        this.targetIndex = 0;
        boolean isDup = this.dupBin != null;
        this.dupKey = null;
        if (isDup) {
            this.targetBin = this.dupBin;
            this.targetIndex = this.dupIndex;
            this.dupKey = this.dupBin.getDupKey();
        } else {
            this.targetBin = this.bin;
            this.targetIndex = this.index;
        }
        return isDup;
    }

    public BIN latchBIN() throws DatabaseException {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch();
            if (this.bin == waitingOn) {
                return this.bin;
            }
            waitingOn.releaseLatch();
        }
        return null;
    }

    public void releaseBIN() throws LatchNotHeldException {
        if (this.bin != null && this.bin.getLatch().isOwner()) {
            this.bin.releaseLatch();
        }
    }

    public void latchBINs() throws DatabaseException {
        this.latchBIN();
        this.latchDBIN();
    }

    public void releaseBINs() throws LatchNotHeldException {
        this.releaseBIN();
        this.releaseDBIN();
    }

    public void latchDBIN() throws DatabaseException {
        while (this.dupBin != null) {
            DBIN waitingOn = this.dupBin;
            waitingOn.latch();
            if (this.dupBin == waitingOn) {
                return;
            }
            waitingOn.releaseLatch();
        }
    }

    public void releaseDBIN() throws LatchNotHeldException {
        if (this.dupBin != null && this.dupBin.getLatch().isOwner()) {
            this.dupBin.releaseLatch();
        }
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void addCursor(BIN bin) {
        if (bin != null) {
            if (!$assertionsDisabled && !bin.getLatch().isOwner()) {
                throw new AssertionError();
            }
            bin.addCursor(this);
        }
    }

    public void addCursor() {
        if (this.dupBin != null) {
            this.addCursor(this.dupBin);
        }
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    public void updateBin(BIN bin, int index) {
        this.setDupIndex(-1);
        this.setDupBIN(null);
        this.setIndex(index);
        this.setBIN(bin);
        this.addCursor(bin);
    }

    public void updateDBin(DBIN dupBin, int dupIndex) {
        this.setDupIndex(dupIndex);
        this.setDupBIN(dupBin);
        this.addCursor(dupBin);
    }

    private void removeCursor() throws DatabaseException {
        this.removeCursorBin(this.bin);
        this.removeCursorBin(this.dupBin);
    }

    private void removeCursorBin(BIN aBin) throws DatabaseException {
        if (aBin != null) {
            aBin.latch();
            aBin.removeCursor(this);
            aBin.releaseLatch();
        }
    }

    public void dumpTree() throws DatabaseException {
        this.database.getTree().dump();
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public void reset() throws DatabaseException {
        this.removeCursor();
        if (this.releaseLocksOnClose) {
            this.locker.operationEnd();
        }
        this.bin = null;
        this.index = -1;
        this.dupBin = null;
        this.dupIndex = -1;
        this.status = 1;
    }

    public void close() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        this.removeCursor();
        this.locker.unRegisterCursor(this);
        if (this.releaseLocksOnClose) {
            this.locker.operationEnd();
        }
        this.status = (byte)3;
        this.database.getDbEnvironment().getEvictor().doCriticalEviction();
    }

    public int count() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean duplicatesAllowed = this.database.getSortedDuplicates();
        if (!duplicatesAllowed) {
            return 1;
        }
        if (this.bin == null) {
            return 0;
        }
        this.latchBIN();
        if (this.bin.getNEntries() <= this.index) {
            this.releaseBIN();
            return 0;
        }
        int dupRootCount = 1;
        Node n = this.bin.fetchTarget(this.index);
        if (n.containsDuplicates()) {
            DIN dupRoot = (DIN)n;
            dupRoot.latch();
            this.releaseBIN();
            DupCountLN dupCountLN = (DupCountLN)dupRoot.getDupCountLNRef().fetchTarget(this.database, dupRoot);
            dupRoot.releaseLatch();
            this.locker.lock(dupCountLN.getNodeId(), LockType.READ, this.database);
            dupRootCount = dupCountLN.getDupCount();
        } else {
            this.releaseBIN();
        }
        return dupRootCount;
    }

    public OperationStatus delete() throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean isDup = this.setTargetBin();
        if (this.targetBin == null) {
            return OperationStatus.KEYEMPTY;
        }
        if (this.targetBin.isEntryKnownDeleted(this.targetIndex)) {
            this.releaseBINs();
            return OperationStatus.KEYEMPTY;
        }
        LN ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
        this.releaseBINs();
        LockResult lockResult = this.locker.lock(ln.getNodeId(), LockType.WRITE, this.database);
        if (ln.isDeleted()) {
            this.revertLock(ln, lockResult);
            return OperationStatus.KEYEMPTY;
        }
        DIN dupRoot = null;
        if (isDup) {
            this.latchBIN();
            dupRoot = (DIN)this.bin.fetchTarget(this.index);
            dupRoot.latch();
            this.latchDBIN();
        } else {
            this.latchBINs();
        }
        this.setTargetBin();
        long oldLsn = this.targetBin.getLsn(this.targetIndex);
        Key lnKey = this.targetBin.getKey(this.targetIndex);
        Key idKey = this.targetBin.getIdentifierKey();
        long nodeId = this.targetBin.getNodeId();
        lockResult.setAbortLsn(oldLsn, this.targetBin.isEntryKnownDeleted(this.targetIndex));
        long oldLNSize = ln.getMemorySizeIncludedByParent();
        long newLsn = ln.delete(this.database, lnKey, this.dupKey, oldLsn, this.locker);
        long newLNSize = ln.getMemorySizeIncludedByParent();
        if (isDup) {
            this.targetBin.updateEntry(this.targetIndex, newLsn, oldLNSize, newLNSize);
            this.releaseBINs();
            ChildReference dupCountRef = dupRoot.getDupCountLNRef();
            DupCountLN dcl = (DupCountLN)dupCountRef.fetchTarget(this.database, dupRoot);
            dupRoot.releaseLatch();
            LockResult dclGrantAndInfo = this.locker.lock(dcl.getNodeId(), LockType.WRITE, this.database);
            this.latchBIN();
            dupRoot = (DIN)this.bin.fetchTarget(this.index);
            dupRoot.latch();
            this.releaseBIN();
            dupCountRef = dupRoot.getDupCountLNRef();
            long oldDclLsn = dupCountRef.getLsn();
            dclGrantAndInfo.setAbortLsn(oldDclLsn, dupCountRef.isKnownDeleted());
            dcl = (DupCountLN)dupCountRef.fetchTarget(this.database, dupRoot);
            dcl.decDupCount();
            if (!$assertionsDisabled && dcl.getDupCount() < 0) {
                throw new AssertionError();
            }
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            long dupCountLsn = dcl.log(envImpl, this.database.getId(), this.dupKey, oldDclLsn, this.locker);
            dupRoot.updateDupCountLNRef(dupCountLsn);
            dupRoot.releaseLatch();
            this.locker.addDeleteInfo(this.dupBin, lnKey);
        } else {
            this.targetBin.updateEntry(this.targetIndex, newLsn, oldLNSize, newLNSize);
            this.releaseBINs();
            this.locker.addDeleteInfo(this.bin, lnKey);
        }
        this.trace(Level.FINER, TRACE_DELETE, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
        return OperationStatus.SUCCESS;
    }

    public CursorImpl dup(boolean samePosition) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        CursorImpl ret = this.cloneCursor(samePosition);
        if (!samePosition) {
            ret.bin = null;
            ret.index = -1;
            ret.dupBin = null;
            ret.dupIndex = -1;
            ret.status = 1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextKeyForInsert(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        DatabaseEntry tempKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        DatabaseEntry tempData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        boolean lockedNextKey = false;
        SearchMode searchMode = this.database.getSortedDuplicates() ? SearchMode.BOTH_RANGE : SearchMode.SET_RANGE;
        boolean latched = true;
        try {
            int searchResult = this.searchAndPosition(tempKey, tempData, searchMode, LockType.RANGE_INSERT);
            if ((searchResult & 1) != 0 && (searchResult & 8) == 0) {
                OperationStatus status = (searchResult & 2) != 0 ? this.getNext(tempKey, tempData, LockType.RANGE_INSERT, true, true) : this.getNextNoDup(tempKey, tempData, LockType.RANGE_INSERT, true, true);
                if (status == OperationStatus.SUCCESS) {
                    lockedNextKey = true;
                }
                latched = false;
            }
        }
        finally {
            if (latched) {
                this.releaseBINs();
            }
        }
        if (!lockedNextKey) {
            this.lockEofNode(LockType.RANGE_INSERT);
        }
    }

    public OperationStatus putLN(Key key, LN ln, boolean allowDuplicates) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        LockResult lockResult = this.locker.lock(ln.getNodeId(), LockType.WRITE, this.database);
        if (this.database.getTree().insert(ln, key, allowDuplicates, this, lockResult)) {
            this.status = (byte)2;
            return OperationStatus.SUCCESS;
        }
        this.locker.releaseLock(ln.getNodeId());
        return OperationStatus.KEYEXIST;
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data, DatabaseEntry foundData) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        OperationStatus result = this.putLN(new Key(key), new LN(data), this.database.getSortedDuplicates());
        if (result == OperationStatus.KEYEXIST) {
            this.status = (byte)2;
            result = this.putCurrent(data, null, foundData);
        }
        return result;
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        return this.putLN(new Key(key), new LN(data), false);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (!this.database.getSortedDuplicates()) {
            throw new DatabaseException("putNoDupData() called, but database is not configured for duplicate data.");
        }
        return this.putLN(new Key(key), new LN(data), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putCurrent(DatabaseEntry data, DatabaseEntry foundKey, DatabaseEntry foundData) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (foundKey != null) {
            foundKey.setData(null);
        }
        if (foundData != null) {
            foundData.setData(null);
        }
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        this.latchBINs();
        boolean isDup = this.setTargetBin();
        try {
            byte[] newData;
            byte[] foundKeyBytes;
            byte[] foundDataBytes;
            LN ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
            Key lnKey = this.targetBin.getKey(this.targetIndex);
            Comparator userComparisonFcn = this.targetBin.getKeyComparator();
            this.releaseBINs();
            if (this.targetBin.isEntryKnownDeleted(this.targetIndex) || ln.isDeleted()) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            LockResult lockResult = this.locker.lock(ln.getNodeId(), LockType.WRITE, this.database);
            if (isDup) {
                foundDataBytes = lnKey.getKey();
                foundKeyBytes = this.targetBin.getDupKey().getKey();
            } else {
                foundDataBytes = ln.getData();
                foundKeyBytes = lnKey.getKey();
            }
            if (data.getPartial()) {
                int slicelen;
                int dlen = data.getPartialLength();
                int doff = data.getPartialOffset();
                int origlen = foundDataBytes != null ? foundDataBytes.length : 0;
                int oldlen = doff + dlen > origlen ? doff + dlen : origlen;
                int len = oldlen - dlen + data.getSize();
                newData = new byte[len];
                int pos = 0;
                int n = slicelen = doff < origlen ? doff : origlen;
                if (slicelen > 0) {
                    System.arraycopy(foundDataBytes, 0, newData, pos, slicelen);
                }
                slicelen = data.getSize();
                System.arraycopy(data.getData(), data.getOffset(), newData, pos += doff, slicelen);
                pos += slicelen;
                slicelen = origlen - (doff + dlen);
                if (slicelen > 0) {
                    System.arraycopy(foundDataBytes, doff + dlen, newData, pos, slicelen);
                }
            } else {
                int len = data.getSize();
                newData = new byte[len];
                System.arraycopy(data.getData(), data.getOffset(), newData, 0, len);
            }
            if (this.database.getSortedDuplicates()) {
                boolean keysEqual = false;
                if (foundDataBytes != null) {
                    boolean bl = userComparisonFcn == null ? Key.compareByteArray(foundDataBytes, newData) == 0 : (keysEqual = userComparisonFcn.compare(foundDataBytes, newData) == 0);
                }
                if (!keysEqual) {
                    this.revertLock(ln, lockResult);
                    throw new DatabaseException("Can't replace a duplicate with different data.");
                }
            }
            if (foundData != null) {
                this.setDbt(foundData, foundDataBytes);
            }
            if (foundKey != null) {
                this.setDbt(foundKey, foundKeyBytes);
            }
            this.latchBINs();
            this.setTargetBin();
            long oldLsn = this.targetBin.getLsn(this.targetIndex);
            lockResult.setAbortLsn(oldLsn, this.targetBin.isEntryKnownDeleted(this.targetIndex));
            long oldLNSize = ln.getMemorySizeIncludedByParent();
            Key newKey = isDup ? this.targetBin.getDupKey() : lnKey;
            long newLsn = ln.modify(newData, this.database, newKey, oldLsn, this.locker);
            long newLNSize = ln.getMemorySizeIncludedByParent();
            this.targetBin.updateEntry(this.targetIndex, newLsn, oldLNSize, newLNSize);
            this.releaseBINs();
            this.trace(Level.FINER, TRACE_MOD, this.targetBin, ln, this.targetIndex, oldLsn, newLsn);
            this.status = (byte)2;
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.releaseBINs();
        }
    }

    public OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        if (this.dupBin == null) {
            this.latchBIN();
        } else {
            this.latchDBIN();
        }
        return this.getCurrentAlreadyLatched(foundKey, foundData, lockType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getCurrentAlreadyLatched(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean first) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        try {
            OperationStatus operationStatus = this.fetchCurrent(foundKey, foundData, lockType, first);
            return operationStatus;
        }
        finally {
            this.releaseBINs();
        }
    }

    public LN getCurrentLN(LockType lockType) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.bin == null) {
            return null;
        }
        this.latchBIN();
        return this.getCurrentLNAlreadyLatched(lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLNAlreadyLatched(LockType lockType) throws DatabaseException {
        try {
            if (!$assertionsDisabled && !this.assertCursorState(true)) {
                throw new AssertionError((Object)this.dumpToString(true));
            }
            if (this.bin == null) {
                LN lN = null;
                return lN;
            }
            if (this.bin.isEntryKnownDeleted(this.index)) {
                this.releaseBIN();
                LN lN = null;
                return lN;
            }
            LN ln = (LN)this.bin.fetchTarget(this.index);
            this.addCursor(this.bin);
            this.releaseBIN();
            LockResult lockResult = this.getLock(ln, lockType);
            if (ln.isDeleted()) {
                this.revertLock(ln, lockResult);
                LN lN = null;
                return lN;
            }
            if (lockType.isWriteLock()) {
                this.latchBIN();
                long oldLsn = this.bin.getLsn(this.index);
                lockResult.setAbortLsn(oldLsn, this.bin.isEntryKnownDeleted(this.index));
                this.releaseBIN();
            }
            LN lN = ln;
            return lN;
        }
        finally {
            this.releaseBIN();
        }
    }

    public OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        return this.getNextWithKeyChangeStatus((DatabaseEntry)foundKey, (DatabaseEntry)foundData, (LockType)lockType, (boolean)forward, (boolean)alreadyLatched).status;
    }

    public KeyChangeStatus getNextWithKeyChangeStatus(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        KeyChangeStatus result = new KeyChangeStatus(OperationStatus.NOTFOUND, true);
        while (this.bin != null) {
            if (this.dupBin != null) {
                if (this.getNextDuplicate(foundKey, foundData, lockType, forward, alreadyLatched) == OperationStatus.SUCCESS) {
                    result.status = OperationStatus.SUCCESS;
                    result.keyChange = false;
                    break;
                }
                this.removeCursorBin(this.dupBin);
                alreadyLatched = false;
                this.dupBin = null;
                this.dupIndex = -1;
                continue;
            }
            if (!alreadyLatched) {
                this.latchBIN();
            } else {
                alreadyLatched = false;
            }
            if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                OperationStatus ret = this.getCurrentAlreadyLatched(foundKey, foundData, lockType, forward);
                if (ret != OperationStatus.SUCCESS) continue;
                this.incrementLNCount();
                result.status = OperationStatus.SUCCESS;
                break;
            }
            this.releaseBIN();
            BIN newBin = forward ? this.database.getTree().getNextBin(this.bin, null) : this.database.getTree().getPrevBin(this.bin, null);
            if (newBin == null) {
                result.status = OperationStatus.NOTFOUND;
                break;
            }
            this.index = forward ? -1 : newBin.getNEntries();
            this.addCursor(newBin);
            BIN oldBin = this.bin;
            this.bin = newBin;
            newBin.releaseLatch();
            this.removeCursorBin(oldBin);
        }
        return result;
    }

    public OperationStatus getNextNoDup(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.dupBin != null) {
            if (alreadyLatched) {
                this.dupBin.removeCursor(this);
                this.dupBin.releaseLatch();
                alreadyLatched = false;
            } else {
                this.removeCursorBin(this.dupBin);
            }
            this.dupBin = null;
            this.dupIndex = -1;
        }
        return this.getNext(foundKey, foundData, lockType, forward, alreadyLatched);
    }

    public OperationStatus getFirstDuplicate(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        if (this.dupBin != null) {
            this.removeCursorBin(this.dupBin);
            this.dupBin = null;
            this.dupIndex = -1;
        }
        return this.getCurrent(foundKey, foundData, lockType);
    }

    public OperationStatus getNextDuplicate(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(true)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        while (this.dupBin != null) {
            DupCountLN dcl;
            if (!alreadyLatched) {
                this.latchDBIN();
            } else {
                alreadyLatched = false;
            }
            if (forward && ++this.dupIndex < this.dupBin.getNEntries() || !forward && --this.dupIndex > -1) {
                OperationStatus ret = OperationStatus.SUCCESS;
                if (foundKey != null) {
                    ret = this.fetchCurrent(foundKey, foundData, lockType, forward);
                } else {
                    this.releaseDBIN();
                }
                if (ret != OperationStatus.SUCCESS) continue;
                this.incrementLNCount();
                return ret;
            }
            this.releaseDBIN();
            this.latchBIN();
            if (this.index < 0) {
                this.releaseBIN();
                return OperationStatus.NOTFOUND;
            }
            DIN duplicateRoot = (DIN)this.bin.fetchTarget(this.index);
            TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
            if (treeStatsAccumulator != null && (dcl = duplicateRoot.getDupCountLN()) != null) {
                dcl.accumulateStats(treeStatsAccumulator);
            }
            this.releaseBIN();
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            DBIN newDupBin = forward ? (DBIN)this.database.getTree().getNextBin(this.dupBin, duplicateRoot) : (DBIN)this.database.getTree().getPrevBin(this.dupBin, duplicateRoot);
            if (newDupBin == null) {
                return OperationStatus.NOTFOUND;
            }
            this.dupIndex = forward ? -1 : newDupBin.getNEntries();
            this.addCursor(newDupBin);
            DBIN oldDupBin = this.dupBin;
            this.dupBin = newDupBin;
            this.releaseDBIN();
            this.removeCursorBin(oldDupBin);
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
        }
        return OperationStatus.NOTFOUND;
    }

    public boolean positionFirstOrLast(boolean first, DIN duplicateRoot) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        IN in = null;
        boolean found = false;
        try {
            if (duplicateRoot == null) {
                this.removeCursorBin(this.bin);
                in = first ? this.database.getTree().getFirstNode() : this.database.getTree().getLastNode();
                if (in != null) {
                    if (!$assertionsDisabled && !(in instanceof BIN)) {
                        throw new AssertionError();
                    }
                    this.dupBin = null;
                    this.dupIndex = -1;
                    this.bin = (BIN)in;
                    this.index = first ? 0 : this.bin.getNEntries() - 1;
                    this.addCursor(this.bin);
                    TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                    if (this.bin.getNEntries() == 0) {
                        found = true;
                    } else if (in.isEntryKnownDeleted(this.index)) {
                        if (treeStatsAccumulator != null) {
                            treeStatsAccumulator.incrementDeletedLNCount();
                        }
                        found = true;
                    } else {
                        Node n = in.fetchTarget(this.index);
                        if (n.containsDuplicates()) {
                            DIN dupRoot = (DIN)n;
                            dupRoot.latch();
                            in.releaseLatch();
                            in = null;
                            found = this.positionFirstOrLast(first, dupRoot);
                        } else {
                            if (treeStatsAccumulator != null) {
                                if (((LN)n).isDeleted()) {
                                    treeStatsAccumulator.incrementDeletedLNCount();
                                } else {
                                    treeStatsAccumulator.incrementLNCount();
                                }
                            }
                            found = true;
                        }
                    }
                }
            } else {
                this.removeCursorBin(this.dupBin);
                in = first ? this.database.getTree().getFirstNode(duplicateRoot) : this.database.getTree().getLastNode(duplicateRoot);
                if (in != null) {
                    if (!$assertionsDisabled && !(in instanceof DBIN)) {
                        throw new AssertionError();
                    }
                    this.dupBin = (DBIN)in;
                    this.dupIndex = first ? 0 : this.dupBin.getNEntries() - 1;
                    this.addCursor(this.dupBin);
                    found = true;
                }
            }
            this.status = (byte)2;
            return found;
        }
        catch (DatabaseException e) {
            if (in != null) {
                in.releaseLatch();
            }
            throw e;
        }
    }

    public int searchAndPosition(DatabaseEntry matchKey, DatabaseEntry matchData, SearchMode searchMode, LockType lockType) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        this.removeCursorBin(this.bin);
        this.bin = null;
        boolean foundSomething = false;
        boolean foundExactKey = false;
        boolean foundExactData = false;
        boolean foundLast = false;
        boolean exactSearch = searchMode.isExactSearch();
        BINBoundary binBoundary = new BINBoundary();
        try {
            Key key = new Key(matchKey);
            this.bin = (BIN)this.database.getTree().search(key, Tree.SearchType.NORMAL, -1L, binBoundary);
            if (this.bin != null) {
                this.addCursor(this.bin);
                this.index = this.bin.findEntry(key, true, exactSearch);
                foundSomething = !exactSearch;
                this.dupBin = null;
                this.dupIndex = -1;
                boolean containsDuplicates = false;
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExactKey = true;
                        this.index &= 0xFFFEFFFF;
                    }
                    if (!this.bin.isEntryKnownDeleted(this.index)) {
                        Node n = this.bin.fetchTarget(this.index);
                        containsDuplicates = n.containsDuplicates();
                        if (searchMode.isDataSearch()) {
                            if (foundExactKey) {
                                int searchResult = this.searchAndPositionBoth(containsDuplicates, n, matchData, exactSearch, lockType, this.bin.getLsn(this.index));
                                foundSomething = (searchResult & 1) != 0;
                                foundExactData = (searchResult & 4) != 0;
                            }
                        } else {
                            foundSomething = true;
                            if (!containsDuplicates && exactSearch) {
                                this.releaseBIN();
                                LN ln = (LN)n;
                                long oldLsn = this.bin.getLsn(this.index);
                                LockResult lockResult = this.getLock(ln, lockType);
                                this.latchBIN();
                                if (ln.isDeleted()) {
                                    foundSomething = false;
                                    this.revertLock(ln, lockResult);
                                }
                                lockResult.setAbortLsn(this.bin.getLsn(this.index), this.bin.isEntryKnownDeleted(this.index));
                            }
                        }
                    }
                    foundLast = searchMode == SearchMode.SET_RANGE && foundSomething && !containsDuplicates && binBoundary.isLastBin && this.index == this.bin.getNEntries() - 1;
                }
            }
            this.status = (byte)2;
            return (foundSomething ? 1 : 0) | (foundExactKey ? 2 : 0) | (foundExactData ? 4 : 0) | (foundLast ? 8 : 0);
        }
        catch (DatabaseException e) {
            this.releaseBIN();
            throw e;
        }
    }

    private int searchAndPositionBoth(boolean containsDuplicates, Node n, DatabaseEntry matchData, boolean exactSearch, LockType lockType, long oldLsn) throws DatabaseException {
        if (!$assertionsDisabled && !this.assertCursorState(false)) {
            throw new AssertionError((Object)this.dumpToString(true));
        }
        boolean found = false;
        boolean exact = false;
        Key data = new Key(matchData);
        if (!$assertionsDisabled && matchData == null) {
            throw new AssertionError();
        }
        if (containsDuplicates) {
            DIN duplicateRoot = (DIN)n;
            duplicateRoot.latch();
            this.releaseBIN();
            this.dupBin = (DBIN)this.database.getTree().searchSubTree(duplicateRoot, data, Tree.SearchType.NORMAL, -1L, null);
            if (this.dupBin != null) {
                this.addCursor(this.dupBin);
                this.dupIndex = this.dupBin.findEntry(data, true, exactSearch);
                if (this.dupIndex >= 0) {
                    if ((this.dupIndex & 0x10000) != 0) {
                        exact = true;
                    }
                    this.dupIndex &= 0xFFFEFFFF;
                    found = true;
                } else {
                    this.dupIndex = -1;
                    found = !exactSearch;
                }
            }
        } else {
            LN ln = (LN)n;
            this.releaseBIN();
            LockResult lockResult = this.getLock(ln, lockType);
            this.latchBIN();
            if (ln.isDeleted()) {
                found = !exactSearch;
                this.revertLock(ln, lockResult);
            } else {
                lockResult.setAbortLsn(this.bin.getLsn(this.index), this.bin.isEntryKnownDeleted(this.index));
                this.dupBin = null;
                this.dupIndex = -1;
                int cmp = Key.compareByteArray(ln.getData(), data.getKey());
                if (cmp == 0 || cmp <= 0 && !exactSearch) {
                    if (cmp == 0) {
                        exact = true;
                    }
                    found = true;
                } else {
                    --this.index;
                    found = !exactSearch;
                }
            }
        }
        return (found ? 1 : 0) | (exact ? 4 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus fetchCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean first) throws DatabaseException {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        boolean duplicateFetch = this.setTargetBin();
        if (this.targetBin == null) {
            return OperationStatus.NOTFOUND;
        }
        if (!$assertionsDisabled && !this.targetBin.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.targetIndex < 0 || this.targetIndex >= this.targetBin.getNEntries() || this.targetBin.isEntryKnownDeleted(this.targetIndex)) {
            if (this.targetBin.getLatch().isOwner()) {
                this.targetBin.releaseLatch();
            }
            if (treeStatsAccumulator != null) {
                treeStatsAccumulator.incrementDeletedLNCount();
            }
            return OperationStatus.KEYEMPTY;
        }
        this.addCursor(this.targetBin);
        Node n = this.targetBin.fetchTarget(this.targetIndex);
        if (n.containsDuplicates()) {
            if (!$assertionsDisabled && duplicateFetch) {
                throw new AssertionError();
            }
            DIN duplicateRoot = (DIN)n;
            duplicateRoot.latch();
            this.targetBin.releaseLatch();
            if (this.positionFirstOrLast(first, duplicateRoot)) {
                return this.fetchCurrent(foundKey, foundData, lockType, first);
            }
            return OperationStatus.NOTFOUND;
        }
        LN ln = (LN)n;
        this.releaseBINs();
        LockResult lockResult = this.getLock(ln, lockType);
        this.latchBINs();
        try {
            duplicateFetch = this.setTargetBin();
            if (this.targetBin.isEntryKnownDeleted(this.targetIndex)) {
                this.targetBin.releaseLatch();
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            long oldLsn = this.targetBin.getLsn(this.targetIndex);
            if (lockType.isWriteLock()) {
                lockResult.setAbortLsn(oldLsn, this.targetBin.isEntryKnownDeleted(this.targetIndex));
            }
            if (this.targetBin.getLsn(this.targetIndex) != oldLsn || this.targetBin.getTarget(this.targetIndex) != n) {
                ln = (LN)this.targetBin.fetchTarget(this.targetIndex);
            }
            if (ln.isDeleted()) {
                this.revertLock(ln, lockResult);
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            if (duplicateFetch) {
                if (foundData != null) {
                    this.setDbt(foundData, this.targetBin.getKey(this.targetIndex).getKey());
                }
                if (foundKey != null) {
                    this.setDbt(foundKey, this.targetBin.getDupKey().getKey());
                }
            } else {
                if (foundData != null) {
                    this.setDbt(foundData, ln.getData());
                }
                if (foundKey != null) {
                    this.setDbt(foundKey, this.targetBin.getKey(this.targetIndex).getKey());
                }
            }
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.releaseBINs();
        }
    }

    private void setDbt(DatabaseEntry data, byte[] bytes) throws DatabaseException {
        if (bytes != null) {
            int len;
            boolean partial = data.getPartial();
            int off = partial ? data.getPartialOffset() : 0;
            int n = len = partial ? data.getPartialLength() : bytes.length;
            if (off + len > bytes.length) {
                len = off > bytes.length ? 0 : bytes.length - off;
            }
            byte[] newdata = new byte[len];
            System.arraycopy(bytes, off, newdata, 0, len);
            data.setData(newdata);
            data.setOffset(0);
            data.setSize(len);
        } else {
            data.setData(null);
            data.setOffset(0);
            data.setSize(0);
        }
    }

    private void verifyCursor(BIN bin) throws DatabaseException {
        if (!bin.getCursorSet().contains(this)) {
            throw new DatabaseException("BIN cursorSet is inconsistent.");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized);
            return true;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized) throws DatabaseException {
        if (this.status == 2) {
            return;
        }
        if (this.status == 1) {
            if (mustBeInitialized) {
                throw new DatabaseException("Cursor Not Initialized.");
            }
        } else {
            if (this.status == 3) {
                throw new DatabaseException("Cursor has been closed.");
            }
            throw new DatabaseException("Unknown cursor status: " + this.status);
        }
    }

    private LockResult getLock(LN ln, LockType lockType) throws DatabaseException {
        if (!$assertionsDisabled && lockType == null) {
            throw new AssertionError();
        }
        if (lockType == LockType.NONE) {
            return new LockResult(LockGrantType.NONE_NEEDED, null);
        }
        return this.locker.lock(ln.getNodeId(), lockType, this.database);
    }

    private void revertLock(LN ln, LockResult lockResult) throws DatabaseException {
        this.revertLock(ln.getNodeId(), lockResult.getLockGrant());
    }

    private void revertLock(long nodeId, LockGrantType lockStatus) throws DatabaseException {
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            this.locker.releaseLock(nodeId);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            this.locker.demoteLock(nodeId);
        }
    }

    public void lockEofNode(LockType lockType) throws DatabaseException {
        this.locker.lock(this.database.getEofNodeId(), lockType, this.database);
    }

    public void checkEnv() throws RunRecoveryException {
        this.database.getDbEnvironment().checkIfInvalid();
    }

    public CursorImpl getLockerPrev() {
        return this.lockerPrev;
    }

    public CursorImpl getLockerNext() {
        return this.lockerNext;
    }

    public void setLockerPrev(CursorImpl p) {
        this.lockerPrev = p;
    }

    public void setLockerNext(CursorImpl n) {
        this.lockerNext = n;
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        if (this.dupBin != null) {
            sb.append(" dupIdx=\"").append(this.dupIndex).append("\"");
        }
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
            sb.append(this.dupBin == null ? "" : this.dupBin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public LockStats getLockStats() throws DatabaseException {
        return this.locker.collectStats(new LockStats());
    }

    private void trace(Level level, String changeType, BIN theBin, LN ln, int lnIndex, long oldLsn, long newLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(DbLsn.getNoFormatString(oldLsn));
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !CursorImpl.class.desiredAssertionStatus();
    }

    public static class KeyChangeStatus {
        public OperationStatus status;
        public boolean keyChange;

        public KeyChangeStatus(OperationStatus status, boolean keyChange) {
            this.status = status;
            this.keyChange = keyChange;
        }
    }

    public static class SearchMode {
        public static final SearchMode SET = new SearchMode(true, false);
        public static final SearchMode BOTH = new SearchMode(true, true);
        public static final SearchMode SET_RANGE = new SearchMode(false, false);
        public static final SearchMode BOTH_RANGE = new SearchMode(false, true);
        private boolean exactSearch;
        private boolean dataSearch;

        private SearchMode(boolean exactSearch, boolean dataSearch) {
            this.exactSearch = exactSearch;
            this.dataSearch = dataSearch;
        }

        public final boolean isExactSearch() {
            return this.exactSearch;
        }

        public final boolean isDataSearch() {
            return this.dataSearch;
        }
    }
}

