/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.RecoveryException;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryManager {
    private static final String TRACE_DUP_ROOT_REPLACE = "DupRootRecover:";
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_IN_DEL_REPLAY = "INDelReplay:";
    private static final String TRACE_IN_DUPDEL_REPLAY = "INDupDelReplay:";
    private static final String TRACE_ROOT_DELETE = "RootDelete:";
    private static final int CLEAR_INCREMENT = 100;
    private EnvironmentImpl env;
    private int readBufferSize;
    private RecoveryInfo info;
    private Set committedTxnIds;
    private Set inListRebuildDbIds;
    private Level detailedTraceLevel;
    private Map fileSummaryLsns;
    private int inListClearCounter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashSet();
        this.inListRebuildDbIds = new HashSet();
        this.fileSummaryLsns = new HashMap();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_RECOVERY);
    }

    public RecoveryInfo recover(boolean readOnly) throws DatabaseException {
        this.info = new RecoveryInfo();
        try {
            FileManager fileManager = this.env.getFileManager();
            if (fileManager.filesExist()) {
                this.findEndOfLog(readOnly);
                Tracer.trace(Level.INFO, this.env, "Recovery underway, found end of log");
                this.findLastCheckpoint();
                Tracer.trace(Level.INFO, this.env, "Recovery checkpoint search, " + this.info);
                this.env.readMapTreeFromLog(this.info.useRootLsn);
                this.buildTree();
            } else {
                this.env.enableDebugLoggingToDbLog();
                Tracer.trace(Level.INFO, this.env, "Recovery w/no files.");
                this.env.logMapTreeRoot();
            }
            if (!readOnly) {
                CheckpointConfig config = new CheckpointConfig();
                config.setForce(true);
                this.env.getCheckpointer().doCheckpoint(config, false, false, "recovery");
            }
        }
        catch (IOException e) {
            Tracer.trace(this.env, "RecoveryManager", "recover", "Couldn't recover", e);
            throw new RecoveryException(this.env, "Couldn't recover: " + e.getMessage(), e);
        }
        finally {
            Tracer.trace(Level.INFO, this.env, "Recovery finished: " + this.info);
        }
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        LastFileReader reader = new LastFileReader(this.env, this.readBufferSize);
        while (reader.readNextEntry()) {
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (!LogEntryType.LOG_CKPT_START.equals(type) || this.info.partialCheckpointStartLsn != -1L) continue;
            this.info.partialCheckpointStartLsn = reader.getLastLsn();
        }
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        this.env.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.env.enableDebugLoggingToDbLog();
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.env, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isRoot() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.env.getLogManager().get(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.env.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        if (this.info.useRootLsn == -1L) {
            throw new RecoveryException(this.env, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    private void buildTree() throws IOException, DatabaseException {
        this.inListClearCounter = 0;
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(1) + "read map INs");
        long start = System.currentTimeMillis();
        this.readINsAndTrackIds(this.info.checkpointStartLsn);
        long end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(1, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(2) + "read map BINDeltas");
        start = System.currentTimeMillis();
        this.info.numOtherINs += this.readINs(this.info.checkpointStartLsn, true, LogEntryType.LOG_BIN_DELTA, null, null, true);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(2, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(3) + "undo map LNs");
        start = System.currentTimeMillis();
        HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
        mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
        this.undoLNs(this.info, mapLNSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(3, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(4) + "redo map LNs");
        start = System.currentTimeMillis();
        mapLNSet.add(LogEntryType.LOG_MAPLN);
        this.redoLNs(this.info, mapLNSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(4, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(5) + "read other INs");
        start = System.currentTimeMillis();
        this.info.numOtherINs += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_IN, LogEntryType.LOG_BIN, LogEntryType.LOG_IN_DELETE_INFO, false);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(5, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(6) + "read BINDeltas");
        start = System.currentTimeMillis();
        this.info.numBinDeltas = this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_BIN_DELTA, null, null, true);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(6, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(7) + "read dup INs");
        start = System.currentTimeMillis();
        this.info.numDuplicateINs += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_DIN, LogEntryType.LOG_DBIN, LogEntryType.LOG_IN_DUPDELETE_INFO, true);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(7, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(8) + "read dup BINDeltas");
        start = System.currentTimeMillis();
        this.info.numBinDeltas += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_DUP_BIN_DELTA, null, null, true);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(8, start, end) + this.info.toString());
        this.rebuildINList();
        this.env.invokeEvictor();
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(9) + "undo LNs");
        start = System.currentTimeMillis();
        HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
        lnSet.add(LogEntryType.LOG_LN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.undoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(9, start, end) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passStartHeader(10) + "redo LNs");
        start = System.currentTimeMillis();
        lnSet.add(LogEntryType.LOG_LN);
        lnSet.add(LogEntryType.LOG_NAMELN);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN);
        lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
        this.redoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.INFO, this.env, this.passEndHeader(10, start, end) + this.info.toString());
    }

    private void readINsAndTrackIds(long rollForwardLsn) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, true, false, this.info.partialCheckpointStartLsn, this.fileSummaryLsns);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_IN_DELETE_INFO);
        try {
            this.info.numMapINs = 0;
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                this.replayOneIN(reader, db, false);
                ++this.info.numMapINs;
            }
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                if (this.info.useMaxNodeId < this.info.checkpointEnd.getLastNodeId()) {
                    this.info.useMaxNodeId = this.info.checkpointEnd.getLastNodeId();
                }
                if (this.info.useMaxDbId < this.info.checkpointEnd.getLastDbId()) {
                    this.info.useMaxDbId = this.info.checkpointEnd.getLastDbId();
                }
                if (this.info.useMaxTxnId < this.info.checkpointEnd.getLastTxnId()) {
                    this.info.useMaxTxnId = this.info.checkpointEnd.getLastTxnId();
                }
            }
            Node.setLastNodeId(this.info.useMaxNodeId);
            this.env.getDbMapTree().setLastDbId(this.info.useMaxDbId);
            this.env.getTxnManager().setLastTxnId(this.info.useMaxTxnId);
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    private int readINs(long rollForwardLsn, boolean mapDbOnly, LogEntryType inType1, LogEntryType inType2, LogEntryType inType3, boolean requireExactMatch) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, false, mapDbOnly, this.info.partialCheckpointStartLsn, this.fileSummaryLsns);
        if (inType1 != null) {
            reader.addTargetType(inType1);
        }
        if (inType2 != null) {
            reader.addTargetType(inType2);
        }
        if (inType3 != null) {
            reader.addTargetType(inType3);
        }
        int numINsSeen = 0;
        try {
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseImpl db;
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget || (db = dbMapTree.getDb(dbId)) == null) continue;
                this.replayOneIN(reader, db, requireExactMatch);
                ++numINsSeen;
                this.inListRebuildDbIds.add(dbId);
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            return numINsSeen;
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
            return 0;
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db, boolean requireExactMatch) throws DatabaseException {
        if (reader.isDeleteInfo()) {
            this.replayINDelete(db, reader.getDeletedNodeId(), reader.getDeletedIdKey(), reader.getLastLsn());
        } else if (reader.isDupDeleteInfo()) {
            this.replayINDupDelete(db, reader.getDupDeletedNodeId(), reader.getDupDeletedMainKey(), reader.getDupDeletedDupKey(), reader.getLastLsn());
        } else {
            IN in = reader.getIN();
            long inLsn = reader.getLsnOfIN();
            in.postRecoveryInit(db, inLsn);
            in.latch();
            this.replaceOrInsert(db, in, reader.getLastLsn(), inLsn, requireExactMatch);
        }
        if (this.inListClearCounter % 100 == 0) {
            this.env.getInMemoryINs().clear();
        } else {
            ++this.inListClearCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoLNs(RecoveryInfo info, Set lnTypes) throws IOException, DatabaseException {
        long firstActiveLsn = info.firstActiveLsn;
        long lastUsedLsn = info.lastUsedLsn;
        long endOfFileLsn = info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashMap countedFileSummaries = new HashMap();
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (true) {
                if (!reader.readNextEntry()) {
                    info.nRepeatIteratorReads = (int)((long)info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
                    return;
                }
                if (reader.isLN()) {
                    boolean abortKnownDeleted;
                    long abortLsn;
                    long logLsn;
                    LN ln;
                    Long txnId;
                    block9: {
                        txnId = reader.getTxnId();
                        if (this.committedTxnIds.contains(txnId)) continue;
                        this.env.invokeEvictor();
                        ln = reader.getLN();
                        logLsn = reader.getLastLsn();
                        abortLsn = reader.getAbortLsn();
                        abortKnownDeleted = reader.getAbortKnownDeleted();
                        DatabaseId dbId = reader.getDatabaseId();
                        DatabaseImpl db = dbMapTree.getDb(dbId);
                        if (db != null) {
                            Object var25_22;
                            ln.postFetchInit(db, logLsn);
                            try {
                                RecoveryManager.undo(this.detailedTraceLevel, db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, abortLsn, abortKnownDeleted, info, true);
                                this.inListRebuildDbIds.add(dbId);
                                var25_22 = null;
                                if (location.bin == null || !location.bin.getLatch().isOwner()) break block9;
                            }
                            catch (Throwable throwable) {
                                var25_22 = null;
                                if (location.bin == null) throw throwable;
                                if (!location.bin.getLatch().isOwner()) throw throwable;
                                location.bin.releaseLatch();
                                throw throwable;
                            }
                            location.bin.releaseLatch();
                        }
                    }
                    TxnNodeId txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                    this.undoUtilizationInfo(ln, logLsn, abortLsn, abortKnownDeleted, txnNodeId, countedFileSummaries, countedAbortLsnNodes);
                    continue;
                }
                this.committedTxnIds.add(new Long(reader.getTxnCommitId()));
            }
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "undoLNs", e);
        }
    }

    private void redoLNs(RecoveryInfo info, Set lnTypes) throws IOException, DatabaseException {
        long endOfFileLsn = info.nextAvailableLsn;
        long rollForwardLsn = info.checkpointStartLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, rollForwardLsn, true, -1L, endOfFileLsn, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                Long txnId;
                if (!reader.isLN() || (txnId = reader.getTxnId()) != null && (txnId == null || !this.committedTxnIds.contains(txnId))) continue;
                this.env.invokeEvictor();
                LN ln = reader.getLN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                long logLsn = reader.getLastLsn();
                long treeLsn = -1L;
                if (db != null) {
                    ln.postFetchInit(db, logLsn);
                    treeLsn = this.redo(db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, info);
                    this.inListRebuildDbIds.add(dbId);
                }
                TxnNodeId txnNodeId = null;
                if (txnId != null) {
                    txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                }
                this.redoUtilizationInfo(logLsn, treeLsn, reader.getAbortLsn(), reader.getAbortKnownDeleted(), ln, txnNodeId, countedAbortLsnNodes);
            }
            info.nRepeatIteratorReads = (int)((long)info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "redoLns", e);
        }
    }

    private void rebuildINList() throws DatabaseException {
        this.env.getInMemoryINs().clear();
        this.env.getDbMapTree().rebuildINListMapDb();
        Iterator iter = this.inListRebuildDbIds.iterator();
        while (iter.hasNext()) {
            DatabaseId dbId = (DatabaseId)iter.next();
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.env.getDbMapTree().getDb(dbId);
            db.getTree().rebuildINList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsert(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, boolean requireExactMatch) throws DatabaseException {
        block11: {
            ArrayList trackingList = null;
            try {
                block10: {
                    try {
                        if (inFromLog.isRoot()) {
                            if (inFromLog.containsDuplicates()) {
                                this.replaceOrInsertDuplicateRoot(db, (DIN)inFromLog, logLsn);
                                break block10;
                            } else {
                                this.replaceOrInsertRoot(db, inFromLog, logLsn);
                            }
                            break block10;
                        }
                        trackingList = new ArrayList();
                        this.replaceOrInsertChild(db, inFromLog, logLsn, inLsn, trackingList, requireExactMatch);
                    }
                    catch (Exception e) {
                        String trace = this.printTrackList(trackingList);
                        Tracer.trace(db.getDbEnvironment(), "RecoveryManager", "replaceOrInsert", " lsnFromLog:" + DbLsn.getNoFormatString(logLsn) + " " + trace, e);
                        throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(logLsn), e);
                    }
                }
                Object var12_7 = null;
                if (!inFromLog.getLatch().isOwner()) break block11;
            }
            catch (Throwable throwable) {
                Object var12_8 = null;
                if (inFromLog.getLatch().isOwner()) {
                    inFromLog.releaseLatch();
                }
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                    throw new AssertionError((Object)(Latch.latchesHeldToString() + "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId()));
                }
                throw throwable;
            }
            inFromLog.releaseLatch();
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError((Object)(Latch.latchesHeldToString() + "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId()));
        }
    }

    private String printTrackList(List trackingList) {
        if (trackingList != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append((TrackingInfo)iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replayINDelete(DatabaseImpl db, long logNid, Key logIdKey, long logLsn) throws DatabaseException {
        int index;
        boolean deleted;
        boolean found;
        block6: {
            IN parent = null;
            found = false;
            deleted = false;
            index = -1;
            try {
                Tree tree = db.getTree();
                parent = tree.search(logIdKey, Tree.SearchType.NORMAL, logNid, null);
                if (parent == null) {
                    tree.withRootLatched(new RootDeleter(tree));
                    DbTree dbTree = db.getDbEnvironment().getDbMapTree();
                    dbTree.modifyDbRoot(db);
                    RecoveryManager.traceRootDeletion(Level.FINE, db);
                    deleted = true;
                } else {
                    index = parent.findEntry(logIdKey, false, true);
                    if (index >= 0) {
                        found = true;
                        deleted = parent.deleteEntry(index, false);
                    }
                }
                Object var14_11 = null;
                if (parent == null) break block6;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (parent != null) {
                    parent.releaseLatch();
                }
                this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, false);
                throw throwable;
            }
            parent.releaseLatch();
        }
        this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replayINDupDelete(DatabaseImpl db, long logNid, Key logMainKey, Key logDupKey, long logLsn) throws DatabaseException {
        int index;
        boolean deleted;
        boolean found;
        IN subtreeRoot;
        IN duplicateRoot;
        IN mainTreeBIN;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block26: {
                            block27: {
                                mainTreeBIN = null;
                                duplicateRoot = null;
                                subtreeRoot = null;
                                found = false;
                                deleted = false;
                                index = -1;
                                try {
                                    Tree tree = db.getTree();
                                    Node n = tree.search(logMainKey, Tree.SearchType.NORMAL, -1L, null);
                                    if (n == null) {
                                        Object var18_14 = null;
                                        if (mainTreeBIN == null || !mainTreeBIN.getLatch().isOwner()) break block26;
                                        break block27;
                                    }
                                    if (!(n instanceof BIN)) {
                                        IN in = n;
                                        in.releaseLatch();
                                        break block28;
                                    }
                                    mainTreeBIN = (BIN)n;
                                    index = mainTreeBIN.findEntry(logMainKey, false, true);
                                    if (index < 0) {
                                        break block29;
                                    }
                                    n = mainTreeBIN.fetchTarget(index);
                                    if (n instanceof LN) {
                                        break block30;
                                    }
                                    duplicateRoot = n;
                                    duplicateRoot.latch();
                                    subtreeRoot = tree.searchSubTree(duplicateRoot, logDupKey, Tree.SearchType.NORMAL, logNid, null);
                                    if (subtreeRoot == null) {
                                        if (index >= 0) {
                                            found = true;
                                            deleted = mainTreeBIN.deleteEntry(index, false);
                                        }
                                        break block31;
                                    }
                                    index = subtreeRoot.findEntry(logDupKey, false, true);
                                    if (index >= 0) {
                                        found = true;
                                        deleted = subtreeRoot.deleteEntry(index, false);
                                    }
                                    break block31;
                                }
                                catch (Throwable throwable) {
                                    Object var18_19 = null;
                                    if (mainTreeBIN != null && mainTreeBIN.getLatch().isOwner()) {
                                        mainTreeBIN.releaseLatch();
                                    }
                                    if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                                        duplicateRoot.releaseLatch();
                                    }
                                    if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
                                        subtreeRoot.releaseLatch();
                                    }
                                    this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
                                    throw throwable;
                                }
                            }
                            mainTreeBIN.releaseLatch();
                        }
                        if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                            duplicateRoot.releaseLatch();
                        }
                        if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
                            subtreeRoot.releaseLatch();
                        }
                        this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
                        return;
                    }
                    Object var18_15 = null;
                    if (mainTreeBIN != null && mainTreeBIN.getLatch().isOwner()) {
                        mainTreeBIN.releaseLatch();
                    }
                    if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                        duplicateRoot.releaseLatch();
                    }
                    if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
                        subtreeRoot.releaseLatch();
                    }
                    this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
                    return;
                }
                Object var18_16 = null;
                if (mainTreeBIN != null && mainTreeBIN.getLatch().isOwner()) {
                    mainTreeBIN.releaseLatch();
                }
                if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                    duplicateRoot.releaseLatch();
                }
                if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
                    subtreeRoot.releaseLatch();
                }
                this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
                return;
            }
            Object var18_17 = null;
            if (mainTreeBIN != null && mainTreeBIN.getLatch().isOwner()) {
                mainTreeBIN.releaseLatch();
            }
            if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                duplicateRoot.releaseLatch();
            }
            if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
                subtreeRoot.releaseLatch();
            }
            this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
            return;
        }
        Object var18_18 = null;
        if (mainTreeBIN != null && mainTreeBIN.getLatch().isOwner()) {
            mainTreeBIN.releaseLatch();
        }
        if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
            duplicateRoot.releaseLatch();
        }
        if (subtreeRoot != null && subtreeRoot != duplicateRoot) {
            subtreeRoot.releaseLatch();
        }
        this.traceINDeleteReplay(logNid, logLsn, found, deleted, index, true);
    }

    private void replaceOrInsertRoot(DatabaseImpl db, IN inFromLog, long lsn) throws DatabaseException {
        boolean success = true;
        Tree tree = db.getTree();
        RootUpdater rootUpdater = new RootUpdater(tree, inFromLog, lsn);
        try {
            block4: {
                try {
                    tree.withRootLatched(rootUpdater);
                    if (!rootUpdater.updateDone()) break block4;
                    EnvironmentImpl env = db.getDbEnvironment();
                    env.getDbMapTree().modifyDbRoot(db);
                }
                catch (Exception e) {
                    success = false;
                    throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(lsn), e);
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
            throw throwable;
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertDuplicateRoot(DatabaseImpl db, DIN inFromLog, long lsn) throws DatabaseException {
        boolean success;
        int index;
        IN parent;
        long originalLsn;
        boolean replaced;
        boolean inserted;
        boolean found;
        block8: {
            found = true;
            inserted = false;
            replaced = false;
            originalLsn = -1L;
            Key mainTreeKey = inFromLog.getMainTreeKey();
            parent = null;
            index = -1;
            success = false;
            try {
                parent = db.getTree().search(mainTreeKey, Tree.SearchType.NORMAL, -1L, null);
                if (!$assertionsDisabled && !(parent instanceof BIN)) {
                    throw new AssertionError();
                }
                index = parent.findEntry(mainTreeKey, false, true);
                if (index >= 0) {
                    originalLsn = parent.getLsn(index);
                    if (DbLsn.compareTo(originalLsn, lsn) < 0) {
                        parent.setEntry(index, inFromLog, mainTreeKey, lsn, parent.getState(index));
                        replaced = true;
                    }
                } else {
                    ChildReference newRef = new ChildReference(inFromLog, mainTreeKey, lsn);
                    boolean insertOk = parent.insertEntry(newRef);
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                    found = false;
                }
                success = true;
                Object var17_14 = null;
                if (parent == null) break block8;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                if (parent != null) {
                    parent.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, -1L, index);
                throw throwable;
            }
            parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, -1L, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertChild(DatabaseImpl db, IN inFromLog, long logLsn, long inLsn, List trackingList, boolean requireExactMatch) throws DatabaseException {
        SearchResult result;
        boolean success;
        long originalLsn;
        boolean replaced;
        boolean inserted;
        block13: {
            block11: {
                block12: {
                    inserted = false;
                    replaced = false;
                    originalLsn = -1L;
                    success = false;
                    result = new SearchResult();
                    try {
                        block15: {
                            Key idKey;
                            block14: {
                                result = db.getTree().getParentINForChildIN(inFromLog, requireExactMatch, trackingList);
                                if (result.parent == null) {
                                    Object var19_12 = null;
                                    if (result.parent == null) break block11;
                                    break block12;
                                }
                                idKey = result.parent.getChildKey(inFromLog);
                                if (result.index < 0) break block14;
                                if (result.parent.getLsn(result.index) != logLsn) {
                                    if (result.exactParentFound) {
                                        originalLsn = result.parent.getLsn(result.index);
                                        if (DbLsn.compareTo(originalLsn, logLsn) < 0) {
                                            result.parent.updateEntry(result.index, inFromLog, inLsn);
                                            replaced = true;
                                        }
                                        break block15;
                                    } else {
                                        ChildReference ref = new ChildReference(inFromLog, idKey, inLsn);
                                        boolean insertOk = result.parent.insertEntry(ref);
                                        if (!$assertionsDisabled && !insertOk) {
                                            throw new AssertionError((Object)("Nomatch, couln't insert for LSN " + DbLsn.toString(logLsn) + " parent=" + result.parent.getNodeId() + " index=" + result.index));
                                        }
                                        inserted = true;
                                    }
                                }
                                break block15;
                            }
                            ChildReference newRef = new ChildReference(inFromLog, idKey, inLsn);
                            boolean insertOk = result.parent.insertEntry(newRef);
                            if (!$assertionsDisabled && !insertOk) {
                                throw new AssertionError();
                            }
                            inserted = true;
                        }
                        success = true;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var19_14 = null;
                        if (result.parent != null) {
                            result.parent.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
                        throw throwable;
                    }
                }
                result.parent.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
            return;
        }
        Object var19_13 = null;
        if (result.parent != null) {
            result.parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl db, TreeLocation location, LN lnFromLog, Key mainKey, Key dupKey, long logLsn, RecoveryInfo info) throws DatabaseException {
        long l;
        boolean success;
        boolean inserted;
        boolean replaced;
        boolean found;
        block17: {
            block15: {
                long l2;
                block16: {
                    found = false;
                    replaced = false;
                    inserted = false;
                    success = false;
                    try {
                        location.reset();
                        found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, true, false, true);
                        if (found || location.bin != null) break block15;
                        success = true;
                        l2 = -1L;
                        Object var16_17 = null;
                        if (location.bin == null || !location.bin.getLatch().isOwner()) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        if (location.bin != null && location.bin.getLatch().isOwner()) {
                            location.bin.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
                        throw throwable;
                    }
                    location.bin.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
                return l2;
            }
            if (lnFromLog.containsDuplicates()) {
                if (found) {
                    DIN duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                    if (DbLsn.compareTo(logLsn, location.childLsn) >= 0) {
                        duplicateRoot.updateDupCountLNRefAndNullTarget(logLsn);
                    }
                }
            } else if (found) {
                ++info.lnFound;
                if (DbLsn.compareTo(logLsn, location.childLsn) > 0) {
                    ++info.lnReplaced;
                    replaced = true;
                    location.bin.updateEntry(location.index, null, logLsn);
                }
                if (DbLsn.compareTo(logLsn, location.childLsn) >= 0) {
                    Key deletedKey;
                    Key key = deletedKey = location.bin.containsDuplicates() ? dupKey : mainKey;
                    if (lnFromLog.isDeleted()) {
                        db.getDbEnvironment().addToCompressorQueue(location.bin, deletedKey);
                    }
                }
            } else {
                ++info.lnNotFound;
                if (!lnFromLog.isDeleted()) {
                    ++info.lnInserted;
                    inserted = true;
                    boolean insertOk = RecoveryManager.insertRecovery(db, location, logLsn);
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                }
            }
            success = true;
            l = found ? location.childLsn : -1L;
            Object var16_18 = null;
            if (location.bin == null || !location.bin.getLatch().isOwner()) break block17;
            location.bin.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, -1L, location.index);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean undo(Level traceLevel, DatabaseImpl db, TreeLocation location, LN lnFromLog, Key mainKey, Key dupKey, long logLsn, long abortLsn, boolean abortKnownDeleted, RecoveryInfo info, boolean splitsAllowed) throws DatabaseException {
        boolean bl;
        boolean found = false;
        boolean replaced = false;
        boolean success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, splitsAllowed, true, false);
            if (lnFromLog.containsDuplicates()) {
                if (found) {
                    DIN duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
                    if (DbLsn.compareTo(logLsn, location.childLsn) == 0) {
                        duplicateRoot.updateDupCountLNRefAndNullTarget(abortLsn);
                        replaced = true;
                    }
                }
            } else if (found) {
                boolean updateEntry;
                if (info != null) {
                    ++info.lnFound;
                }
                boolean bl2 = updateEntry = DbLsn.compareTo(logLsn, location.childLsn) == 0;
                if (updateEntry) {
                    if (abortLsn == -1L) {
                        location.bin.setKnownDeletedLeaveTarget(location.index);
                        Key deletedKey = location.bin.containsDuplicates() ? dupKey : mainKey;
                        db.getDbEnvironment().addToCompressorQueue(location.bin, deletedKey);
                    } else {
                        if (info != null) {
                            ++info.lnReplaced;
                        }
                        replaced = true;
                        location.bin.updateEntry(location.index, null, abortLsn);
                        if (abortKnownDeleted) {
                            location.bin.setKnownDeleted(location.index);
                        } else {
                            location.bin.clearKnownDeleted(location.index);
                        }
                    }
                }
            } else if (info != null) {
                ++info.lnNotFound;
            }
            success = true;
            bl = replaced;
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            RecoveryManager.trace(traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
            throw throwable;
        }
        RecoveryManager.trace(traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
        return bl;
    }

    private static boolean insertRecovery(DatabaseImpl db, TreeLocation location, long logLsn) throws DatabaseException {
        BIN parentBIN = location.bin;
        ChildReference newLNRef = new ChildReference(null, location.lnKey, logLsn);
        int entryIndex = parentBIN.insertEntry1(newLNRef);
        if ((entryIndex & 0x20000) == 0) {
            boolean canOverwrite = false;
            if (parentBIN.isEntryKnownDeleted(entryIndex &= 0xFFFEFFFF)) {
                canOverwrite = true;
            } else {
                LN currentLN = (LN)parentBIN.fetchTarget(entryIndex);
                if (currentLN.isDeleted()) {
                    canOverwrite = true;
                }
                parentBIN.clearTarget(entryIndex);
            }
            if (canOverwrite) {
                parentBIN.updateEntry(entryIndex, null, logLsn, location.lnKey);
                parentBIN.clearKnownDeleted(entryIndex);
                location.index = entryIndex;
                return true;
            }
            return false;
        }
        location.index = entryIndex & 0xFFFDFFFF;
        return true;
    }

    private void redoUtilizationInfo(long logLsn, long treeLsn, long abortLsn, boolean abortKnownDeleted, LN ln, TxnNodeId txnNodeId, Set countedAbortLsnNodes) {
        UtilizationTracker tracker = this.env.getUtilizationTracker();
        if (ln.isDeleted()) {
            int cmpFsLsnToLogLsn;
            Long logFileNum = new Long(DbLsn.getFileNumber(logLsn));
            long fileSummaryLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(logFileNum));
            int n = cmpFsLsnToLogLsn = fileSummaryLsn != -1L ? DbLsn.compareTo(fileSummaryLsn, logLsn) : -1;
            if (cmpFsLsnToLogLsn < 0) {
                tracker.countObsoleteNode(logLsn, null, true);
            }
        }
        if (treeLsn != -1L) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logLsn, treeLsn);
            if (cmpLogLsnToTreeLsn != 0) {
                int cmpOldFsLsnToNewLsn;
                long newLsn = cmpLogLsnToTreeLsn < 0 ? treeLsn : logLsn;
                long oldLsn = cmpLogLsnToTreeLsn > 0 ? treeLsn : logLsn;
                Long oldLsnFile = new Long(DbLsn.getFileNumber(oldLsn));
                long oldFsLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(oldLsnFile));
                int n = cmpOldFsLsnToNewLsn = oldFsLsn != -1L ? DbLsn.compareTo(oldFsLsn, newLsn) : -1;
                if (cmpOldFsLsnToNewLsn < 0) {
                    tracker.countObsoleteNode(oldLsn, null, true);
                }
            }
            if (cmpLogLsnToTreeLsn <= 0 && abortLsn != -1L && !abortKnownDeleted && !countedAbortLsnNodes.contains(txnNodeId)) {
                int cmpAbortFsLsnToLogLsn;
                Long abortFileNum = new Long(DbLsn.getFileNumber(abortLsn));
                long abortFsLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(abortFileNum));
                int n = cmpAbortFsLsnToLogLsn = abortFsLsn != -1L ? DbLsn.compareTo(abortFsLsn, logLsn) : -1;
                if (cmpAbortFsLsnToLogLsn < 0) {
                    tracker.countObsoleteNode(abortLsn, null, true);
                    countedAbortLsnNodes.add(txnNodeId);
                }
            }
        }
    }

    private void undoUtilizationInfo(LN ln, long logLsn, long abortLsn, boolean abortKnownDeleted, TxnNodeId txnNodeId, Map countedFileSummaries, Set countedAbortLsnNodes) {
        Long countedFile;
        int cmpFsLsnToLogLsn;
        UtilizationTracker tracker = this.env.getUtilizationTracker();
        Long logFileNum = new Long(DbLsn.getFileNumber(logLsn));
        long fileSummaryLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(logFileNum));
        int n = cmpFsLsnToLogLsn = fileSummaryLsn != -1L ? DbLsn.compareTo(fileSummaryLsn, logLsn) : -1;
        if (cmpFsLsnToLogLsn < 0) {
            tracker.countObsoleteNode(logLsn, null, true);
        }
        if (cmpFsLsnToLogLsn > 0 && ((countedFile = (Long)countedFileSummaries.get(txnNodeId)) == null || countedFile > logFileNum)) {
            if (!ln.isDeleted()) {
                tracker.countObsoleteNode(logLsn, null, true);
            }
            countedFileSummaries.put(txnNodeId, logFileNum);
        }
        if (abortLsn != -1L && !abortKnownDeleted && !countedAbortLsnNodes.contains(txnNodeId)) {
            int cmpAbortFsLsnToLogLsn;
            Long abortFileNum = new Long(DbLsn.getFileNumber(abortLsn));
            long abortFsLsn = DbLsn.longToLsn((Long)this.fileSummaryLsns.get(abortFileNum));
            int n2 = cmpAbortFsLsnToLogLsn = abortFsLsn != -1L ? DbLsn.compareTo(abortFsLsn, logLsn) : -1;
            if (cmpAbortFsLsnToLogLsn > 0) {
                tracker.countObsoleteNode(abortLsn, null, false);
                countedAbortLsnNodes.add(txnNodeId);
            }
        }
    }

    private String passStartHeader(int passNum) {
        return "Recovery Pass " + passNum + " start: ";
    }

    private String passEndHeader(int passNum, long start, long end) {
        return "Recovery Pass " + passNum + " end (" + (end - start) + "): ";
    }

    private static void trace(Level level, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        Logger logger = database.getDbEnvironment().getLogger();
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(debugType);
            sb.append(" success=").append(success);
            sb.append(" node=");
            sb.append(node.getNodeId());
            sb.append(" lsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != -1L) {
                sb.append(" replacedLsn=");
                sb.append(DbLsn.getNoFormatString(replacedLsn));
            }
            if (abortLsn != -1L) {
                sb.append(" abortLsn=");
                sb.append(DbLsn.getNoFormatString(abortLsn));
            }
            sb.append(" index=").append(index);
            logger.log(useLevel, sb.toString());
        }
    }

    private void traceINDeleteReplay(long nodeId, long logLsn, boolean found, boolean deleted, int index, boolean isDuplicate) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(isDuplicate ? TRACE_IN_DUPDEL_REPLAY : TRACE_IN_DEL_REPLAY);
            sb.append(" node=").append(nodeId);
            sb.append(" lsn=").append(DbLsn.getNoFormatString(logLsn));
            sb.append(" found=").append(found);
            sb.append(" deleted=").append(deleted);
            sb.append(" index=").append(index);
            logger.log(this.detailedTraceLevel, sb.toString());
        }
    }

    private void traceAndThrowException(long badLsn, String method, Exception originalException) throws DatabaseException {
        String badLsnString = DbLsn.getNoFormatString(badLsn);
        Tracer.trace(this.env, "RecoveryManager", method, "last LSN = " + badLsnString, originalException);
        throw new DatabaseException("last LSN=" + badLsnString, originalException);
    }

    public static void traceRootDeletion(Level level, DatabaseImpl database) {
        Logger logger = database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_ROOT_DELETE);
            sb.append(" Dbid=").append(database.getId());
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !RecoveryManager.class.desiredAssertionStatus();
    }

    private static class RootUpdater
    implements WithRootLatched {
        private Tree tree;
        private IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = new ChildReference(this.inFromLog, new Key(new byte[0]), this.lsn);
            this.inFromLog.releaseLatch();
            if (root == null) {
                this.tree.setRoot(newRoot);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private static class RootDeleter
    implements WithRootLatched {
        Tree tree;

        RootDeleter(Tree tree) {
            this.tree = tree;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            this.tree.setRoot(null);
            return null;
        }
    }

    private static class TxnNodeId {
        long nodeId;
        long txnId;

        TxnNodeId(long nodeId, long txnId) {
            this.nodeId = nodeId;
            this.txnId = txnId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TxnNodeId)) {
                return false;
            }
            return ((TxnNodeId)obj).txnId == this.txnId && ((TxnNodeId)obj).nodeId == this.nodeId;
        }

        public int hashCode() {
            return (int)(this.txnId + this.nodeId);
        }

        public String toString() {
            return "txnId=" + this.txnId + "/nodeId=" + this.nodeId;
        }
    }
}

