/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockTimeOutException;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnTimeOutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class LockManager {
    static final long TOTAL_LOCK_OVERHEAD = 72L;
    private static final long REMOVE_TOTAL_LOCK_OVERHEAD = -72L;
    protected Latch lockTableLatch;
    private Map lockTable = new HashMap();
    private EnvironmentImpl envImpl;
    private MemoryBudget memoryBudget;
    private long nRequests;
    private long nWaits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LockManager(EnvironmentImpl envImpl) throws DatabaseException {
        this.lockTableLatch = new Latch("Lock Table", envImpl);
        this.envImpl = envImpl;
        this.memoryBudget = envImpl.getMemoryBudget();
        this.nRequests = 0L;
        this.nWaits = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, DatabaseImpl database) throws DeadlockException, LockNotGrantedException, DatabaseException {
        if (!$assertionsDisabled && timeout < 0L) {
            throw new AssertionError();
        }
        Locker locker2 = locker;
        synchronized (locker2) {
            Long nid = new Long(nodeId);
            LockAttemptResult result = this.attemptLock(nid, locker, type, nonBlockingRequest);
            if (result.success) {
                return result.lockGrant;
            }
            if (!$assertionsDisabled && !this.checkNoLatchesHeld(nonBlockingRequest)) {
                throw new AssertionError((Object)(Latch.countLatchesHeld() + " latches held while trying to lock, lock table =" + Latch.latchesHeldToString()));
            }
            try {
                long startTime;
                boolean doWait = true;
                if (locker.isTimedOut()) {
                    if (this.validateOwnership(nid, locker, type, true, this.memoryBudget)) {
                        doWait = false;
                    } else {
                        String errMsg = this.makeTimeoutMsg("Locker", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), System.currentTimeMillis(), database);
                        throw new TxnTimeOutException(errMsg);
                    }
                }
                boolean keepTime = timeout > 0L;
                long l = startTime = keepTime ? System.currentTimeMillis() : 0L;
                while (doWait) {
                    locker.setWaitingFor(result.useLock);
                    try {
                        locker.wait(timeout);
                    }
                    catch (InterruptedException IE) {
                        throw new RunRecoveryException(this.envImpl, (Throwable)IE);
                    }
                    boolean lockerTimedOut = locker.isTimedOut();
                    long now = System.currentTimeMillis();
                    boolean thisLockTimedOut = keepTime && now - startTime > timeout;
                    boolean isRestart = result.lockGrant == LockGrantType.WAIT_RESTART;
                    if (this.validateOwnership(nid, locker, type, lockerTimedOut || thisLockTimedOut || isRestart, this.memoryBudget)) break;
                    if (isRestart) {
                        throw new RangeRestartException();
                    }
                    if (thisLockTimedOut) {
                        locker.setOnlyAbortable();
                        String errMsg = this.makeTimeoutMsg("Lock", locker, nodeId, type, result.lockGrant, result.useLock, timeout, startTime, now, database);
                        throw new LockTimeOutException(errMsg);
                    }
                    if (!lockerTimedOut) continue;
                    locker.setOnlyAbortable();
                    String errMsg = this.makeTimeoutMsg("Locker", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), now, database);
                    throw new TxnTimeOutException(errMsg);
                }
                Object var23_21 = null;
                locker.setWaitingFor(null);
            }
            catch (Throwable throwable) {
                Object var23_22 = null;
                locker.setWaitingFor(null);
                if (EnvironmentImpl.getForcedYield()) {
                    Thread.yield();
                }
                throw throwable;
            }
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
            locker.addLock(nid, result.useLock, type, result.lockGrant, this.memoryBudget);
            return result.lockGrant;
        }
    }

    protected abstract LockAttemptResult attemptLock(Long var1, Locker var2, LockType var3, boolean var4) throws DatabaseException;

    protected LockAttemptResult attemptLockInternal(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        ++this.nRequests;
        Lock useLock = (Lock)this.lockTable.get(nodeId);
        if (useLock == null) {
            useLock = new Lock(nodeId);
            this.lockTable.put(nodeId, useLock);
            this.memoryBudget.updateCacheMemoryUsage(72L);
        }
        LockGrantType lockGrant = useLock.lock(type, locker, nonBlockingRequest, this.memoryBudget);
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(nodeId, useLock, type, lockGrant, this.memoryBudget);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else {
            if (lockGrant == LockGrantType.DENIED) {
                throw new LockNotGrantedException("Non-blocking lock was denied.");
            }
            ++this.nWaits;
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    protected abstract String makeTimeoutMsg(String var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12, DatabaseImpl var14) throws DatabaseException;

    protected String makeTimeoutMsgInternal(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) {
        StringBuffer sb = new StringBuffer();
        sb.append(lockOrTxn);
        sb.append(" expired. Locker ").append(locker);
        sb.append(": waited for lock on node=").append(nodeId);
        sb.append(" type=").append(type);
        sb.append(" grant=").append(grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start);
        sb.append(" endTime=").append(now);
        sb.append("\nOwners: ").append(useLock.getOwnersClone());
        sb.append("\nWaiters: ").append(useLock.getWaitersListClone()).append("\n");
        StringBuffer deadlockInfo = this.findDeadlock(useLock, locker);
        if (deadlockInfo != null) {
            sb.append(deadlockInfo);
        }
        return sb.toString();
    }

    public void release(long nodeId, Locker locker) throws DatabaseException {
        this.release(nodeId, null, locker, true);
    }

    public void release(Lock lock, Locker locker) throws DatabaseException {
        this.release(-1L, lock, locker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(long nodeId, Lock lock, Locker locker, boolean removeFromLocker) throws DatabaseException {
        Locker locker2 = locker;
        synchronized (locker2) {
            Set newOwners = this.releaseAndFindNotifyTargets(nodeId, lock, locker, removeFromLocker);
            if (newOwners != null) {
                Iterator iter = newOwners.iterator();
                while (iter.hasNext()) {
                    Locker lockerToNotify;
                    Locker locker3 = lockerToNotify = (Locker)iter.next();
                    synchronized (locker3) {
                        lockerToNotify.notifyAll();
                    }
                    if (!EnvironmentImpl.getForcedYield()) continue;
                    Thread.yield();
                }
            }
        }
    }

    protected abstract Set releaseAndFindNotifyTargets(long var1, Lock var3, Locker var4, boolean var5) throws DatabaseException;

    protected Set releaseAndFindNotifyTargetsInternal(long nodeId, Lock lock, Locker locker, boolean removeFromLocker) throws DatabaseException {
        Lock useLock = lock;
        if (useLock == null) {
            useLock = (Lock)this.lockTable.get(new Long(nodeId));
        }
        if (useLock == null) {
            return null;
        }
        Set lockersToNotify = useLock.release(locker, this.memoryBudget);
        if (lockersToNotify == null) {
            return null;
        }
        if (removeFromLocker) {
            if (!$assertionsDisabled && nodeId == -1L) {
                throw new AssertionError();
            }
            locker.removeLock(nodeId, useLock);
        }
        if (useLock.nWaiters() == 0 && useLock.nOwners() == 0) {
            this.lockTable.remove(useLock.getNodeId());
            this.memoryBudget.updateCacheMemoryUsage(-72L);
        }
        return lockersToNotify.size() > 0 ? lockersToNotify : null;
    }

    abstract void transfer(long var1, Locker var3, Locker var4, boolean var5) throws DatabaseException;

    protected void transferInternal(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        if (demoteToRead) {
            useLock.demote(owningLocker);
        }
        LockType lockType = useLock.transfer(owningLocker, destLocker, this.memoryBudget);
        owningLocker.removeLock(nodeId, useLock);
    }

    abstract void transferMultiple(long var1, Locker var3, Locker[] var4) throws DatabaseException;

    protected void transferMultipleInternal(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        useLock.demote(owningLocker);
        LockType lockType = useLock.transferMultiple(owningLocker, destLockers, this.memoryBudget);
        owningLocker.removeLock(nodeId, useLock);
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    protected void demoteInternal(long nodeId, Locker locker) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        useLock.demote(locker);
        locker.moveWriteToReadLock(nodeId, useLock, this.memoryBudget);
    }

    abstract boolean isLocked(Long var1) throws DatabaseException;

    protected boolean isLockedInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.nOwners() != 0;
    }

    abstract boolean isOwner(Long var1, Locker var2, LockType var3) throws DatabaseException;

    protected boolean isOwnerInternal(Long nodeId, Locker locker, LockType type) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isOwner(locker, type);
    }

    abstract boolean isWaiter(Long var1, Locker var2) throws DatabaseException;

    protected boolean isWaiterInternal(Long nodeId, Locker locker) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isWaiter(locker);
    }

    abstract int nWaiters(Long var1) throws DatabaseException;

    protected int nWaitersInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nWaiters();
    }

    abstract int nOwners(Long var1) throws DatabaseException;

    protected int nOwnersInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nOwners();
    }

    abstract Locker getWriteOwnerLocker(Long var1) throws DatabaseException;

    protected Locker getWriteOwnerLockerInternal(Long nodeId) throws DatabaseException {
        Lock lock = (Lock)this.lockTable.get(nodeId);
        if (lock == null) {
            return null;
        }
        if (lock.nOwners() > 1) {
            return null;
        }
        return lock.getWriteOwnerLocker();
    }

    protected abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4, MemoryBudget var5) throws DatabaseException;

    protected boolean validateOwnershipInternal(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        Lock entry;
        if (this.isOwnerInternal(nodeId, locker, type)) {
            return true;
        }
        if (flushFromWaiters && (entry = (Lock)this.lockTable.get(nodeId)) != null) {
            entry.flushWaiter(locker, mb);
        }
        return false;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        LockStats stats = new LockStats();
        stats.setNRequests(this.nRequests);
        stats.setNWaits(this.nWaits);
        if (config.getClear()) {
            this.nWaits = 0L;
            this.nRequests = 0L;
        }
        LatchStats latchStats = this.lockTableLatch.getLatchStats();
        stats.setLockTableLatchStats(latchStats);
        if (!config.getFast()) {
            this.dumpLockTable(stats);
        }
        return stats;
    }

    protected abstract void dumpLockTable(LockStats var1) throws DatabaseException;

    protected void dumpLockTableInternal(LockStats stats) {
        stats.setNTotalLocks(this.lockTable.size());
        Iterator iter = this.lockTable.values().iterator();
        while (iter.hasNext()) {
            Lock lock = (Lock)iter.next();
            stats.setNWaiters(stats.getNWaiters() + lock.nWaiters());
            stats.setNOwners(stats.getNOwners() + lock.nOwners());
            Iterator ownerIter = lock.getOwnersClone().iterator();
            while (ownerIter.hasNext()) {
                LockInfo info = (LockInfo)ownerIter.next();
                if (info.getLockType().isWriteLock()) {
                    stats.setNWriteLocks(stats.getNWriteLocks() + 1);
                    continue;
                }
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    public String dumpToString() throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        this.lockTableLatch.acquire();
        Iterator keys = this.lockTable.keySet().iterator();
        while (keys.hasNext()) {
            Long nid = (Long)keys.next();
            Lock entry = (Lock)this.lockTable.get(nid);
            sb.append("---- Node Id: ").append(nid).append("----\n");
            sb.append(entry);
            sb.append('\n');
        }
        this.lockTableLatch.release();
        return sb.toString();
    }

    private boolean checkNoLatchesHeld(boolean nonBlockingRequest) {
        if (nonBlockingRequest) {
            return true;
        }
        return Latch.countLatchesHeld() == 0;
    }

    private StringBuffer findDeadlock(Lock lock, Locker rootLocker) {
        HashSet<Locker> ownerSet = new HashSet<Locker>();
        ownerSet.add(rootLocker);
        StringBuffer ret = this.findDeadlock1(ownerSet, lock, rootLocker);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private StringBuffer findDeadlock1(Set ownerSet, Lock lock, Locker rootLocker) {
        Iterator ownerIter = lock.getOwnersClone().iterator();
        while (ownerIter.hasNext()) {
            LockInfo info = (LockInfo)ownerIter.next();
            Locker locker = info.getLocker();
            Lock waitsFor = locker.getWaitingFor();
            if (ownerSet.contains(locker) || locker == rootLocker) {
                StringBuffer ret = new StringBuffer();
                ret.append("Transaction ").append(locker.toString());
                ret.append(" owns ").append(lock.getNodeId());
                ret.append(" ").append(info).append("\n");
                ret.append("Transaction ").append(locker.toString());
                ret.append(" waits for ");
                if (waitsFor == null) {
                    ret.append(" nothing");
                } else {
                    ret.append(" node ");
                    ret.append(waitsFor.getNodeId());
                }
                ret.append("\n");
                return ret;
            }
            if (waitsFor == null) continue;
            ownerSet.add(locker);
            StringBuffer sb = this.findDeadlock1(ownerSet, waitsFor, rootLocker);
            if (sb != null) {
                String waitInfo = "Transaction " + locker + " waits for node " + waitsFor.getNodeId() + "\n";
                sb.insert(0, waitInfo);
                return sb;
            }
            ownerSet.remove(locker);
        }
        return null;
    }

    static {
        $assertionsDisabled = !LockManager.class.desiredAssertionStatus();
    }

    static class LockAttemptResult {
        boolean success;
        Lock useLock;
        LockGrantType lockGrant;

        LockAttemptResult(Lock useLock, LockGrantType lockGrant, boolean success) {
            this.useLock = useLock;
            this.lockGrant = lockGrant;
            this.success = success;
        }
    }
}

