/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class FileProtector {
    public static final String BACKUP_NAME = "Backup";
    public static final String DATABASE_COUNT_NAME = "DatabaseCount";
    public static final String DISK_ORDERED_CURSOR_NAME = "DiskOrderedCursor";
    public static final String FEEDER_NAME = "Feeder";
    public static final String SYNCUP_NAME = "Syncup";
    public static final String VLSN_INDEX_NAME = "VLSNIndex";
    public static final String NETWORK_RESTORE_NAME = "NetworkRestore";
    private final EnvironmentImpl envImpl;
    private final NavigableMap<Long, Long> activeFiles = new TreeMap<Long, Long>();
    private final NavigableMap<Long, ReservedFileInfo> reservedFiles = new TreeMap<Long, ReservedFileInfo>();
    private final NavigableMap<Long, Long> condemnedFiles = new TreeMap<Long, Long>();
    private final Map<String, ProtectedFileSet> protectedFileSets = new HashMap<String, ProtectedFileSet>();
    private ProtectedFileRange vlsnIndexRange;

    FileProtector(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    private void addFileProtection(ProtectedFileSet pfs) {
        if (this.protectedFileSets.putIfAbsent(pfs.getName(), pfs) != null) {
            throw EnvironmentFailureException.unexpectedState("ProtectedFileSets already present name=" + pfs.getName());
        }
    }

    public synchronized void removeFileProtection(ProtectedFileSet pfs) {
        ProtectedFileSet oldPfs = this.protectedFileSets.remove(pfs.getName());
        if (oldPfs == null) {
            throw EnvironmentFailureException.unexpectedState("ProtectedFileSet not found name=" + pfs.getName());
        }
        if (oldPfs != pfs) {
            throw EnvironmentFailureException.unexpectedState("ProtectedFileSet mismatch name=" + pfs.getName());
        }
    }

    public synchronized ProtectedFileRange protectFileRange(String name, long rangeStart) {
        return this.protectFileRange(name, rangeStart, false);
    }

    public synchronized ProtectedFileRange protectFileRange(String name, long rangeStart, boolean protectVlsnIndex) {
        ProtectedFileRange fileRange = new ProtectedFileRange(name, rangeStart, protectVlsnIndex);
        this.addFileProtection(fileRange);
        return fileRange;
    }

    public synchronized ProtectedActiveFileSet protectActiveFiles(String name) {
        return this.protectActiveFiles(name, 0, true);
    }

    public synchronized ProtectedActiveFileSet protectActiveFiles(String name, int nReservedFiles, boolean protectNewFiles) {
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        TreeSet<Long> protectedFiles = new TreeSet<Long>(activeFiles.keySet());
        if (nReservedFiles > 0) {
            int n = nReservedFiles;
            for (Long file : this.reservedFiles.descendingKeySet()) {
                protectedFiles.add(file);
                if (--n > 0) continue;
                break;
            }
        }
        Long rangeStart = protectNewFiles ? Long.valueOf(protectedFiles.isEmpty() ? 0L : (Long)protectedFiles.last() + 1L) : null;
        ProtectedActiveFileSet pfs = new ProtectedActiveFileSet(name, protectedFiles, rangeStart);
        this.addFileProtection(pfs);
        return pfs;
    }

    private synchronized NavigableMap<Long, Long> getActiveFiles() {
        long firstNewFile;
        FileManager fileManager = this.envImpl.getFileManager();
        if (this.activeFiles.isEmpty()) {
            Long[] files = fileManager.getAllFileNumbers();
            for (int i = 0; i < files.length - 1; ++i) {
                long file = files[i];
                File fileObj = new File(fileManager.getFullFileName(file));
                this.activeFiles.put(file, fileObj.length());
            }
        }
        long lastFile = DbLsn.getFileNumber(fileManager.getNextLsn());
        for (long file = firstNewFile = this.activeFiles.isEmpty() ? 0L : (Long)this.activeFiles.lastKey() + 1L; file < lastFile; ++file) {
            File fileObj = new File(fileManager.getFullFileName(file));
            if (!fileObj.exists() && !this.envImpl.isMemOnly()) {
                throw EnvironmentFailureException.unexpectedState("File 0x" + Long.toHexString(file) + " lastFile=" + Long.toHexString(lastFile));
            }
            this.activeFiles.put(file, fileObj.length());
        }
        return this.activeFiles;
    }

    synchronized void reserveFile(Long file, VLSN endVLSN) {
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        Long size = (Long)activeFiles.remove(file);
        if (size == null) {
            throw EnvironmentFailureException.unexpectedState("Only active files (not the last file) may be cleaned/reserved file=0x" + Long.toHexString(file) + " exists=" + this.envImpl.getFileManager().isFileValid(file) + " reserved=" + this.reservedFiles.containsKey(file) + " nextLsn=" + DbLsn.getNoFormatString(this.envImpl.getFileManager().getNextLsn()));
        }
        ReservedFileInfo info = new ReservedFileInfo(size, endVLSN);
        ReservedFileInfo prevInfo = this.reservedFiles.put(file, info);
        assert (prevInfo == null);
    }

    synchronized int getNActiveFiles() {
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        int count = this.getActiveFiles().size();
        if (activeFiles.isEmpty() || (Long)activeFiles.lastKey() < this.envImpl.getFileManager().getCurrentFileNum()) {
            ++count;
        }
        return count;
    }

    synchronized int getNReservedFiles() {
        return this.reservedFiles.size();
    }

    public synchronized Pair<Long, NavigableSet<Long>> getReservedFileInfo() {
        long size = 0L;
        for (ReservedFileInfo info : this.reservedFiles.values()) {
            size += info.size;
        }
        return new Pair<Long, NavigableSet<Long>>(size, new TreeSet(this.reservedFiles.keySet()));
    }

    synchronized boolean isActiveOrNewFile(Long file) {
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        return activeFiles.isEmpty() || file > (Long)activeFiles.lastKey() || activeFiles.containsKey(file);
    }

    synchronized boolean isReservedFile(Long file) {
        return this.reservedFiles.containsKey(file);
    }

    synchronized Pair<Long, Long> takeCondemnedFile(long fromFile) {
        if (!this.condemnedFiles.isEmpty()) {
            Long file = (Long)this.condemnedFiles.firstKey();
            Long size = (Long)this.condemnedFiles.remove(file);
            return new Pair<Long, Long>(file, size);
        }
        if (this.reservedFiles.isEmpty()) {
            return null;
        }
        block0: for (Map.Entry<Long, ReservedFileInfo> entry : this.reservedFiles.tailMap(fromFile).entrySet()) {
            Long file = entry.getKey();
            ReservedFileInfo info = entry.getValue();
            for (ProtectedFileSet pfs : this.protectedFileSets.values()) {
                if (!pfs.isProtected(file, info)) continue;
                continue block0;
            }
            this.reservedFiles.remove(file);
            return new Pair<Long, Long>(file, info.size);
        }
        return null;
    }

    synchronized void putBackCondemnedFile(Long file, Long size) {
        Long oldSize = this.condemnedFiles.put(file, size);
        assert (oldSize == null);
    }

    synchronized LogSizeStats getLogSizeStats() {
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        long activeSize = 0L;
        Iterator iterator = activeFiles.values().iterator();
        while (iterator.hasNext()) {
            long size = (Long)iterator.next();
            activeSize += size;
        }
        long lastFileNum = activeFiles.isEmpty() ? 0L : (Long)activeFiles.lastKey() + 1L;
        File lastFile = new File(this.envImpl.getFileManager().getFullFileName(lastFileNum));
        if (lastFile.exists()) {
            activeSize += lastFile.length();
        }
        long reservedSize = 0L;
        long protectedSize = 0L;
        HashMap<String, Long> protectedSizeMap = new HashMap<String, Long>();
        for (Map.Entry entry : this.reservedFiles.entrySet()) {
            Long file = (Long)entry.getKey();
            ReservedFileInfo info = (ReservedFileInfo)entry.getValue();
            reservedSize += info.size;
            boolean isProtected = false;
            for (ProtectedFileSet pfs : this.protectedFileSets.values()) {
                if (pfs == this.vlsnIndexRange || !pfs.isProtected(file, info)) continue;
                isProtected = true;
                protectedSizeMap.compute(pfs.getName(), (k, v) -> (v != null ? v : 0L) + info.size);
            }
            if (!isProtected) continue;
            protectedSize += info.size;
        }
        return new LogSizeStats(activeSize, reservedSize, protectedSize, protectedSizeMap);
    }

    public void setVLSNIndexProtectedFileRange(ProtectedFileRange pfs) {
        this.vlsnIndexRange = pfs;
    }

    public synchronized Pair<VLSN, Long> checkVLSNIndexTruncation(long bytesNeeded, VLSN preserveVLSN) {
        VLSN truncateVLSN = VLSN.NULL_VLSN;
        long truncateFile = -1L;
        long deleteBytes = 0L;
        block0: for (Map.Entry entry : this.reservedFiles.entrySet()) {
            Long file = (Long)entry.getKey();
            ReservedFileInfo info = (ReservedFileInfo)entry.getValue();
            for (ProtectedFileSet pfs : this.protectedFileSets.values()) {
                if (pfs == this.vlsnIndexRange || !pfs.protectVlsnIndex || !pfs.isProtected(file, info)) continue;
                break block0;
            }
            VLSN lastVlsn = info.endVLSN;
            if (!lastVlsn.isNull()) {
                if (lastVlsn.compareTo(preserveVLSN) > 0) break;
                truncateVLSN = lastVlsn;
                truncateFile = file;
            }
            if ((deleteBytes += info.size) < bytesNeeded) continue;
            break;
        }
        return truncateVLSN.isNull() ? null : new Pair<VLSN, Long>(truncateVLSN, truncateFile);
    }

    synchronized void verifyFileSizes() {
        FileManager fm = this.envImpl.getFileManager();
        Long[] numArray = fm.getAllFileNumbers();
        NavigableMap<Long, Long> activeFiles = this.getActiveFiles();
        for (int i = 0; i < numArray.length - 1; ++i) {
            Long n = numArray[i];
            long trueSize = new File(fm.getFullFileName(n)).length();
            if (activeFiles.containsKey(n)) {
                long activeSize = (Long)activeFiles.get(n);
                if (activeSize == trueSize) continue;
                System.out.format("active file %,d size %,d but true size %,d %n", n, activeSize, trueSize);
                continue;
            }
            if (this.reservedFiles.containsKey(n)) {
                long reservedSize = ((ReservedFileInfo)this.reservedFiles.get((Object)n)).size;
                if (reservedSize == trueSize) continue;
                System.out.format("reserved file %,d size %,d but true size %,d %n", n, reservedSize, trueSize);
                continue;
            }
            System.out.format("true file %x size %,d missing in FileProtector%n", n, trueSize);
        }
    }

    public static class ProtectedActiveFileSet
    extends ProtectedFileSet {
        private NavigableSet<Long> protectedFiles;
        private Long rangeStart;

        ProtectedActiveFileSet(String name, NavigableSet<Long> protectedFiles, Long rangeStart) {
            super(name, false);
            this.protectedFiles = protectedFiles;
            this.rangeStart = rangeStart;
        }

        @Override
        synchronized boolean isProtected(Long file, ReservedFileInfo info) {
            return this.rangeStart != null && file >= this.rangeStart || this.protectedFiles.contains(file);
        }

        public synchronized NavigableSet<Long> getProtectedFiles() {
            return new TreeSet<Long>((SortedSet<Long>)this.protectedFiles);
        }

        public synchronized void truncateTail(long lastProtectedFile) {
            this.protectedFiles = this.protectedFiles.headSet(lastProtectedFile, true);
        }

        public synchronized void truncateHead(long firstProtectedFile) {
            this.protectedFiles = this.protectedFiles.tailSet(firstProtectedFile, true);
        }

        public synchronized void removeFile(Long file) {
            this.protectedFiles.remove(file);
            if (file.equals(this.rangeStart)) {
                this.rangeStart = this.rangeStart + 1L;
            }
        }
    }

    public static class ProtectedFileRange
    extends ProtectedFileSet {
        private volatile long rangeStart;
        private final boolean protectBarrenFiles;

        ProtectedFileRange(String name, long rangeStart, boolean protectVlsnIndex) {
            super(name, protectVlsnIndex);
            this.rangeStart = rangeStart;
            this.protectBarrenFiles = !protectVlsnIndex;
        }

        @Override
        boolean isProtected(Long file, ReservedFileInfo info) {
            return file >= this.rangeStart && (this.protectBarrenFiles || !info.endVLSN.isNull());
        }

        public long getRangeStart() {
            return this.rangeStart;
        }

        public synchronized void advanceRange(long rangeStart) {
            if (rangeStart < this.rangeStart) {
                throw EnvironmentFailureException.unexpectedState("Attempted to advance to a new rangeStart=0x" + Long.toHexString(rangeStart) + " that precedes the old rangeStart=0x" + Long.toHexString(this.rangeStart));
            }
            this.rangeStart = rangeStart;
        }
    }

    public static abstract class ProtectedFileSet {
        private final String name;
        private final boolean protectVlsnIndex;

        private ProtectedFileSet(String name, boolean protectVlsnIndex) {
            this.name = name;
            this.protectVlsnIndex = protectVlsnIndex;
        }

        private String getName() {
            return this.name;
        }

        abstract boolean isProtected(Long var1, ReservedFileInfo var2);

        public String toString() {
            return "ProtectedFileSet:" + this.name;
        }
    }

    static class LogSizeStats {
        final long activeSize;
        final long reservedSize;
        final long protectedSize;
        final Map<String, Long> protectedSizeMap;

        LogSizeStats(long activeSize, long reservedSize, long protectedSize, Map<String, Long> protectedSizeMap) {
            this.activeSize = activeSize;
            this.reservedSize = reservedSize;
            this.protectedSize = protectedSize;
            this.protectedSizeMap = protectedSizeMap;
        }
    }

    private static class ReservedFileInfo {
        long size;
        VLSN endVLSN;

        ReservedFileInfo(long size, VLSN endVLSN) {
            this.size = size;
            this.endVLSN = endVLSN;
        }
    }
}

