/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.EmptyLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.NavigableSet;

public class DbBackup {
    private final EnvironmentImpl envImpl;
    private final boolean envIsReadOnly;
    private final long firstFileInBackup;
    private long lastFileInBackup = -1L;
    private boolean backupStarted;
    private boolean networkRestore;
    private FileProtector.ProtectedActiveFileSet protectedFileSet;
    private NavigableSet<Long> snapshotFiles;
    private boolean invalid;
    private long rollbackStartedFileNumber;
    private TestHook testHook;

    public DbBackup(Environment env) throws DatabaseException {
        this(env, -1L);
    }

    public DbBackup(Environment env, long lastFileInPrevBackup) {
        this(env, DbInternal.getNonNullEnvImpl(env), lastFileInPrevBackup);
    }

    public DbBackup(EnvironmentImpl envImpl) {
        this(null, envImpl, -1L);
    }

    private DbBackup(Environment env, EnvironmentImpl envImpl, long lastFileInPrevBackup) {
        if (env != null) {
            DbInternal.checkOpen(env);
        }
        this.envImpl = envImpl;
        this.envIsReadOnly = envImpl.getFileManager().checkEnvHomePermissions(true);
        if (!this.envIsReadOnly && envImpl.isReadOnly()) {
            throw new IllegalArgumentException("Environment handle may not be read-only when directory is read-write");
        }
        this.firstFileInBackup = lastFileInPrevBackup + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBackup() throws DatabaseException {
        if (this.backupStarted) {
            throw new IllegalStateException("startBackup was already called");
        }
        if (!this.envImpl.addDbBackup(this)) {
            throw this.envImpl.createLogOverwriteException("A replication operation is overwriting log files. The backup can not proceed because files may be invalid. The backup may be attempted at a later time.");
        }
        FileProtector fileProtector = this.envImpl.getFileProtector();
        long backupId = this.networkRestore ? this.envImpl.getNodeSequence().getNextNetworkRestoreId() : this.envImpl.getNodeSequence().getNextBackupId();
        String backupName = (this.networkRestore ? "NetworkRestore" : "Backup") + "-" + backupId;
        int nReservedFiles = this.networkRestore ? 2 : 0;
        FileProtector.ProtectedFileRange allFilesProtected = fileProtector.protectFileRange(backupName + "-init", 0L);
        try {
            if (this.envIsReadOnly) {
                this.lastFileInBackup = this.envImpl.getFileManager().getLastFileNum();
            } else {
                SingleItemEntry<EmptyLogEntry> marker = new SingleItemEntry<EmptyLogEntry>(LogEntryType.LOG_IMMUTABLE_FILE, new EmptyLogEntry());
                long markerLsn = this.envImpl.getLogManager().log(marker, ReplicationContext.NO_REPLICATE);
                this.envImpl.forceLogFileFlip();
                this.lastFileInBackup = DbLsn.getFileNumber(markerLsn);
            }
            this.protectedFileSet = fileProtector.protectActiveFiles(backupName, nReservedFiles, false);
        }
        finally {
            fileProtector.removeFileProtection(allFilesProtected);
        }
        this.backupStarted = true;
        this.protectedFileSet.truncateTail(this.lastFileInBackup);
        this.snapshotFiles = this.protectedFileSet.getProtectedFiles();
        this.protectedFileSet.truncateHead(this.firstFileInBackup);
    }

    public synchronized void endBackup() {
        this.checkBackupStarted();
        this.backupStarted = false;
        assert (TestHookExecute.doHookIfSet(this.testHook));
        this.envImpl.getFileProtector().removeFileProtection(this.protectedFileSet);
        this.envImpl.removeDbBackup(this);
        if (this.invalid) {
            this.invalid = false;
            throw this.envImpl.createLogOverwriteException("A replication operation has overwritten log files from file " + this.rollbackStartedFileNumber + ". Any copied files should be considered invalid and discarded. The backup may be attempted at a later time.");
        }
    }

    public synchronized long getLastFileInBackupSet() {
        this.checkBackupStarted();
        return this.lastFileInBackup;
    }

    public synchronized String[] getLogFilesInBackupSet() {
        this.checkBackupStarted();
        return this.getFileNames(this.snapshotFiles.tailSet(this.firstFileInBackup, true));
    }

    @Deprecated
    public synchronized String[] getLogFilesInBackupSet(long lastFileInPrevBackup) {
        this.checkBackupStarted();
        return this.getFileNames(this.snapshotFiles.tailSet(lastFileInPrevBackup + 1L, true));
    }

    public synchronized String[] getLogFilesInSnapshot() {
        this.checkBackupStarted();
        return this.getFileNames(this.snapshotFiles);
    }

    private String[] getFileNames(NavigableSet<Long> fileSet) {
        FileManager fileManager = this.envImpl.getFileManager();
        String[] names = new String[fileSet.size()];
        int i = 0;
        for (Long file : fileSet) {
            names[i] = fileManager.getPartialFileName(file);
            ++i;
        }
        return names;
    }

    public synchronized void removeFileProtection(String fileName) {
        this.checkBackupStarted();
        this.protectedFileSet.removeFile(this.envImpl.getFileManager().getNumFromName(fileName));
    }

    private void checkBackupStarted() {
        if (!this.backupStarted) {
            throw new IllegalStateException("startBackup was not called");
        }
    }

    public synchronized boolean backupIsOpen() {
        return this.backupStarted;
    }

    public void invalidate(long fileNumber) {
        this.invalid = true;
        this.rollbackStartedFileNumber = fileNumber;
    }

    public void setNetworkRestore() {
        this.networkRestore = true;
    }

    public void setTestHook(TestHook testHook) {
        this.testHook = testHook;
    }
}

