/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.utilint.FormatUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntStat
extends Stat<Integer> {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger counter;

    public AtomicIntStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        this.counter = new AtomicInteger();
    }

    AtomicIntStat(StatDefinition definition, int value) {
        super(definition);
        this.counter = new AtomicInteger(value);
    }

    @Override
    public Integer get() {
        return this.counter.get();
    }

    @Override
    public void set(Integer newValue) {
        this.counter.set(newValue);
    }

    public void increment() {
        this.counter.incrementAndGet();
    }

    public void decrement() {
        this.counter.decrementAndGet();
    }

    public void add(int count) {
        this.counter.addAndGet(count);
    }

    @Override
    public void add(Stat<Integer> other) {
        this.counter.addAndGet((Integer)other.get());
    }

    @Override
    public void clear() {
        this.counter.set(0);
    }

    @Override
    public Stat<Integer> computeInterval(Stat<Integer> base) {
        AtomicIntStat ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(this.counter.get() - (Integer)base.get());
        }
        return ret;
    }

    @Override
    public void negate() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            int current;
            while (!this.counter.compareAndSet(current = this.counter.get(), -current)) {
            }
            return;
        }
    }

    @Override
    public AtomicIntStat copy() {
        return new AtomicIntStat(this.definition, this.counter.get());
    }

    public AtomicIntStat copyAndClear() {
        return new AtomicIntStat(this.definition, this.counter.getAndSet(0));
    }

    @Override
    protected String getFormattedValue() {
        return FormatUtil.decimalScale0().format(this.counter.get());
    }

    @Override
    public boolean isNotSet() {
        return this.counter.get() == 0;
    }
}

