/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

class VisitedObjects {
    private static final int INIT_LEN = 50;
    private Object[] objects = new Object[50];
    private int[] offsets = new int[50];
    private int nextIndex = 0;

    VisitedObjects() {
    }

    void add(Object o, int offset) {
        int i = this.nextIndex++;
        if (this.nextIndex > this.objects.length) {
            this.growVisitedArrays();
        }
        this.objects[i] = o;
        this.offsets[i] = offset;
    }

    int getOffset(Object o) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.objects[i] != o) continue;
            return this.offsets[i];
        }
        return -1;
    }

    Object getObject(int offset) {
        for (int i = 0; i < this.nextIndex; ++i) {
            if (this.offsets[i] != offset) continue;
            return this.objects[i];
        }
        return null;
    }

    void replaceObject(Object existing, Object replacement) {
        for (int i = this.nextIndex - 1; i >= 0; --i) {
            if (this.objects[i] != existing) continue;
            this.objects[i] = replacement;
            return;
        }
        assert (false);
    }

    private void growVisitedArrays() {
        int oldLen = this.objects.length;
        int newLen = oldLen * 2;
        Object[] newObjects = new Object[newLen];
        int[] newOffsets = new int[newLen];
        System.arraycopy(this.objects, 0, newObjects, 0, oldLen);
        System.arraycopy(this.offsets, 0, newOffsets, 0, oldLen);
        this.objects = newObjects;
        this.offsets = newOffsets;
    }
}

