/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SortedLSNTreeWalker {
    protected DatabaseImpl dbImpl;
    private EnvironmentImpl envImpl;
    private long rootLsn;
    private boolean dups;
    private boolean removeINsFromINList;
    private boolean setDbState;
    private long[] currentLSNs;
    private int currentLSNIdx = 0;
    private OffsetList accumulatedLSNFileNumbers;
    private OffsetList accumulatedLSNFileOffsets;
    private TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    private boolean processDupTree = true;
    private boolean passNullLSNNodes = false;
    private List savedExceptions;
    private ExceptionPredicate excPredicate;
    private DatabaseEntry lnKeyEntry = new DatabaseEntry();

    public SortedLSNTreeWalker(DatabaseImpl dbImpl, boolean removeINsFromINList, boolean setDbState, long rootLsn, TreeNodeProcessor callback, List savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        this.dbImpl = dbImpl;
        this.envImpl = dbImpl.getDbEnvironment();
        if (this.envImpl == null) {
            throw new DatabaseException("environmentImpl is null for target db " + dbImpl.getDebugName());
        }
        this.dups = dbImpl.getSortedDuplicates();
        this.removeINsFromINList = removeINsFromINList;
        this.setDbState = setDbState;
        this.rootLsn = rootLsn;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
        this.currentLSNs = new long[0];
        this.currentLSNIdx = 0;
    }

    void setProcessDupTree(boolean processDupTree) {
        this.processDupTree = processDupTree;
    }

    void setPassNullLSNNodes(boolean passNullLSNNodes) {
        this.passNullLSNNodes = passNullLSNNodes;
    }

    private boolean extractINsForDb(INList inList) throws DatabaseException {
        IN thisIN;
        Iterator iter;
        boolean foundSome = false;
        HashSet<IN> foundSet = new HashSet<IN>();
        long memoryChange = 0L;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        inList.latchMajor();
        try {
            inList.latchMinorAndDumpAddedINs();
            iter = inList.iterator();
            while (iter.hasNext()) {
                thisIN = (IN)iter.next();
                if (thisIN.getDatabase() != this.dbImpl) continue;
                foundSome = true;
                if (this.removeINsFromINList) {
                    iter.remove();
                    memoryChange += (long)thisIN.getAccumulatedDelta() - thisIN.getInMemorySize();
                    thisIN.setInListResident(false);
                }
                foundSet.add(thisIN);
            }
        }
        catch (DatabaseException e) {
            mb.updateTreeMemoryUsage(memoryChange);
            throw e;
        }
        finally {
            inList.releaseMajorLatch();
        }
        if (foundSome) {
            iter = foundSet.iterator();
            while (iter.hasNext()) {
                thisIN = (IN)iter.next();
                this.accumulateLSNs(thisIN);
            }
        }
        foundSet = null;
        mb.updateTreeMemoryUsage(memoryChange);
        return foundSome;
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    protected void walkInternal() throws DatabaseException {
        INList inList = this.envImpl.getInMemoryINs();
        IN root = null;
        if (!this.extractINsForDb(inList)) {
            if (this.rootLsn == -1L) {
                return;
            }
            root = this.getRootIN(this.rootLsn);
            this.accumulateLSNs(root);
            this.releaseRootIN(root);
        }
        if (this.setDbState) {
            this.dbImpl.finishedINListHarvest();
        }
        while (true) {
            this.maybeGetMoreINs();
            if (this.currentLSNs == null || this.currentLSNIdx >= this.currentLSNs.length) break;
            this.fetchAndProcessLSN(this.currentLSNs[this.currentLSNIdx++]);
        }
    }

    private void maybeGetMoreINs() {
        if (this.currentLSNs != null && this.currentLSNIdx >= this.currentLSNs.length) {
            if (this.accumulatedLSNFileNumbers == null || this.accumulatedLSNFileNumbers.size() == 0) {
                this.currentLSNs = null;
                this.currentLSNIdx = Integer.MAX_VALUE;
                return;
            }
            long[] tempFileNumbers = this.accumulatedLSNFileNumbers.toArray();
            long[] tempFileOffsets = this.accumulatedLSNFileOffsets.toArray();
            int nLSNs = tempFileNumbers.length;
            this.currentLSNIdx = 0;
            this.currentLSNs = new long[nLSNs];
            for (int i = 0; i < nLSNs; ++i) {
                this.currentLSNs[i] = DbLsn.makeLsn(tempFileNumbers[i], tempFileOffsets[i]);
            }
            Arrays.sort(this.currentLSNs);
            this.accumulatedLSNFileNumbers = null;
            this.accumulatedLSNFileOffsets = null;
        }
    }

    private void accumulateLSNs(IN in) throws DatabaseException {
        boolean isDINRoot;
        boolean childIsLN;
        boolean accumulate = true;
        boolean bl = childIsLN = !this.dups && in instanceof BIN || in instanceof DBIN;
        if (childIsLN && !this.accumulateLNs) {
            accumulate = false;
        }
        boolean bl2 = isDINRoot = in instanceof DIN && in.isRoot();
        if (this.processDupTree || !in.containsDuplicates()) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                long lsn = in.getLsn(i);
                Node node = in.getTarget(i);
                if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) {
                    LN ln;
                    if (!(node instanceof LN) || !(ln = (LN)node).isDirty()) continue;
                    this.callback.processDirtyDeletedLN(lsn, ln, in.getKey(i));
                    continue;
                }
                if (accumulate && node == null) {
                    if (this.accumulatedLSNFileNumbers == null) {
                        this.accumulatedLSNFileNumbers = new OffsetList();
                        this.accumulatedLSNFileOffsets = new OffsetList();
                    }
                    this.accumulatedLSNFileNumbers.add(DbLsn.getFileNumber(lsn), false);
                    this.accumulatedLSNFileOffsets.add(DbLsn.getFileOffset(lsn), false);
                    this.addToLsnINMap(new Long(lsn), in, i);
                    continue;
                }
                if (lsn == -1L && !this.passNullLSNNodes) continue;
                byte[] lnKey = (byte[])(node == null || node instanceof LN ? in.getKey(i) : null);
                this.callback.processLSN(lsn, node == null ? LogEntryType.LOG_LN : node.getLogType(), node, lnKey);
            }
        }
        if (isDINRoot) {
            DIN din = (DIN)in;
            ChildReference dupCountLNRef = din.getDupCountLNRef();
            long lsn = dupCountLNRef.getLsn();
            if (lsn == -1L) {
                DupCountLN dcl = din.getDupCountLN();
                this.callback.processDupCount(dcl.getDupCount());
            } else {
                Node node = this.fetchLSN(lsn, this.lnKeyEntry);
                this.callback.processLSN(lsn, LogEntryType.LOG_DUPCOUNTLN, node, dupCountLNRef.getKey());
            }
        }
    }

    private void fetchAndProcessLSN(long lsn) throws DatabaseException {
        block5: {
            try {
                this.lnKeyEntry.setData(null);
                Node node = this.fetchLSN(lsn, this.lnKeyEntry);
                if (node != null) {
                    this.callback.processLSN(lsn, node.getLogType(), node, this.lnKeyEntry.getData());
                    if (node instanceof IN) {
                        this.accumulateLSNs((IN)node);
                    }
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block5;
                if (this.savedExceptions != null) {
                    this.savedExceptions.add(e);
                }
                throw e;
            }
        }
    }

    protected IN getRootIN(long rootLsn) throws DatabaseException {
        return (IN)this.envImpl.getLogManager().get(rootLsn);
    }

    protected void releaseRootIN(IN ignore) throws DatabaseException {
    }

    protected void addToLsnINMap(Long lsn, IN in, int index) {
    }

    protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry) throws DatabaseException {
        LogEntry entry = this.envImpl.getLogManager().getLogEntry(lsn);
        if (entry instanceof LNLogEntry) {
            lnKeyEntry.setData(((LNLogEntry)entry).getKey());
        }
        return (Node)entry.getMainItem();
    }

    public List getSavedExceptions() {
        return this.savedExceptions;
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5) throws DatabaseException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4) throws DatabaseException;

        public void processDupCount(long var1);
    }
}

