/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.dbi.DatabaseId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class LevelRecorder {
    private Map dbLevels = new HashMap();

    LevelRecorder() {
    }

    void record(DatabaseId dbId, int level) {
        LevelInfo info = (LevelInfo)this.dbLevels.get(dbId);
        if (info == null) {
            info = new LevelInfo();
            this.dbLevels.put(dbId, info);
        }
        info.recordLevel(level);
    }

    Set getDbsWithDifferentLevels() {
        HashSet reprocessDbs = new HashSet();
        Set entries = this.dbLevels.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry oneEntry = iter.next();
            LevelInfo levelInfo = (LevelInfo)oneEntry.getValue();
            if (!levelInfo.getDifferenceSeen()) continue;
            reprocessDbs.add(oneEntry.getKey());
        }
        return reprocessDbs;
    }

    private static class LevelInfo {
        private int highest = Integer.MIN_VALUE;
        private int lowest = Integer.MAX_VALUE;
        private boolean differenceSeen = false;

        private LevelInfo() {
        }

        void recordLevel(int level) {
            if (!this.differenceSeen) {
                if (level < this.lowest) {
                    this.lowest = level;
                }
                if (level > this.highest) {
                    this.highest = level;
                }
                this.differenceSeen = this.highest > this.lowest;
            }
        }

        boolean getDifferenceSeen() {
            return this.differenceSeen;
        }
    }
}

