/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;

public class VLSN
implements Loggable {
    public static final int LOG_SIZE = 16;
    private int generationId;
    private int environmentId;
    private long sequence;

    public VLSN(int generationId, int environmentId, long sequence) {
        this.generationId = generationId;
        this.environmentId = environmentId;
        this.sequence = sequence;
    }

    public VLSN() {
    }

    public int getLogSize() {
        return 16;
    }

    public void writeToLog(ByteBuffer buffer) {
        buffer.putInt(this.generationId);
        buffer.putInt(this.environmentId);
        buffer.putLong(this.sequence);
    }

    public void readFromLog(ByteBuffer buffer, byte entryTypeVersion) throws LogException {
        this.generationId = buffer.getInt();
        this.environmentId = buffer.getInt();
        this.sequence = buffer.getLong();
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("VLSN: ").append("generation id=").append(this.generationId).append(" environmentId=").append(this.environmentId).append(" sequence=").append(this.sequence).append("\n");
    }

    public long getTransactionId() {
        return 0L;
    }

    public int getContentSize() {
        return this.getLogSize();
    }

    public void writeToBuffer(ByteBuffer buffer) {
        this.writeToLog(buffer);
    }

    public void readFromBuffer(ByteBuffer buffer) throws LogException {
        this.readFromLog(buffer, (byte)0);
    }
}

