/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.util.PackedInteger;
import java.util.Comparator;

public class DupKeyData {
    private static final int PREFIX_ONLY = -1;

    public static DatabaseEntry combine(DatabaseEntry paramKey, DatabaseEntry paramData) {
        byte[] buf = DupKeyData.combine(paramKey.getData(), paramKey.getOffset(), paramKey.getSize(), paramData.getData(), paramData.getOffset(), paramData.getSize());
        return new DatabaseEntry(buf);
    }

    public static byte[] combine(byte[] key, byte[] data) {
        return DupKeyData.combine(key, 0, key.length, data, 0, data.length);
    }

    public static byte[] combine(byte[] key, int keyOff, int keySize, byte[] data, int dataOff, int dataSize) {
        int keySizeLen = PackedInteger.getWriteIntLength(keySize);
        byte[] buf = new byte[keySizeLen + keySize + dataSize];
        System.arraycopy(key, keyOff, buf, 0, keySize);
        System.arraycopy(data, dataOff, buf, keySize, dataSize);
        int nextOff = PackedInteger.writeReverseInt(buf, keySize + dataSize, keySize);
        assert (nextOff == buf.length);
        return buf;
    }

    public static void split(DatabaseEntry twoPartKey, DatabaseEntry paramKey, DatabaseEntry paramData) {
        assert (twoPartKey.getOffset() == 0);
        DupKeyData.split(twoPartKey.getData(), twoPartKey.getSize(), paramKey, paramData);
    }

    public static void split(byte[] twoPartKey, int twoPartKeySize, DatabaseEntry paramKey, DatabaseEntry paramData) {
        int keySize = PackedInteger.readReverseInt(twoPartKey, twoPartKeySize - 1);
        assert (keySize != -1);
        if (paramKey != null) {
            byte[] keyBuf = new byte[keySize];
            System.arraycopy(twoPartKey, 0, keyBuf, 0, keySize);
            LN.setEntry(paramKey, keyBuf);
        }
        if (paramData != null) {
            int keySizeLen = PackedInteger.getReadIntLength(twoPartKey, twoPartKeySize - 1);
            int dataSize = twoPartKeySize - keySize - keySizeLen;
            byte[] dataBuf = new byte[dataSize];
            System.arraycopy(twoPartKey, keySize, dataBuf, 0, dataSize);
            LN.setEntry(paramData, dataBuf);
        }
    }

    public static byte[] replaceData(byte[] twoPartKey, byte[] newData) {
        int origKeySize = PackedInteger.readReverseInt(twoPartKey, twoPartKey.length - 1);
        int keySize = origKeySize == -1 ? twoPartKey.length - 1 : origKeySize;
        return DupKeyData.combine(twoPartKey, 0, keySize, newData, 0, newData.length);
    }

    public static DatabaseEntry removeData(byte[] twoPartKey) {
        int keySize = PackedInteger.readReverseInt(twoPartKey, twoPartKey.length - 1);
        assert (keySize != -1);
        return new DatabaseEntry(DupKeyData.makePrefixKey(twoPartKey, 0, keySize));
    }

    public static byte[] makePrefixKey(byte[] key, int keyOff, int keySize) {
        byte[] buf = new byte[keySize + 1];
        System.arraycopy(key, 0, buf, 0, keySize);
        buf[keySize] = -1;
        return buf;
    }

    public static int compareMainKey(byte[] keyBytes1, byte[] keyBytes2, Comparator<byte[]> btreeComparator) {
        int origKeySize2 = PackedInteger.readReverseInt(keyBytes2, keyBytes2.length - 1);
        int keySize2 = origKeySize2 == -1 ? keyBytes2.length - 1 : origKeySize2;
        return DupKeyData.compareMainKey(keyBytes1, keyBytes2, 0, keySize2, btreeComparator);
    }

    public static int compareMainKey(byte[] keyBytes1, byte[] keyBytes2, int keyOff2, int keySize2, Comparator<byte[]> btreeComparator) {
        int keyCmp;
        int keySize1;
        int origKeySize1 = PackedInteger.readReverseInt(keyBytes1, keyBytes1.length - 1);
        int n = keySize1 = origKeySize1 == -1 ? keyBytes1.length - 1 : origKeySize1;
        if (btreeComparator == null) {
            keyCmp = Key.compareUnsignedBytes(keyBytes1, 0, keySize1, keyBytes2, keyOff2, keySize2);
        } else {
            byte[] key1 = new byte[keySize1];
            byte[] key2 = new byte[keySize2];
            System.arraycopy(keyBytes1, 0, key1, 0, keySize1);
            System.arraycopy(keyBytes2, keyOff2, key2, 0, keySize2);
            keyCmp = btreeComparator.compare(key1, key2);
        }
        return keyCmp;
    }

    public static class PutNoOverwriteComparator
    implements Comparator<byte[]> {
        private final Comparator<byte[]> btreeComparator;

        public PutNoOverwriteComparator(Comparator<byte[]> cmp) {
            this.btreeComparator = cmp;
        }

        @Override
        public int compare(byte[] twoPartKey1, byte[] twoPartKey2) {
            return DupKeyData.compareMainKey(twoPartKey1, twoPartKey2, this.btreeComparator);
        }
    }

    public static class NextNoDupComparator
    implements Comparator<byte[]> {
        private final Comparator<byte[]> btreeComparator;

        public NextNoDupComparator(Comparator<byte[]> btreeComparator) {
            this.btreeComparator = btreeComparator;
        }

        @Override
        public int compare(byte[] twoPartKey1, byte[] twoPartKey2) {
            int cmp = DupKeyData.compareMainKey(twoPartKey1, twoPartKey2, this.btreeComparator);
            return cmp != 0 ? cmp : 1;
        }
    }

    public static class TwoPartKeyComparator
    implements Comparator<byte[]> {
        private final Comparator<byte[]> btreeComparator;
        private final Comparator<byte[]> duplicateComparator;

        public TwoPartKeyComparator(Comparator<byte[]> btreeComparator, Comparator<byte[]> dupComparator) {
            this.btreeComparator = btreeComparator;
            this.duplicateComparator = dupComparator;
        }

        @Override
        public int compare(byte[] twoPartKey1, byte[] twoPartKey2) {
            int dataCmp;
            int keyCmp;
            int keySize2;
            int origKeySize1 = PackedInteger.readReverseInt(twoPartKey1, twoPartKey1.length - 1);
            int keySize1 = origKeySize1 == -1 ? twoPartKey1.length - 1 : origKeySize1;
            int origKeySize2 = PackedInteger.readReverseInt(twoPartKey2, twoPartKey2.length - 1);
            int n = keySize2 = origKeySize2 == -1 ? twoPartKey2.length - 1 : origKeySize2;
            if (this.btreeComparator == null) {
                keyCmp = Key.compareUnsignedBytes(twoPartKey1, 0, keySize1, twoPartKey2, 0, keySize2);
            } else {
                byte[] key1 = new byte[keySize1];
                byte[] key2 = new byte[keySize2];
                System.arraycopy(twoPartKey1, 0, key1, 0, keySize1);
                System.arraycopy(twoPartKey2, 0, key2, 0, keySize2);
                keyCmp = this.btreeComparator.compare(key1, key2);
            }
            if (keyCmp != 0) {
                return keyCmp;
            }
            if (origKeySize1 == -1 || origKeySize2 == -1) {
                if (origKeySize1 == origKeySize2) {
                    return 0;
                }
                return origKeySize1 == -1 ? -1 : 1;
            }
            int keySizeLen1 = PackedInteger.getReadIntLength(twoPartKey1, twoPartKey1.length - 1);
            int keySizeLen2 = PackedInteger.getReadIntLength(twoPartKey2, twoPartKey2.length - 1);
            int dataSize1 = twoPartKey1.length - keySize1 - keySizeLen1;
            int dataSize2 = twoPartKey2.length - keySize2 - keySizeLen2;
            if (this.duplicateComparator == null) {
                dataCmp = Key.compareUnsignedBytes(twoPartKey1, keySize1, dataSize1, twoPartKey2, keySize2, dataSize2);
            } else {
                byte[] data1 = new byte[dataSize1];
                byte[] data2 = new byte[dataSize2];
                System.arraycopy(twoPartKey1, keySize1, data1, 0, dataSize1);
                System.arraycopy(twoPartKey2, keySize2, data2, 0, dataSize2);
                dataCmp = this.duplicateComparator.compare(data1, data2);
            }
            return dataCmp;
        }
    }
}

