/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;

class PrivateSelector
extends TargetSelector {
    private final EnvironmentImpl envImpl;
    private Iterator<IN> scanIter;

    public PrivateSelector(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
        this.envImpl = envImpl;
        this.scanIter = null;
    }

    @Override
    public StatGroup loadStats(StatsConfig config) {
        return super.loadStats(config);
    }

    @Override
    public void noteINListChange(int nINs) {
    }

    @Override
    synchronized TargetSelector.SetupInfo startBatch(boolean doSpecialEviction) throws DatabaseException {
        TargetSelector.SetupInfo setupInfo = new TargetSelector.SetupInfo();
        if (this.scanIter == null) {
            this.scanIter = this.envImpl.getInMemoryINs().iterator();
        }
        if (doSpecialEviction) {
            setupInfo.specialEvictionBytes = this.envImpl.specialEviction();
        }
        setupInfo.maxINsPerBatch = this.envImpl.getInMemoryINs().getSize();
        return setupInfo;
    }

    @Override
    IN getNextIN() {
        if (this.envImpl.getMemoryBudget().isTreeUsageAboveMinimum()) {
            if (!this.scanIter.hasNext()) {
                this.scanIter = this.envImpl.getInMemoryINs().iterator();
            }
            return this.scanIter.hasNext() ? this.scanIter.next() : null;
        }
        return null;
    }

    @Override
    StatGroup getINListStats(StatsConfig config) {
        return this.envImpl.getInMemoryINs().loadStats();
    }

    @Override
    Iterator<IN> getScanIterator() {
        return this.scanIter;
    }

    @Override
    void setScanIterator(Iterator<IN> iter) {
        this.scanIter = iter;
    }

    @Override
    public void addEnvironment(EnvironmentImpl unused) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void removeEnvironment(EnvironmentImpl unused) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public boolean checkEnv(EnvironmentImpl env) {
        throw EnvironmentFailureException.unexpectedState();
    }
}

