/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.NodeStateProtocol;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.JoinGroupEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.MonitorChangeListener;
import com.sleepycat.je.rep.monitor.MonitorConfig;
import com.sleepycat.je.rep.monitor.MonitorService;
import com.sleepycat.je.rep.monitor.NewMasterEvent;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.util.DbPing;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.utilint.net.DataChannelFactoryBuilder;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Monitor {
    private final NameIdPair nameIdPair;
    private final MonitorConfig monitorConfig;
    private final ReplicationGroupAdmin repGroupAdmin;
    private Learner learner;
    private MasterChangeListener masterChangeListener;
    private final Logger logger;
    private final Formatter formatter;
    private MonitorChangeListener monitorChangeListener;
    private DataChannelFactory channelFactory;
    private ServiceDispatcher serviceDispatcher;
    AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, Boolean> nodeStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, JoinGroupEvent> joinEvents = new ConcurrentHashMap();
    private PingThread pingThread;
    private boolean disableNotify = false;

    @Deprecated
    public Monitor(ReplicationConfig monitorConfig) {
        this(new MonitorConfig(monitorConfig));
    }

    public Monitor(MonitorConfig monitorConfig) {
        String groupName = monitorConfig.getGroupName();
        if (groupName == null) {
            throw new IllegalArgumentException("Missing group name");
        }
        this.nameIdPair = new NameIdPair(monitorConfig.getNodeName());
        String nodeHost = monitorConfig.getNodeHostPort();
        if (nodeHost == null) {
            throw new IllegalArgumentException("Missing nodeHost");
        }
        this.monitorConfig = monitorConfig.clone();
        this.channelFactory = DataChannelFactoryBuilder.construct(monitorConfig.getRepNetConfig(), groupName);
        this.repGroupAdmin = new ReplicationGroupAdmin(groupName, monitorConfig.getHelperSockets(), this.channelFactory);
        this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(this.nameIdPair);
    }

    public String getGroupName() {
        return this.monitorConfig.getGroupName();
    }

    public NameIdPair getMonitorNameIdPair() {
        return this.nameIdPair;
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public InetSocketAddress getMonitorSocketAddress() {
        return this.monitorConfig.getNodeSocketAddress();
    }

    public ReplicationNode register() throws EnvironmentFailureException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        if (this.repGroupAdmin.getHelperSockets().size() == 0) {
            throw new IllegalStateException("No helper sockets were specified at Monitor initialization");
        }
        RepNodeImpl monitorNode = new RepNodeImpl(this.nameIdPair, NodeType.MONITOR, this.monitorConfig.getNodeHostname(), this.monitorConfig.getNodePort(), JEVersion.CURRENT_VERSION);
        return this.repGroupAdmin.ensureMonitor(monitorNode);
    }

    public void startListener(MonitorChangeListener newListener) throws DatabaseException, IOException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        if (newListener == null) {
            throw new IllegalArgumentException("A MonitorChangeListener must be associated with  this Monitor when invoking this method");
        }
        if (this.monitorChangeListener != null) {
            throw new IllegalStateException("A Listener has already been established");
        }
        this.monitorChangeListener = newListener;
        this.serviceDispatcher = new ServiceDispatcher(this.monitorConfig.getNodeSocketAddress(), this.channelFactory);
        this.serviceDispatcher.start();
        Protocol electionProtocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), this.monitorConfig.getGroupName(), this.nameIdPair, null, this.channelFactory);
        this.learner = new Learner(electionProtocol, this.serviceDispatcher);
        this.serviceDispatcher.register(new MonitorService(this, this.serviceDispatcher));
        this.masterChangeListener = new MasterChangeListener();
        this.learner.addListener(this.masterChangeListener);
        this.learner.start();
        try {
            ReplicationGroup repGroup = this.repGroupAdmin.getGroup();
            RepGroupImpl group = RepInternal.getRepGroupImpl(repGroup);
            this.learner.queryForMaster(group.getAllLearnerSockets());
            this.notifyJoinGroupEventsForActiveNodes(repGroup);
            this.pingThread = new PingThread(repGroup);
            this.pingThread.start();
        }
        catch (UnknownMasterException ume) {
            LoggerUtils.logMsg(this.logger, this.formatter, Level.INFO, "No current master.");
        }
    }

    void disableNotify(boolean disableNotify) {
        this.disableNotify = disableNotify;
    }

    private void notifyJoinGroupEventsForActiveNodes(ReplicationGroup group) {
        NodeStateProtocol stateProtocol = new NodeStateProtocol(group.getName(), NameIdPair.NOCHECK, null, this.channelFactory);
        for (ReplicationNode repNode : group.getElectableNodes()) {
            NodeStateProtocol nodeStateProtocol = stateProtocol;
            nodeStateProtocol.getClass();
            InetSocketAddress inetSocketAddress = repNode.getSocketAddress();
            NodeStateProtocol nodeStateProtocol2 = stateProtocol;
            nodeStateProtocol2.getClass();
            TextProtocol.MessageExchange me = nodeStateProtocol.new TextProtocol.MessageExchange(inetSocketAddress, "NodeState", nodeStateProtocol2.new NodeStateProtocol.NodeStateRequest(repNode.getName()));
            me.run();
            TextProtocol.ResponseMessage resp = me.getResponseMessage();
            if (!(resp instanceof NodeStateProtocol.NodeStateResponse)) continue;
            NodeStateProtocol.NodeStateResponse response = (NodeStateProtocol.NodeStateResponse)resp;
            this.notifyJoin(new JoinGroupEvent(response.getNodeName(), response.getMasterName(), response.getJoinTime()));
        }
    }

    public String getMasterNodeName() throws UnknownMasterException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        return this.repGroupAdmin.getMasterNodeName();
    }

    public ReplicationGroup getGroup() throws UnknownMasterException, DatabaseException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("The monitor has been shutdown");
        }
        return this.repGroupAdmin.getGroup();
    }

    public synchronized void shutdown() throws InterruptedException {
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.formatter, Level.INFO, "Shutting down monitor " + this.nameIdPair);
        if (this.pingThread != null) {
            this.pingThread.stopThread();
            this.pingThread = null;
        }
        if (this.learner != null) {
            this.learner.shutdown();
        }
        if (this.serviceDispatcher != null) {
            this.serviceDispatcher.shutdown();
        }
    }

    synchronized void notifyGroupChange(GroupChangeEvent event) {
        if (this.disableNotify) {
            return;
        }
        String name = event.getNodeName();
        switch (event.getChangeType()) {
            case REMOVE: {
                if (this.nodeStates.get(name) == null) {
                    return;
                }
                this.nodeStates.remove(name);
                break;
            }
            case ADD: {
                if (this.nodeStates.get(name) != null) {
                    return;
                }
                this.nodeStates.put(name, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized GroupChangeType: " + (Object)((Object)event.getChangeType()));
            }
        }
        this.monitorChangeListener.notify(event);
    }

    synchronized void notifyJoin(JoinGroupEvent event) {
        if (this.disableNotify) {
            return;
        }
        String name = event.getNodeName();
        if (this.nodeStates.get(name) != null && this.nodeStates.get(name).booleanValue()) {
            return;
        }
        this.nodeStates.put(name, true);
        this.joinEvents.put(name, event);
        this.monitorChangeListener.notify(event);
    }

    synchronized void notifyLeave(LeaveGroupEvent event) {
        if (this.nodeStates.get(event.getNodeName()) != null) {
            this.nodeStates.put(event.getNodeName(), false);
        }
        this.monitorChangeListener.notify(event);
    }

    private class PingThread
    extends Thread {
        private volatile boolean running = true;
        private ReplicationGroup group;
        private final int retries;
        private final long retryInterval;
        private final int socketConnectTimeout;
        private final Map<String, Integer> missedLeaveEvents = new HashMap<String, Integer>();

        public PingThread(ReplicationGroup group) {
            this.group = group;
            this.retries = Monitor.this.monitorConfig.getNumRetries();
            this.retryInterval = Monitor.this.monitorConfig.getRetryInterval();
            this.socketConnectTimeout = Monitor.this.monitorConfig.getSocketConnectTimeout();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    for (int i = 0; i < this.retries && this.running; ++i) {
                        this.queryNodes();
                        RepGroupImpl groupImpl = RepInternal.getRepGroupImpl(this.group);
                        Monitor.this.learner.queryForMaster(groupImpl.getAllLearnerSockets());
                        PingThread.sleep(this.retryInterval);
                    }
                    this.missedLeaveEvents.clear();
                }
            }
            catch (InterruptedException e) {
                LoggerUtils.logMsg(Monitor.this.logger, Monitor.this.formatter, Level.INFO, "The daemon PingThread is interrupted: " + e.getMessage());
            }
        }

        private void queryNodes() {
            ReplicationGroup repGroup = this.getValidGroup();
            for (ReplicationNode replicationNode : repGroup.getRepGroupImpl().getRemovedNodes()) {
                Monitor.this.notifyGroupChange(new GroupChangeEvent(repGroup, replicationNode.getName(), GroupChangeEvent.GroupChangeType.REMOVE));
            }
            for (ReplicationNode replicationNode : repGroup.getElectableNodes()) {
                this.pingElectableNodes(replicationNode, repGroup);
            }
        }

        private void pingElectableNodes(ReplicationNode repNode, ReplicationGroup repGroup) {
            String name = repNode.getName();
            try {
                DbPing ping = new DbPing(repNode, Monitor.this.getGroupName(), this.socketConnectTimeout, Monitor.this.channelFactory);
                NodeState state = ping.getNodeState();
                if (Monitor.this.nodeStates.get(name) == null) {
                    Monitor.this.notifyGroupChange(new GroupChangeEvent(repGroup, name, GroupChangeEvent.GroupChangeType.ADD));
                } else if (!((Boolean)Monitor.this.nodeStates.get(name)).booleanValue()) {
                    Monitor.this.notifyJoin(new JoinGroupEvent(name, state.getMasterName(), state.getJoinTime()));
                }
            }
            catch (IOException e) {
                this.notifyMissedLeaveEvents(name);
            }
            catch (ServiceDispatcher.ServiceConnectFailedException e) {
                this.notifyMissedLeaveEvents(name);
            }
        }

        private ReplicationGroup getValidGroup() {
            ReplicationGroup repGroup = null;
            try {
                this.group = repGroup = Monitor.this.getGroup();
            }
            catch (Exception e) {
                repGroup = this.group;
            }
            return repGroup;
        }

        private void notifyMissedLeaveEvents(String name) {
            if (Monitor.this.nodeStates.get(name) == null || !((Boolean)Monitor.this.nodeStates.get(name)).booleanValue()) {
                return;
            }
            int counter = this.missedLeaveEvents.get(name) == null ? 1 : this.missedLeaveEvents.get(name) + 1;
            this.missedLeaveEvents.put(name, counter);
            if (this.missedLeaveEvents.get(name) == this.retries) {
                JoinGroupEvent event = (JoinGroupEvent)Monitor.this.joinEvents.get(name);
                Monitor.this.notifyLeave(new LeaveGroupEvent(name, event.getMasterName(), LeaveGroupEvent.LeaveReason.ABNORMAL_TERMINATION, event.getJoinTime().getTime(), System.currentTimeMillis()));
            }
        }

        public void stopThread() {
            this.running = false;
        }
    }

    private class MasterChangeListener
    implements Learner.Listener {
        private MasterValue currentValue = null;

        private MasterChangeListener() {
        }

        @Override
        public void notify(Proposer.Proposal proposal, Protocol.Value value) {
            if (value.equals(this.currentValue)) {
                return;
            }
            this.currentValue = (MasterValue)value;
            try {
                String currentMasterName = this.currentValue.getNodeName();
                LoggerUtils.logMsg(Monitor.this.logger, Monitor.this.formatter, Level.INFO, "Monitor notified of new Master: " + currentMasterName);
                if (Monitor.this.monitorChangeListener == null) {
                    return;
                }
                Monitor.this.monitorChangeListener.notify(new NewMasterEvent(this.currentValue));
            }
            catch (Exception e) {
                LoggerUtils.logMsg(Monitor.this.logger, Monitor.this.formatter, Level.SEVERE, "Monitor change event processing exception: " + e.getMessage());
            }
        }
    }
}

