/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.LoggerUtils;
import java.net.InetSocketAddress;
import java.util.logging.Logger;

public class MasterChangeListener
implements Learner.Listener {
    private Protocol.Value currentValue = null;
    private final RepNode repNode;
    private final Logger logger;

    public MasterChangeListener(RepNode repNode) {
        this.repNode = repNode;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Proposer.Proposal proposal, Protocol.Value value) {
        try {
            this.repNode.getVLSNFreezeLatch().vlsnEvent(proposal);
            if (value.equals(this.currentValue)) {
                LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Master change listener -- no value change.Proposal: " + proposal + " Value: " + value);
                return;
            }
            MasterValue masterValue = (MasterValue)value;
            LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Master change listener notified. Proposal:" + proposal + " Value: " + value);
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Master changed to " + masterValue.getNameId().getName());
            this.repNode.getMasterStatus().setGroupMaster(new InetSocketAddress(masterValue.getHostName(), masterValue.getPort()), masterValue.getNameId());
            this.repNode.getElections().asyncInformMonitors(proposal, value);
        }
        finally {
            this.currentValue = value;
        }
    }
}

