/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;

public class ReadonlyTxn
extends Txn {
    public ReadonlyTxn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config, ReplicationContext.NO_REPLICATE);
    }

    @Override
    public LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws LockNotAvailableException, LockConflictException, DatabaseException {
        if (lockType.isWriteLock() && !database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        return super.lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
    }

    @Override
    public void preLogWithoutLock(DatabaseImpl database) {
        if (!database.allowReplicaWrite()) {
            this.disallowReplicaWrite();
        }
        super.preLogWithoutLock(database);
    }

    @Override
    public void disallowReplicaWrite() {
        throw new ReplicaWriteException(this, ((RepImpl)this.envImpl).getStateChangeEvent());
    }

    @Override
    protected void txnBeginHook(TransactionConfig config) throws ReplicaConsistencyException, DatabaseException {
        if (!this.envImpl.isReplicated()) {
            return;
        }
        ReadonlyTxn.checkConsistency((RepImpl)this.envImpl, config.getConsistencyPolicy());
    }

    static void checkConsistency(RepImpl repImpl, ReplicaConsistencyPolicy policy) {
        if (ReplicatedEnvironment.State.DETACHED.equals((Object)repImpl.getState()) || ReplicatedEnvironment.State.MASTER.equals((Object)repImpl.getState())) {
            return;
        }
        assert (policy != null) : "Missing default consistency policy";
        try {
            policy.ensureConsistency(repImpl);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException((EnvironmentImpl)repImpl, (Throwable)e);
        }
        catch (MasterStateException e) {
            return;
        }
    }

    @Override
    public boolean isReplicationDefined() {
        return true;
    }
}

