/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public class FreePortLocator {
    private final String hostname;
    private final int portStart;
    private final int portEnd;
    private int currPort;

    public FreePortLocator(String hostname, int portStart, int portEnd) {
        assert (portStart < portEnd);
        this.hostname = hostname;
        this.portStart = portStart;
        this.portEnd = portEnd;
        this.currPort = portStart;
    }

    public int next() {
        ServerSocket serverSocket = null;
        while (++this.currPort < this.portEnd) {
            try {
                serverSocket = new ServerSocket(this.currPort);
                serverSocket.close();
                serverSocket = new ServerSocket();
                InetSocketAddress sa = new InetSocketAddress(this.hostname, this.currPort);
                serverSocket.bind(sa);
                serverSocket.close();
                return this.currPort;
            }
            catch (IOException e) {
            }
        }
        throw new IllegalStateException("No more ports available in the range: " + this.portStart + " - " + this.portEnd);
    }

    public void skip(int num) {
        this.currPort += num;
    }
}

