/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.INLongRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TinyHashSet;
import com.sleepycat.je.utilint.VLSN;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    private TinyHashSet<CursorImpl> cursorSet;
    private long lastDeltaVersion = -1L;
    private boolean prohibitNextDelta;
    private INLongRep vlsnCache = INLongRep.EMPTY_REP;
    private INLongRep lastLoggedSizes = INLongRep.EMPTY_REP;
    public static boolean TEST_NO_LAST_LOGGED_SIZES = false;

    public BIN() {
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BIN(SizeofMarker marker) {
        super(marker);
    }

    private void setCachedVLSN(int idx, long vlsn) {
        if (this.databaseImpl.getSortedDuplicates() || !this.getEnv().getCacheVLSN()) {
            return;
        }
        this.setCachedVLSNUnconditional(idx, vlsn);
    }

    private void setCachedVLSNUnconditional(int idx, long vlsn) {
        this.vlsnCache = this.vlsnCache.set(idx, vlsn == VLSN.NULL_VLSN.getSequence() ? 0L : vlsn, this, this.getEnv().getCachedVLSNMinLength());
    }

    private long getCachedVLSN(int idx) {
        long vlsn = this.vlsnCache.get(idx);
        return vlsn == 0L ? VLSN.NULL_VLSN.getSequence() : vlsn;
    }

    public long getVLSN(int idx, boolean allowFetch, CacheMode cacheMode) {
        LN ln = (LN)this.getTarget(idx);
        if (ln != null) {
            return ln.getVLSNSequence();
        }
        long vlsn = this.getCachedVLSN(idx);
        if (!VLSN.isNull(vlsn)) {
            return vlsn;
        }
        if (!allowFetch) {
            return vlsn;
        }
        ln = (LN)this.fetchTarget(idx, cacheMode);
        return ln.getVLSNSequence();
    }

    public INLongRep getVLSNCache() {
        return this.vlsnCache;
    }

    @Override
    boolean isLastLoggedSizeStored() {
        if (DatabaseUtil.TEST && TEST_NO_LAST_LOGGED_SIZES && !this.databaseImpl.getDbType().isInternal()) {
            return false;
        }
        return !this.databaseImpl.isLNImmediatelyObsolete();
    }

    @Override
    public void setLastLoggedSize(int idx, int lastLoggedSize) {
        if (lastLoggedSize < 0 || !this.isLastLoggedSizeStored()) {
            return;
        }
        this.setLastLoggedSizeUnconditional(idx, lastLoggedSize);
    }

    @Override
    void setLastLoggedSizeUnconditional(int idx, int lastLoggedSize) {
        this.lastLoggedSizes = this.lastLoggedSizes.set(idx, lastLoggedSize, this, 1);
    }

    @Override
    public int getLastLoggedSize(int idx) {
        return (int)this.lastLoggedSizes.get(idx);
    }

    @Override
    void setTarget(int idx, Node target) {
        Node oldTarget;
        if (target == null && (oldTarget = this.getTarget(idx)) instanceof LN) {
            this.setCachedVLSN(idx, ((LN)oldTarget).getVLSNSequence());
        }
        super.setTarget(idx, target);
    }

    @Override
    void copyEntry(int idx, IN from, int fromIdx) {
        super.copyEntry(idx, from, fromIdx);
        this.setCachedVLSNUnconditional(idx, ((BIN)from).getCachedVLSN(fromIdx));
        this.setLastLoggedSizeUnconditional(idx, from.getLastLoggedSize(fromIdx));
    }

    @Override
    void copyEntries(int from, int to, int n) {
        super.copyEntries(from, to, n);
        this.vlsnCache = this.vlsnCache.copy(from, to, n);
        this.lastLoggedSizes = this.lastLoggedSizes.copy(from, to, n);
    }

    @Override
    void clearEntry(int idx) {
        super.clearEntry(idx);
        this.setCachedVLSNUnconditional(idx, VLSN.NULL_VLSN.getSequence());
        this.setLastLoggedSizeUnconditional(idx, 0);
    }

    @Override
    void resetContent(IN other) {
        BIN otherBin = (BIN)other;
        this.vlsnCache = otherBin.vlsnCache;
        this.lastLoggedSizes = otherBin.lastLoggedSizes;
        super.resetContent(other);
    }

    void resetContent(int capacity, int newNEntries, long[] lsns, byte[] states, byte[][] keys, Node[] targets, long[] vlsns, int[] loggedSizes) {
        for (int i = 0; i < newNEntries; ++i) {
            this.setCachedVLSNUnconditional(i, vlsns[i]);
            this.setLastLoggedSizeUnconditional(i, loggedSizes[i]);
        }
        this.resetContent(capacity, newNEntries, lsns, states, keys, targets);
    }

    @Override
    public long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.vlsnCache != null) {
            size += this.vlsnCache.getMemorySize();
        }
        if (this.lastLoggedSizes != null) {
            size += this.lastLoggedSizes.getMemorySize();
        }
        return size;
    }

    @Override
    protected long printMemorySize() {
        long inTotal = super.printMemorySize();
        long vlsnCacheOverhead = this.vlsnCache.getMemorySize();
        long logSizesOverhead = this.lastLoggedSizes.getMemorySize();
        long binTotal = inTotal + vlsnCacheOverhead + logSizesOverhead;
        System.out.format("BIN: %d vlsns: %d logSizes: %d %n", binTotal, vlsnCacheOverhead, logSizesOverhead);
        return binTotal;
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public boolean isBIN() {
        return true;
    }

    @Override
    public void setLastLoggedLsn(long lsn) {
        if (this.getLastFullVersion() == -1L) {
            this.setLastFullLsn(lsn);
        } else {
            this.lastDeltaVersion = lsn;
        }
    }

    @Override
    public long getLastLoggedVersion() {
        return this.lastDeltaVersion != -1L ? this.lastDeltaVersion : this.getLastFullVersion();
    }

    @Override
    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    @Override
    public void setProhibitNextDelta() {
        this.prohibitNextDelta = true;
    }

    @Override
    protected boolean isEvictionProhibited() {
        return this.nCursors() > 0;
    }

    @Override
    boolean hasPinnedChildren() {
        DatabaseImpl db = this.getDatabase();
        if (db.getId().equals(DbTree.ID_DB_ID)) {
            return this.hasResidentChildren();
        }
        return false;
    }

    @Override
    int getChildEvictionType() {
        boolean nodeIsEvictable = true;
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            if (!(node instanceof LN)) {
                nodeIsEvictable = false;
                continue;
            }
            LN ln = (LN)node;
            if (!ln.isEvictableInexact()) {
                nodeIsEvictable = false;
                continue;
            }
            return 1;
        }
        return nodeIsEvictable ? 2 : 0;
    }

    @Override
    boolean entryZeroKeyComparesLow() {
        return false;
    }

    @Override
    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        LN oldLN = (LN)this.getTarget(index);
        this.updateMemorySize(oldLN, null);
        if (oldLN != null) {
            oldLN.releaseMemoryBudget();
        }
        this.setTarget(index, null);
        this.setDirty(true);
    }

    public void setKnownDeletedClearAll(int index) {
        this.setKnownDeleted(index);
        this.setLsnElement(index, -1L);
    }

    @Override
    public void clearKnownDeleted(int index) {
        super.clearKnownDeleted(index);
        this.setDirty(true);
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.BIN_FIXED_OVERHEAD;
    }

    @Override
    public long getTreeAdminMemorySize() {
        if (this.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            long treeAdminMem = 0L;
            for (int i = 0; i < this.getMaxEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null) continue;
                MapLN mapLN = (MapLN)n;
                treeAdminMem += mapLN.getDatabase().getTreeAdminMemory();
            }
            return treeAdminMem;
        }
        return 0L;
    }

    public Set<CursorImpl> getCursorSet() {
        if (this.cursorSet == null) {
            return Collections.emptySet();
        }
        return this.cursorSet.copy();
    }

    public void addCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            this.cursorSet = new TinyHashSet();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        this.cursorSet.remove(cursor);
        if (this.cursorSet.size() == 0) {
            this.cursorSet = null;
        }
    }

    public int nCursors() {
        TinyHashSet<CursorImpl> cursors = this.cursorSet;
        if (cursors == null) {
            return 0;
        }
        return cursors.size();
    }

    @Override
    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    @Override
    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        assert (newSibling.isLatchExclusiveOwner());
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator<CursorImpl> iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = iter.next();
            if (cursor.getBINToBeRemoved() == this) continue;
            int cIdx = cursor.getIndex();
            BIN cBin = cursor.getBIN();
            assert (cBin == this) : "nodeId=" + this.getNodeId() + " cursor=" + cursor.dumpToString(true);
            assert (newSibling instanceof BIN);
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    iter.remove();
                    cursor.setBIN(ns);
                    ns.addCursor(cursor);
                    continue;
                }
                cursor.setIndex(cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            cursor.setIndex(cIdx - newSiblingLow);
            iter.remove();
            cursor.setBIN(ns);
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            if (cursor.getBINToBeRemoved() == this) continue;
            BIN cBin = cursor.getBIN();
            assert (cBin == this);
        }
    }

    @Override
    void adjustCursorsForInsert(int insertIndex) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            int cIdx;
            if (cursor.getBINToBeRemoved() == this || insertIndex > (cIdx = cursor.getIndex())) continue;
            cursor.setIndex(cIdx + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compress(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!this.databaseImpl.getDbEnvironment().isValid()) {
            return false;
        }
        if (this.nCursors() > 0) {
            throw EnvironmentFailureException.unexpectedState();
        }
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isEntryPendingDeleted(i) && !this.isEntryKnownDeleted(i)) continue;
            BasicLocker lockingTxn = BasicLocker.createBasicLocker(envImpl);
            lockingTxn.setPreemptable(false);
            try {
                LN ln;
                LockResult lockRet;
                long lsn = this.getLsn(i);
                if (lsn != -1L && (lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, db)).getLockGrant() == LockGrantType.DENIED) {
                    anyLocksDenied = true;
                    continue;
                }
                if (Key.compareKeys(this.getKey(i), this.getIdentifierKey(), this.getKeyComparator()) == 0) {
                    setNewIdKey = true;
                }
                if (db.isDeferredWriteMode() && (ln = (LN)this.getTarget(i)) != null && ln.isDirty() && !DbLsn.isTransient(lsn)) {
                    if (db.isTemporary()) {
                        if (localTracker != null) {
                            localTracker.countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db);
                        } else {
                            envImpl.getLogManager().countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db, true);
                        }
                    } else {
                        this.logDirtyLN(i, ln, false, true);
                    }
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                assert (deleteSuccess);
                --i;
                continue;
            }
            finally {
                lockingTxn.operationEnd();
            }
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.setGeneration(CacheMode.MAKE_COLD);
        }
        return !anyLocksDenied;
    }

    public void queueSlotDeletion() {
        if (this.shouldLogDelta()) {
            this.setDirty(true);
            return;
        }
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        envImpl.addToCompressorQueue(this, false);
    }

    @Override
    public boolean isCompressible() {
        return true;
    }

    @Override
    public long partialEviction() {
        return this.evictLNs();
    }

    public long evictLNs() throws DatabaseException {
        assert (this.isLatchExclusiveOwner()) : "BIN must be latched before evicting LNs";
        if (this.nCursors() > 0) {
            return 0x4000000000000000L;
        }
        long totalRemoved = 0L;
        boolean haveNonEvictableLN = false;
        for (int i = 0; i < this.getNEntries(); ++i) {
            long lnRemoved = this.evictInternal(i);
            if (lnRemoved < 0L) {
                haveNonEvictableLN = true;
                continue;
            }
            totalRemoved += lnRemoved;
        }
        if (totalRemoved > 0L) {
            this.updateMemorySize(totalRemoved, 0L);
            this.compactMemory();
        }
        if (haveNonEvictableLN) {
            return totalRemoved | 0x4000000000000000L;
        }
        return totalRemoved;
    }

    public void evictLN(int index) throws DatabaseException {
        long removed = this.evictInternal(index);
        if (removed > 0L) {
            this.updateMemorySize(removed, 0L);
            this.compactMemory();
        }
    }

    private long evictInternal(int index) throws DatabaseException {
        Node n = this.getTarget(index);
        assert (n == null || n instanceof LN);
        if (n == null) {
            return 0L;
        }
        LN ln = (LN)n;
        long lsn = this.getLsn(index);
        if (ln.isEvictable(lsn)) {
            this.logDirtyLN(index, ln, true, false);
            this.setTarget(index, null);
            ln.releaseMemoryBudget();
            return n.getMemorySizeIncludedByParent();
        }
        return -1L;
    }

    private void logDirtyLN(int index, LN ln, boolean ensureDurableLsn, boolean allowEviction) throws DatabaseException {
        boolean force;
        long oldLsn = this.getLsn(index);
        boolean bl = force = ensureDurableLsn && this.getDatabase().isDeferredWriteMode() && DbLsn.isTransientOrNull(oldLsn);
        if (force || ln.isDirty()) {
            DatabaseImpl dbImpl = this.getDatabase();
            EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
            assert (dbImpl.isDeferredWriteMode());
            LN.LogResult logResult = ln.log(envImpl, dbImpl, this.getKey(index), oldLsn, this.getLastLoggedSize(index), null, null, true, ReplicationContext.NO_REPLICATE);
            this.updateEntry(index, logResult.newLsn, logResult.newSize);
            CursorImpl.lockAfterLsnChange(dbImpl, oldLsn, logResult.newLsn, null);
            if (allowEviction && this.databaseImpl.getSortedDuplicates()) {
                this.evictLN(index);
            }
        }
    }

    @Override
    boolean validateSubtreeBeforeDelete(int index) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidForDelete() throws DatabaseException {
        int numValidEntries = 0;
        boolean needToLatch = !this.isLatchExclusiveOwner();
        try {
            boolean bl;
            if (needToLatch) {
                this.latch();
            }
            for (int i = 0; i < this.getNEntries(); ++i) {
                if (this.isEntryKnownDeleted(i)) continue;
                ++numValidEntries;
            }
            if (numValidEntries > 0) {
                bl = false;
                return bl;
            }
            if (this.nCursors() > 0) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (needToLatch && this.isLatchExclusiveOwner()) {
                this.releaseLatch();
            }
        }
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public void logDirtyChildren() throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            this.logDirtyLN(i, (LN)node, true, true);
        }
    }

    @Override
    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incBINFetchStats(isMiss, this.isBINDelta());
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    @Override
    public String shortClassName() {
        return "BIN";
    }

    @Override
    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) {
        DatabaseImpl dbImpl = this.getDatabase();
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        boolean bl = item.isDelta = this.isBINDelta() || context.allowDeltas && this.shouldLogDelta();
        assert (!item.isDelta || !this.isDeltaProhibited());
        if (context.allowCompress && !item.isDelta) {
            envImpl.lazyCompress(this);
        }
        if (dbImpl.isDeferredWriteMode()) {
            this.logDirtyLNs();
        }
        this.beforeLogCommon(item, context, item.isDelta ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        item.entry = item.isDelta ? new BINDeltaLogEntry(this) : new INLogEntry<BIN>(this);
    }

    @Override
    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) {
        this.afterLogCommon(logManager, item, context, item.isDelta ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        if (item.isDelta) {
            this.lastDeltaVersion = item.newLsn;
        } else {
            this.setLastFullLsn(item.newLsn);
            this.lastDeltaVersion = -1L;
            for (int i = 0; i < this.getNEntries(); ++i) {
                if (!this.isEntryKnownDeleted(i) && !this.isEntryPendingDeleted(i)) continue;
                this.queueSlotDeletion();
                break;
            }
        }
        this.prohibitNextDelta = false;
    }

    private void logDirtyLNs() throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || !(node instanceof LN)) continue;
            this.logDirtyLN(i, (LN)node, true, true);
        }
    }

    private boolean isDeltaProhibited() {
        DatabaseImpl dbImpl = this.getDatabase();
        return this.prohibitNextDelta || dbImpl.isDeferredWriteMode() || this.getLastFullVersion() == -1L;
    }

    public boolean shouldLogDelta() {
        if (this.isDeltaProhibited()) {
            return false;
        }
        int numDeltas = this.getNDeltas();
        if (numDeltas <= 0) {
            return false;
        }
        int deltaLimit = this.getNEntries() * this.databaseImpl.getBinDeltaPercent() / 100;
        return numDeltas <= deltaLimit;
    }

    @Override
    public Node fetchTarget(int idx, CacheMode cacheMode) {
        return this.fetchTargetWithExLatch(idx, cacheMode);
    }

    public Node fetchTargetKnownActive(int idx, CacheMode cacheMode) {
        try {
            return this.fetchTargetInternal(idx, cacheMode, false, true);
        }
        catch (RelatchRequiredException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public void releaseLatchIfOwner() {
        this.latch.releaseIfOwner();
    }

    public boolean canMutateToBINDelta() {
        return !this.isBINDelta() && this.shouldLogDelta() && this.nCursors() == 0;
    }

    public long mutateToBINDelta() {
        assert (this.isLatchExclusiveOwner());
        assert (this.canMutateToBINDelta());
        if (this.getInListResident()) {
            this.databaseImpl.getEnvironmentImpl().getInMemoryINs().updateBINDeltaStat(1);
        }
        long oldSize = this.getInMemorySize();
        int nDeltas = this.getNDeltas();
        this.initBINDelta(this, nDeltas, nDeltas);
        return oldSize - this.getInMemorySize();
    }

    private void initBINDelta(BIN destBIN, int nDeltas, int capacity) {
        long[] lsns = new long[nDeltas];
        long[] vlsns = new long[nDeltas];
        int[] sizes = new int[nDeltas];
        byte[][] keys = new byte[nDeltas][];
        byte[] states = new byte[nDeltas];
        Node[] targets = new Node[nDeltas];
        int j = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isDirty(i)) continue;
            lsns[j] = this.getLsn(i);
            vlsns[j] = this.getCachedVLSN(i);
            sizes[j] = this.getLastLoggedSize(i);
            keys[j] = this.getKey(i);
            states[j] = this.getState(i);
            targets[j] = this.getTarget(i);
            ++j;
        }
        destBIN.resetContent(capacity, nDeltas, lsns, states, keys, targets, vlsns, sizes);
        destBIN.setBINDelta(true);
        destBIN.compactMemory();
    }

    public BIN createBINDelta() {
        BIN bin = new BIN(this.databaseImpl, this.getIdentifierKey(), 0, this.getLevel());
        int nDeltas = this.getNDeltas();
        this.initBINDelta(bin, nDeltas, nDeltas);
        return bin;
    }

    void mutateToFullBIN() {
        BIN fullBIN = this.fetchFullBIN(this.databaseImpl);
        this.databaseImpl.getEnvironmentImpl().getEvictor().incFullBINFetchMissStats();
        this.mutateToFullBIN(fullBIN);
    }

    public void mutateToFullBIN(BIN fullBIN) {
        assert (this.isLatchExclusiveOwner());
        assert (this.isBINDelta()) : this;
        this.reconstituteBIN(this.databaseImpl, fullBIN);
        this.resetContent(fullBIN);
        this.setBINDelta(false);
        this.compactMemory();
        if (this.getInListResident()) {
            this.databaseImpl.getEnvironmentImpl().getInMemoryINs().updateBINDeltaStat(-1);
        }
    }

    public BIN reconstituteBIN(DatabaseImpl dbImpl) {
        BIN fullBIN = this.fetchFullBIN(dbImpl);
        this.reconstituteBIN(dbImpl, fullBIN);
        return fullBIN;
    }

    private BIN fetchFullBIN(DatabaseImpl dbImpl) {
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        long lsn = this.getLastFullVersion();
        try {
            return (BIN)envImpl.getLogManager().getEntryHandleFileNotFound(lsn);
        }
        catch (EnvironmentFailureException e) {
            e.addErrorMessage(BIN.makeFetchErrorMsg(null, this, lsn, (byte)0));
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, BIN.makeFetchErrorMsg(e.toString(), this, lsn, (byte)0), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteBIN(DatabaseImpl dbImpl, BIN fullBIN) {
        fullBIN.setDatabase(dbImpl);
        fullBIN.latch(CacheMode.UNCHANGED);
        try {
            fullBIN.setLastFullLsn(this.getLastFullVersion());
            for (int i = 0; i < this.getNEntries(); ++i) {
                assert (this.isDirty(i)) : this;
                fullBIN.applyDelta(this.getKey(i), this.getLsn(i), this.getState(i), this.getLastLoggedSize(i), this.getCachedVLSN(i));
            }
            fullBIN.setDirty(false);
        }
        finally {
            fullBIN.releaseLatch();
        }
    }

    void applyDelta(byte[] key, long lsn, byte state, int lastLoggedSize, long vlsn) {
        int foundIndex = this.findEntry(key, true, false);
        if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
            this.updateEntry(foundIndex &= 0xFFFEFFFF, lsn, lastLoggedSize, state);
        } else {
            ChildReference entry = new ChildReference(null, key, lsn, state);
            int result = this.insertEntry1(entry);
            assert ((result & 0x20000) != 0);
            foundIndex = result & 0xFFFCFFFF;
            this.setLastLoggedSizeUnconditional(foundIndex, lastLoggedSize);
        }
        this.setCachedVLSNUnconditional(foundIndex, vlsn);
    }
}

