/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongStat
extends Stat<Long>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private AtomicLong counter = new AtomicLong(0L);

    public AtomicLongStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    @Override
    public Long get() {
        return this.counter.get();
    }

    @Override
    public void set(Long newValue) {
        this.counter.set(newValue);
    }

    public void increment() {
        this.counter.incrementAndGet();
    }

    public void decrement() {
        this.counter.decrementAndGet();
    }

    public void add(long count) {
        this.counter.addAndGet(count);
    }

    @Override
    public void add(Stat<Long> other) {
        this.counter.addAndGet(other.get());
    }

    @Override
    public void clear() {
        this.counter.set(0L);
    }

    @Override
    public Stat<Long> computeInterval(Stat<Long> base) {
        AtomicLongStat ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(this.counter.get() - base.get());
        }
        return ret;
    }

    @Override
    public void negate() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            this.counter.set(-this.counter.get());
        }
    }

    public AtomicLongStat copy() {
        try {
            AtomicLongStat ret = (AtomicLongStat)super.clone();
            ret.counter = new AtomicLong(this.counter.get());
            return ret;
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
    }

    @Override
    protected String getFormattedValue() {
        return Stat.FORMAT.format(this.counter.get());
    }

    @Override
    public boolean isNotSet() {
        return this.counter.get() == 0L;
    }
}

