/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class StoppableThreadFactory
implements ThreadFactory {
    private final String threadName;
    private final Logger logger;
    private final EnvironmentImpl envImpl;

    public StoppableThreadFactory(EnvironmentImpl envImpl, String threadName, Logger logger) {
        this.threadName = threadName;
        this.logger = logger;
        this.envImpl = envImpl;
    }

    public StoppableThreadFactory(String threadName, Logger logger) {
        this(null, threadName, logger);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new StoppablePoolThread(this.envImpl, runnable, this.threadName, this.logger);
    }

    private static class StoppablePoolThread
    extends StoppableThread {
        private final Logger logger;

        StoppablePoolThread(EnvironmentImpl envImpl, Runnable runnable, String threadName, Logger logger) {
            super(envImpl, null, runnable, threadName);
            this.logger = logger;
        }

        @Override
        protected Logger getLogger() {
            return this.logger;
        }
    }
}

