/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.ModelInternal;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistCatalog
implements Catalog {
    private static final int MAX_TXN_RETRIES = 10;
    private static final byte[] DATA_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] BETA_MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    public static boolean expectNoClassChanges;
    public static boolean unevolvedFormatsEncountered;
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private volatile Map<String, Format> latestFormatMap;
    private Map<String, String> proxyClassMap;
    private final Environment env;
    private final boolean rawAccess;
    private EntityModel model;
    private StoredModel storedModel;
    private Mutations mutations;
    private final Database db;
    private int openCount;
    private boolean readOnly;
    private final boolean transactional;
    private volatile int nStoredFormats;
    private final Store store;
    private Evolver initEvolver;
    private Data initData;

    private static byte[] getIntBytes(int val) {
        DatabaseEntry entry = new DatabaseEntry();
        IntegerBinding.intToEntry(val, entry);
        assert (entry.getSize() == 4 && entry.getData().length == 4);
        return entry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistCatalog(Environment env, String storePrefix, String dbName, DatabaseConfig dbConfig, EntityModel modelParam, Mutations mutationsParam, boolean rawAccess, Store store) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        this.env = env;
        this.rawAccess = rawAccess;
        this.store = store;
        this.transactional = dbConfig.getTransactional();
        String[] fileAndDbNames = store != null ? store.parseDbName(dbName) : Store.parseDbName(dbName, DatabaseNamer.DEFAULT);
        this.db = DbCompat.openDatabase(env, null, fileAndDbNames[0], fileAndDbNames[1], dbConfig);
        if (this.db == null) {
            String dbNameMsg = store.getDbNameMessage(fileAndDbNames);
            if (dbConfig.getExclusiveCreate()) {
                throw new StoreExistsException("Catalog DB already exists and ExclusiveCreate=true, " + dbNameMsg);
            }
            assert (!dbConfig.getAllowCreate());
            throw new StoreNotFoundException("Catalog DB does not exist and AllowCreate=false, " + dbNameMsg);
        }
        this.openCount = 1;
        boolean success = false;
        try {
            this.initAndRetry(storePrefix, modelParam, mutationsParam);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    PersistCatalog(PersistCatalog oldCatalog, String storePrefix) throws DatabaseException {
        this.db = oldCatalog.db;
        this.store = oldCatalog.store;
        this.env = oldCatalog.env;
        this.rawAccess = oldCatalog.rawAccess;
        this.openCount = oldCatalog.openCount;
        this.transactional = oldCatalog.transactional;
        this.initAndRetry(storePrefix, oldCatalog.model, oldCatalog.mutations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndRetry(String storePrefix, EntityModel modelParam, Mutations mutationsParam) throws DatabaseException {
        int i = 0;
        while (true) {
            Transaction txn = null;
            if (this.transactional && DbCompat.getThreadTransaction(this.env) == null) {
                txn = this.env.beginTransaction(null, this.store.getAutoCommitTxnConfig());
            }
            boolean success = false;
            try {
                this.init(txn, storePrefix, modelParam, mutationsParam);
                success = true;
                return;
            }
            catch (LockConflictException e) {
                if (i >= 10) {
                    throw e;
                }
            }
            finally {
                if (txn != null) {
                    if (success && !this.isReadOnly()) {
                        txn.commit();
                    } else {
                        txn.abort();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Transaction txn, String storePrefix, EntityModel modelParam, Mutations mutationsParam) throws DatabaseException {
        try {
            boolean betaVersion;
            this.initData = this.readData(txn);
            this.mutations = this.initData.mutations;
            if (this.mutations == null) {
                this.mutations = new Mutations();
            }
            boolean needWrite = betaVersion = this.initData.version == -1;
            boolean disallowClassChanges = betaVersion;
            boolean forceEvolution = false;
            if (mutationsParam != null && !this.mutations.equals(mutationsParam)) {
                this.mutations = mutationsParam;
                needWrite = true;
                forceEvolution = true;
            }
            ClassLoader envClassLoader = DbCompat.getClassLoader(this.env);
            this.formatList = this.initData.formatList;
            if (this.formatList == null) {
                this.formatList = SimpleCatalog.getAllSimpleFormats(envClassLoader);
                NonPersistentFormat format = new NonPersistentFormat((Catalog)this, Object.class);
                format.setId(1);
                this.formatList.set(1, format);
                format = new NonPersistentFormat((Catalog)this, Number.class);
                format.setId(22);
                this.formatList.set(22, format);
            } else {
                if (SimpleCatalog.addMissingSimpleFormats(envClassLoader, this.formatList)) {
                    needWrite = true;
                }
                this.nStoredFormats = this.formatList.size();
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initCatalog(this);
            }
            if (betaVersion) {
                HashMap<String, Format> formatMap = new HashMap<String, Format>();
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    formatMap.put(format.getClassName(), format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.migrateFromBeta(formatMap);
                }
            }
            this.formatMap = new HashMap<String, Format>(this.formatList.size());
            this.latestFormatMap = new HashMap<String, Format>(this.formatList.size());
            if (this.rawAccess) {
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    String name = format.getClassName();
                    if (format.isCurrentVersion()) {
                        this.formatMap.put(name, format);
                    }
                    if (format != format.getLatestVersion()) continue;
                    this.latestFormatMap.put(name, format);
                }
                if (modelParam != null) {
                    this.model = modelParam;
                    this.storedModel = (StoredModel)modelParam;
                } else {
                    this.storedModel = new StoredModel(this);
                    this.model = this.storedModel;
                }
                ModelInternal.setClassLoader(this.model, envClassLoader);
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.initializeIfNeeded(this, this.model);
                }
                this.initModelAndMutations();
                return;
            }
            this.model = modelParam != null ? modelParam : new AnnotationModel();
            ModelInternal.setClassLoader(this.model, envClassLoader);
            this.storedModel = null;
            for (int i = 0; i <= 30; ++i) {
                Format simpleFormat = this.formatList.get(i);
                if (simpleFormat == null) continue;
                this.formatMap.put(simpleFormat.getClassName(), simpleFormat);
            }
            ArrayList<String> knownClasses = new ArrayList<String>(this.model.getKnownClasses());
            knownClasses.addAll(this.model.getKnownSpecialClasses());
            this.addPredefinedProxies(knownClasses);
            this.proxyClassMap = new HashMap<String, String>();
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                String oldName = oldFormat.getClassName();
                Renamer renamer = this.mutations.getRenamer(oldName, oldFormat.getVersion(), null);
                String newName = renamer != null ? renamer.getNewName() : oldName;
                this.addProxiedClass(newName, false);
            }
            for (String className : knownClasses) {
                this.addProxiedClass(className, true);
            }
            HashMap<String, Format> newFormats = new HashMap<String, Format>();
            for (String className : knownClasses) {
                this.createFormat(className, newFormats);
            }
            this.initEvolver = new Evolver(this, storePrefix, this.mutations, newFormats, forceEvolution, disallowClassChanges);
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                if (oldFormat.isEntity()) {
                    this.initEvolver.evolveFormat(oldFormat);
                    continue;
                }
                this.initEvolver.addNonEntityFormat(oldFormat);
            }
            this.initEvolver.finishEvolution();
            String errors = this.initEvolver.getErrors();
            if (errors != null) {
                throw new IncompatibleClassException(errors);
            }
            for (Format newFormat : newFormats.values()) {
                this.addFormat(newFormat);
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initializeIfNeeded(this, this.model);
                if (format != format.getLatestVersion()) continue;
                this.latestFormatMap.put(format.getClassName(), format);
            }
            boolean formatsChanged = newFormats.size() > 0 || this.initEvolver.areFormatsChanged();
            needWrite |= formatsChanged;
            if (expectNoClassChanges && formatsChanged) {
                throw new IllegalStateException("Unexpected changes  newFormats.size=" + newFormats.size() + " areFormatsChanged=" + this.initEvolver.areFormatsChanged());
            }
            this.readOnly = this.db.getConfig().getReadOnly();
            if (needWrite && !this.readOnly) {
                try {
                    this.initEvolver.renameAndRemoveDatabases(this.store, txn);
                    this.initData.formatList = this.formatList;
                    this.initData.mutations = this.mutations;
                    this.writeData(txn, this.initData);
                }
                catch (ReplicaWriteException e) {
                    this.readOnly = true;
                }
            }
            this.initModelAndMutations();
        }
        finally {
            this.proxyClassMap = null;
            this.initData = null;
            this.initEvolver = null;
        }
    }

    private void initModelAndMutations() {
        ModelInternal.setCatalog(this.model, this);
        for (Converter converter : this.mutations.getConverters()) {
            converter.getConversion().initialize(this.model);
        }
    }

    public void getEntityFormats(Collection<Format> entityFormats) {
        for (Format format : this.formatMap.values()) {
            if (!format.isEntity()) continue;
            entityFormats.add(format);
        }
    }

    private void addProxiedClass(String className, boolean isKnownClass) {
        String proxiedClassName;
        ClassMetadata metadata = this.model.getClassMetadata(className);
        if (metadata != null && (proxiedClassName = metadata.getProxiedClassName()) != null) {
            if (isKnownClass) {
                try {
                    Class type = this.resolveClass(proxiedClassName);
                    if (!SimpleCatalog.allowRegisterProxy(type)) {
                        throw new IllegalArgumentException("Registering proxy is not allowed for " + proxiedClassName + ", which is a built-in simple type.");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw DbCompat.unexpectedState("Class does not exist: " + proxiedClassName);
                }
            }
            this.proxyClassMap.put(proxiedClassName, className);
        }
    }

    private void addPredefinedProxies(List<String> knownClasses) {
        knownClasses.add(CollectionProxy.ArrayListProxy.class.getName());
        knownClasses.add(CollectionProxy.LinkedListProxy.class.getName());
        knownClasses.add(CollectionProxy.HashSetProxy.class.getName());
        knownClasses.add(CollectionProxy.TreeSetProxy.class.getName());
        knownClasses.add(MapProxy.HashMapProxy.class.getName());
        knownClasses.add(MapProxy.TreeMapProxy.class.getName());
        knownClasses.add(MapProxy.LinkedHashMapProxy.class.getName());
    }

    Map<Format, Set<Format>> getSubclassMap() {
        HashMap<Format, Set<Format>> subclassMap = new HashMap<Format, Set<Format>>();
        for (Format format : this.formatList) {
            Format superFormat;
            if (format == null || Format.isPredefined(format) || (superFormat = format.getSuperFormat()) == null) continue;
            HashSet<Format> subclass = (HashSet<Format>)subclassMap.get(superFormat);
            if (subclass == null) {
                subclass = new HashSet<Format>();
                subclassMap.put(superFormat, subclass);
            }
            subclass.add(format);
        }
        return subclassMap;
    }

    public EntityModel getResolvedModel() {
        return this.model;
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw DbCompat.unexpectedState("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            this.db.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        Class type;
        try {
            type = this.resolveClass(clsName);
        }
        catch (ClassNotFoundException e) {
            throw DbCompat.unexpectedState("Class does not exist: " + clsName);
        }
        return this.createFormat(type, newFormats);
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        String className = type.getName();
        Format format = this.getFormatFromMap(type, newFormats);
        if (format != null) {
            return format;
        }
        format = this.getFormatFromMap(type, this.formatMap);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(type)) : className;
        ClassMetadata metadata = this.model.getClassMetadata(className);
        String proxyClassName = null;
        if (this.proxyClassMap != null) {
            proxyClassName = this.proxyClassMap.get(className);
        }
        if (proxyClassName != null) {
            format = new ProxiedFormat(this, type, proxyClassName);
        } else if (type.isArray()) {
            format = type.getComponentType().isPrimitive() ? new PrimitiveArrayFormat((Catalog)this, type) : new ObjectArrayFormat((Catalog)this, type);
        } else if (type.isEnum()) {
            format = new EnumFormat((Catalog)this, type);
        } else if (type.getEnclosingClass() != null && type.getEnclosingClass().isEnum()) {
            format = new EnumFormat((Catalog)this, type.getEnclosingClass());
        } else if (type == Object.class || type.isInterface()) {
            format = new NonPersistentFormat((Catalog)this, type);
        } else {
            if (metadata == null) {
                throw new IllegalArgumentException("Class could not be loaded or is not persistent: " + className);
            }
            if (metadata.getCompositeKeyFields() != null && (metadata.getPrimaryKey() != null || metadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + type.getName());
            }
            if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
                throw new IllegalArgumentException("Inner classes not allowed: " + type.getName());
            }
            try {
                type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor: " + type.getName(), e);
            }
            if (metadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat((Catalog)this, type, metadata, metadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(className);
                format = new ComplexFormat(this, type, metadata, entityMetadata);
            }
        }
        newFormats.put(className, format);
        format.collectRelatedFormats(this, newFormats);
        return format;
    }

    private Format getFormatFromMap(Class type, Map<String, Format> formats) {
        Format format = formats.get(type.getName());
        if (format != null) {
            return format;
        }
        if (type.getEnclosingClass() != null && type.getEnclosingClass().isEnum() && (format = formats.get(type.getEnclosingClass().getName())) != null) {
            return format;
        }
        return null;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    void useExistingFormat(Format oldFormat) {
        assert (oldFormat.isCurrentVersion());
        this.formatMap.put(oldFormat.getClassName(), oldFormat);
    }

    Set<String> getModelClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            classes.add(format.getClassName());
        }
        return Collections.unmodifiableSet(classes);
    }

    public List<RawType> getAllRawTypes() {
        ArrayList<RawType> list = new ArrayList<RawType>();
        for (RawType rawType : this.formatList) {
            if (rawType == null) continue;
            list.add(rawType);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        if (this.initData == null || this.initData.formatList == null || format.getId() >= this.initData.formatList.size()) {
            return 1;
        }
        assert (this.initData != null);
        if (forReader) {
            return this.initEvolver != null && this.initEvolver.isFormatChanged(format) ? 1 : this.initData.version;
        }
        return this.initData.version;
    }

    @Override
    public Format getFormat(int formatId, boolean expectStored) throws RefreshException {
        if (formatId < 0) {
            throw DbCompat.unexpectedState("Format ID " + formatId + " is negative," + " may indicate data corruption.");
        }
        if (expectStored && formatId >= this.nStoredFormats) {
            assert (this.store != null);
            throw new RefreshException(this.store, this, formatId);
        }
        Format format = this.formatList.get(formatId);
        if (format == null) {
            throw DbCompat.unexpectedState("Format ID " + formatId + " has null format," + " may indicate data corruption.");
        }
        return format;
    }

    @Override
    public Format getFormat(Class cls, boolean checkEntitySubclassIndexes) throws RefreshException {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            if (this.model != null) {
                ComplexFormat entityFormat;
                format = this.addNewFormat(cls);
                if (checkEntitySubclassIndexes && this.store != null && (entityFormat = format.getEntityFormat()) != null && entityFormat != format) {
                    try {
                        this.store.checkEntitySubclassSecondaries(((Format)entityFormat).getEntityMetadata(), cls.getName());
                    }
                    catch (DatabaseException e) {
                        throw RuntimeExceptionWrapper.wrapIfNeeded(e);
                    }
                }
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    public Format getLatestVersion(String className) {
        return this.latestFormatMap.get(className);
    }

    public String getDatabaseClassName(String className) {
        Format format = this.getStoredFormat(className);
        if (format == null) {
            return null;
        }
        return format.getClassName();
    }

    public String getDatabaseKeyName(String className, String keyName) {
        Format format = this.getStoredFormat(className);
        if (format == null) {
            return null;
        }
        return format.getOldKeyName(keyName);
    }

    private Format getStoredFormat(String className) {
        Format format;
        for (format = this.getFormat(className); format != null && format.getId() >= this.nStoredFormats; format = format.getPreviousVersion()) {
        }
        return format;
    }

    void checkWriteInReplicaUpgradeMode() throws RefreshException {
        if (this.nStoredFormats < this.formatList.size()) {
            throw new RefreshException(this.store, this, -1);
        }
    }

    boolean isReplicaUpgradeMode() {
        return this.nStoredFormats < this.formatList.size();
    }

    private synchronized Format addNewFormat(Class cls) throws RefreshException {
        Format format = this.getFormatFromMap(cls, this.formatMap);
        if (format != null) {
            return format;
        }
        ArrayList<Format> newFormatList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> newFormatMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> newLatestFormatMap = new HashMap<String, Format>(this.latestFormatMap);
        HashMap<String, Format> newFormats = new HashMap<String, Format>();
        format = this.createFormat(cls, newFormats);
        for (Format newFormat : newFormats.values()) {
            this.addFormat(newFormat, newFormatList, newFormatMap);
        }
        ReadOnlyCatalog newFormatCatalog = new ReadOnlyCatalog(ModelInternal.getClassLoader(this.model), newFormatList, newFormatMap);
        for (Format newFormat : newFormats.values()) {
            newFormat.initializeIfNeeded(newFormatCatalog, this.model);
            newLatestFormatMap.put(newFormat.getClassName(), newFormat);
        }
        if (!this.readOnly) {
            try {
                Data newData = new Data();
                newData.formatList = newFormatList;
                newData.mutations = this.mutations;
                this.writeDataCheckStale(newData);
            }
            catch (ReplicaWriteException e) {
                this.readOnly = true;
            }
            catch (DatabaseException e) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(e);
            }
        }
        this.formatList = newFormatList;
        this.formatMap = newFormatMap;
        this.latestFormatMap = newLatestFormatMap;
        return format;
    }

    public synchronized void flush(Transaction txn) throws DatabaseException {
        Data newData = new Data();
        newData.formatList = this.formatList;
        newData.mutations = this.mutations;
        this.writeData(txn, newData);
    }

    int getNFormats() {
        return this.nStoredFormats;
    }

    private Data readData(Transaction txn) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.db.get(txn, key, data, null);
        if (status == OperationStatus.SUCCESS) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize());
            try {
                Data oldData;
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object object = ois.readObject();
                assert (ois.available() == 0);
                if (object instanceof Data) {
                    oldData = (Data)object;
                } else {
                    if (!(object instanceof List)) {
                        throw DbCompat.unexpectedState(object.getClass().getName());
                    }
                    oldData = new Data();
                    oldData.formatList = (List)object;
                    oldData.version = -1;
                }
                return oldData;
            }
            catch (ClassNotFoundException e) {
                throw DbCompat.unexpectedException(e);
            }
            catch (IOException e) {
                throw DbCompat.unexpectedException(e);
            }
        }
        Data oldData = new Data();
        oldData.version = 1;
        return oldData;
    }

    boolean isMetadataStale(Transaction txn) throws DatabaseException {
        Data oldData = this.readData(txn);
        return oldData.formatList != null && oldData.formatList.size() > this.nStoredFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataCheckStale(Data newData) throws DatabaseException, RefreshException {
        int i = 0;
        while (true) {
            Transaction txn = null;
            if (this.transactional && DbCompat.getThreadTransaction(this.env) == null) {
                txn = this.env.beginTransaction(null, this.store.getAutoCommitTxnConfig());
            }
            boolean success = false;
            try {
                if (this.isMetadataStale(txn)) {
                    throw new RefreshException(this.store, this, -1);
                }
                this.writeData(txn, newData);
                success = true;
                return;
            }
            catch (LockConflictException e) {
                if (i >= 10) {
                    throw e;
                }
            }
            finally {
                if (txn != null) {
                    if (success && !this.isReadOnly()) {
                        txn.commit();
                    } else {
                        txn.abort();
                    }
                }
            }
            ++i;
        }
    }

    private void writeData(Transaction txn, Data newData) throws DatabaseException {
        boolean wasBetaVersion = newData.version == -1;
        newData.version = 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(newData);
        }
        catch (IOException e) {
            throw DbCompat.unexpectedException(e);
        }
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry(baos.toByteArray());
        this.db.put(txn, key, data);
        if (wasBetaVersion) {
            key.setData(BETA_MUTATIONS_KEY);
            this.db.delete(txn, key);
        }
        this.nStoredFormats = newData.formatList.size();
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) throws RefreshException {
        Format format = (Format)o.getType();
        if (this == format.getCatalog()) {
            format = this.getFormat(format.getId(), false);
        } else {
            String clsName = format.getClassName();
            try {
                Class cls = this.resolveClass(clsName);
                format = this.getFormat(cls, true);
            }
            catch (ClassNotFoundException e) {
                format = null;
            }
            if (format == null) {
                throw new IllegalArgumentException("External raw type not found: " + clsName);
            }
        }
        Format proxiedFormat = format.getProxiedFormat();
        if (proxiedFormat != null) {
            format = proxiedFormat;
        }
        if (converted == null) {
            converted = new IdentityHashMap();
        }
        return format.convertRawObject(this, false, o, converted);
    }

    @Override
    public Class resolveClass(String clsName) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(clsName, ModelInternal.getClassLoader(this.model));
    }

    @Override
    public Class resolveKeyClass(String clsName) {
        return SimpleCatalog.resolveKeyClass(clsName, ModelInternal.getClassLoader(this.model));
    }

    private static class Data
    implements Serializable {
        static final long serialVersionUID = 7515058069137413261L;
        List<Format> formatList;
        Mutations mutations;
        int version;

        private Data() {
        }
    }
}

