/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.PreloadStatus;
import java.io.Serializable;

public class PreloadStats
implements Serializable {
    private static final long serialVersionUID = 2131949076L;
    private int nINsLoaded;
    private int nBINsLoaded;
    private int nLNsLoaded;
    private int nDINsLoaded;
    private int nDBINsLoaded;
    private int nDupCountLNsLoaded;
    private int nCountMemoryExceeded;
    private PreloadStatus status;

    PreloadStats(int nINsLoaded, int nBINsLoaded, int nLNsLoaded, int nDINsLoaded, int nDBINsLoaded, int nDupCountLNsLoaded, int nCountMemoryExceeded, PreloadStatus status) {
        this.nINsLoaded = nINsLoaded;
        this.nBINsLoaded = nBINsLoaded;
        this.nLNsLoaded = nLNsLoaded;
        this.nDINsLoaded = nDINsLoaded;
        this.nDBINsLoaded = nDBINsLoaded;
        this.nDupCountLNsLoaded = nDupCountLNsLoaded;
        this.nCountMemoryExceeded = nCountMemoryExceeded;
        this.status = status;
    }

    public PreloadStats() {
        this.reset();
    }

    private void reset() {
        this.nINsLoaded = 0;
        this.nBINsLoaded = 0;
        this.nLNsLoaded = 0;
        this.nDINsLoaded = 0;
        this.nDBINsLoaded = 0;
        this.nDupCountLNsLoaded = 0;
        this.nCountMemoryExceeded = 0;
        this.status = PreloadStatus.SUCCESS;
    }

    public int getNINsLoaded() {
        return this.nINsLoaded;
    }

    public int getNBINsLoaded() {
        return this.nBINsLoaded;
    }

    public int getNLNsLoaded() {
        return this.nLNsLoaded;
    }

    public int getNDINsLoaded() {
        return this.nDINsLoaded;
    }

    public int getNDBINsLoaded() {
        return this.nDBINsLoaded;
    }

    public int getNDupCountLNsLoaded() {
        return this.nDupCountLNsLoaded;
    }

    public int getNCountMemoryExceeded() {
        return this.nCountMemoryExceeded;
    }

    public PreloadStatus getStatus() {
        return this.status;
    }

    public void incINsLoaded() {
        ++this.nINsLoaded;
    }

    public void incBINsLoaded() {
        ++this.nBINsLoaded;
    }

    public void incLNsLoaded() {
        ++this.nLNsLoaded;
    }

    public void addLNsLoaded(int newLNs) {
        this.nLNsLoaded += newLNs;
    }

    public void incDINsLoaded() {
        ++this.nDINsLoaded;
    }

    public void incDBINsLoaded() {
        ++this.nDBINsLoaded;
    }

    public void incDupCountLNsLoaded() {
        ++this.nDupCountLNsLoaded;
    }

    public void incMemoryExceeded() {
        ++this.nCountMemoryExceeded;
    }

    public void setStatus(PreloadStatus status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=").append(this.status).append('\n');
        sb.append("nINsLoaded=").append(this.nINsLoaded).append('\n');
        sb.append("nBINsLoaded=").append(this.nBINsLoaded).append('\n');
        sb.append("nLNsLoaded=").append(this.nLNsLoaded).append('\n');
        return sb.toString();
    }
}

