/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DuplicateDataException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.ThroughputStatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "Delete";
    private static final String TRACE_MOD = "Mod:";
    private static final String TRACE_INSERT = "Ins:";
    public static final int FOUND = 1;
    public static final int EXACT_KEY = 2;
    public static final int FOUND_LAST = 4;
    private static long lastAllocatedId = 0L;
    private final int thisId = (int)CursorImpl.getNextCursorId();
    private final DatabaseImpl databaseImpl;
    private Locker locker;
    private final boolean retainNonTxnLocks;
    private final boolean isSecondaryCursor;
    private volatile BIN bin = null;
    private volatile int index = -1;
    private byte status;
    private CacheMode cacheMode;
    private boolean allowEviction;
    private RecordVersion currentRecordVersion;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL;
    private TestHook testHook;

    public CursorImpl(DatabaseImpl database, Locker locker) {
        this(database, locker, true, false);
    }

    public CursorImpl(DatabaseImpl databaseImpl, Locker locker, boolean retainNonTxnLocks, boolean isSecondaryCursor) {
        this.retainNonTxnLocks = retainNonTxnLocks;
        this.isSecondaryCursor = isSecondaryCursor;
        this.databaseImpl = databaseImpl;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.cacheMode = CacheMode.DEFAULT;
        this.status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorImpl cloneCursor(boolean samePosition) {
        assert (this.assertCursorState(false, false));
        CursorImpl ret = null;
        try {
            this.latchBIN();
            ret = (CursorImpl)super.clone();
            if (!this.retainNonTxnLocks) {
                ret.locker = this.locker.newNonTxnLocker();
            }
            ret.locker.registerCursor(ret);
            if (samePosition) {
                ret.addCursor();
            } else {
                ret.clear();
            }
        }
        catch (CloneNotSupportedException cannotOccur) {
            CursorImpl cursorImpl = null;
            return cursorImpl;
        }
        finally {
            this.releaseBIN();
        }
        this.criticalEviction();
        return ret;
    }

    private static long getNextCursorId() {
        return ++lastAllocatedId;
    }

    public int hashCode() {
        return this.thisId;
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void setClosingLocker(CursorImpl closingCursor) {
        if (!this.retainNonTxnLocks && this.locker != closingCursor.locker) {
            this.locker.setClosingLocker(closingCursor.locker);
        }
    }

    public void clearClosingLocker() {
        this.locker.setClosingLocker(null);
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = this.databaseImpl.getEffectiveCacheMode(mode);
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.maybeInitTreeStatsAccumulator();
        this.treeStatsAccumulatorTL.set(tSA);
    }

    private void maybeInitTreeStatsAccumulator() {
        if (this.treeStatsAccumulatorTL == null) {
            this.treeStatsAccumulatorTL = new ThreadLocal();
        }
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            this.maybeInitTreeStatsAccumulator();
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void incrementLNCount() {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (treeStatsAccumulator != null) {
            treeStatsAccumulator.incrementLNCount();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public void setOnFirstSlot() {
        assert (this.bin.isLatchOwner());
        this.index = 0;
    }

    public void setOnLastSlot() {
        assert (this.bin.isLatchOwner());
        this.index = this.bin.getNEntries() - 1;
    }

    public boolean isOnBIN(BIN bin) {
        return this.bin == bin;
    }

    public void assertBIN(BIN bin) {
        assert (this.bin == bin) : "nodeId=" + bin.getNodeId() + " cursor=" + this.dumpToString(true);
    }

    public boolean isOnSamePosition(CursorImpl other) {
        return this.bin == other.bin && this.index == other.index;
    }

    public void setBIN(BIN newBin) {
        this.bin = newBin;
    }

    public void latchBIN() throws DatabaseException {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch(this.cacheMode);
            if (this.bin == waitingOn) {
                return;
            }
            waitingOn.releaseLatch();
        }
    }

    public void releaseBIN() {
        if (this.bin != null) {
            this.bin.releaseLatchIfOwner();
        }
    }

    void addCursor(BIN bin) {
        if (bin != null) {
            assert (bin.isLatchExclusiveOwner());
            bin.addCursor(this);
        }
    }

    void addCursor() {
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    private void setPosition(BIN newBin, int newIndex) {
        if (this.bin != newBin) {
            if (this.bin != null) {
                this.latchBIN();
                this.bin.removeCursor(this);
                this.bin.releaseLatch();
            }
            this.setBIN(newBin);
            this.addCursor();
        }
        this.setIndex(newIndex);
    }

    public long getCurrentNodeId() {
        BIN b = this.bin;
        return b == null ? -1L : b.getNodeId();
    }

    public long getCurrentLsn() {
        assert (this.bin != null && this.bin.isLatchOwner());
        assert (this.index >= 0 && this.index < this.bin.getNEntries());
        return this.bin.getLsn(this.index);
    }

    public byte[] getCurrentKey() {
        return this.getCurrentKey(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCurrentKey(boolean isLatched) {
        if (!isLatched) {
            this.latchBIN();
        }
        try {
            assert (this.bin != null);
            assert (this.index >= 0 && this.index < this.bin.getNEntries());
            byte[] byArray = this.bin.getKey(this.index);
            return byArray;
        }
        finally {
            if (!isLatched) {
                this.releaseBIN();
            }
        }
    }

    private void setInitialized() {
        this.status = (byte)2;
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public boolean isInternalDbCursor() {
        return this.databaseImpl.isInternalDb();
    }

    public boolean hasDuplicates() {
        return this.databaseImpl.getSortedDuplicates();
    }

    public void dumpTree() {
        this.databaseImpl.getTree().dump();
    }

    public void beforeAdvance() {
        if (this.cacheMode == CacheMode.EVICT_LN && this.bin != null) {
            this.evict();
        }
        this.releaseNonTxnLocks();
        this.criticalEviction();
    }

    public void reset() throws DatabaseException {
        this.removeCursorAndPerformCacheEviction(null);
        this.releaseNonTxnLocks();
        this.criticalEviction();
    }

    private void clear() {
        this.bin = null;
        this.index = -1;
        this.status = 1;
        this.currentRecordVersion = null;
    }

    private void releaseNonTxnLocks() {
        if (!this.retainNonTxnLocks) {
            this.locker.releaseNonTxnLocks();
        }
    }

    public void close() throws DatabaseException {
        this.close(null);
    }

    public void close(CursorImpl newCursor) throws DatabaseException {
        assert (this.assertCursorState(false, false));
        this.removeCursorAndPerformCacheEviction(newCursor);
        this.locker.unRegisterCursor(this);
        if (!this.retainNonTxnLocks) {
            this.locker.nonTxnOperationEnd();
        }
        this.status = (byte)3;
        this.criticalEviction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCursorAndPerformCacheEviction(CursorImpl newCursor) {
        this.latchBIN();
        if (this.bin == null) {
            this.clear();
            return;
        }
        try {
            this.bin.removeCursor(this);
            this.performCacheEviction(newCursor);
        }
        finally {
            this.releaseBIN();
            this.clear();
        }
    }

    public void setAllowEviction(boolean allowed) {
        this.allowEviction = allowed;
    }

    public void criticalEviction() {
        if (this.allowEviction && this.cacheMode != CacheMode.MAKE_COLD && this.cacheMode != CacheMode.EVICT_BIN) {
            this.databaseImpl.getEnv().criticalEviction(false);
        }
    }

    private void performCacheEviction(CursorImpl newCursor) {
        int nextIndex;
        BIN nextBin;
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        if (this.cacheMode != CacheMode.EVICT_LN && this.cacheMode != CacheMode.EVICT_BIN && (this.cacheMode != CacheMode.MAKE_COLD || !envImpl.isCacheFull() && !envImpl.wasCacheEverFull())) {
            return;
        }
        if (newCursor != null) {
            nextBin = newCursor.bin;
            nextIndex = newCursor.index;
        } else {
            nextBin = null;
            nextIndex = -1;
        }
        switch (this.cacheMode) {
            case EVICT_LN: {
                if (this.bin == nextBin && this.index == nextIndex) break;
                this.evict(true);
                break;
            }
            case EVICT_BIN: {
                if (this.bin == nextBin) {
                    if (this.index == nextIndex) break;
                    this.evict(true);
                    break;
                }
                this.evictBIN();
                break;
            }
            case MAKE_COLD: {
                if (this.bin == nextBin) {
                    if (this.index == nextIndex) break;
                    this.evict(true);
                    break;
                }
                if (!envImpl.isCacheFull()) {
                    this.evict(true);
                    break;
                }
                this.evictBIN();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void evictBIN() {
        this.databaseImpl.getEnv().getEvictor().doEvictOneIN(this.bin, Evictor.EvictionSource.CACHEMODE);
    }

    public void evict() throws DatabaseException {
        this.evict(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(boolean isLatched) throws DatabaseException {
        try {
            if (!isLatched) {
                this.latchBIN();
            }
            if (this.index >= 0) {
                this.bin.evictLN(this.index);
            }
        }
        finally {
            if (!isLatched) {
                this.releaseBIN();
            }
        }
    }

    public OperationStatus deleteCurrentRecord(ReplicationContext repContext) throws DatabaseException {
        return this.deleteCurrentRecord(repContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus deleteCurrentRecord(ReplicationContext repContext, ThroughputStatGroup opStats) throws DatabaseException {
        LN.LogResult logResult;
        long oldLsn;
        assert (this.assertCursorState(true, false));
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        DbType dbType = this.databaseImpl.getDbType();
        boolean success = false;
        this.latchBIN();
        try {
            long oldLNMemSize;
            LockStanding lockStanding = this.lockLN(LockType.WRITE, true, false);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                success = true;
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            oldLsn = lockStanding.lsn;
            assert (oldLsn != -1L);
            int lastLoggedSize = this.bin.getLastLoggedSize(this.index);
            LN ln = lastLoggedSize == 0 && envImpl.getCleaner().getFetchObsoleteSize(this.databaseImpl) || !dbType.mayCreateDeletedLN() ? this.bin.fetchLN(this.index, this.cacheMode) : (LN)this.bin.getTarget(this.index);
            if (ln != null) {
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                ln.delete();
            } else {
                ln = dbType.createDeletedLN(envImpl);
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                this.bin.attachNode(this.index, ln, null);
            }
            WriteLockInfo wli = lockStanding.prepareForUpdate();
            logResult = ln.optionalLog(envImpl, this.databaseImpl, this.bin.getKey(this.index), oldLsn, lastLoggedSize, this.locker, wli, repContext);
            this.bin.updateEntry(this.index, oldLNMemSize, logResult.newLsn, logResult.newSize, null);
            this.bin.setPendingDeleted(this.index);
            this.setCurrentVersion(ln.getVLSNSequence(), logResult.newLsn);
            if (!this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
                this.bin.evictLN(this.index);
            }
            this.locker.addDeleteInfo(this.bin);
            success = true;
        }
        finally {
            if (success && opStats != null && this.bin != null && this.bin.isBINDelta()) {
                opStats.increment(38);
            }
            this.releaseBIN();
        }
        this.trace(Level.FINER, TRACE_DELETE, this.bin, this.index, oldLsn, logResult.newLsn);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus updateCurrentRecord(DatabaseEntry key, DatabaseEntry data, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext, ThroughputStatGroup opStats) {
        assert (this.assertCursorState(true, false));
        if (returnOldData != null) {
            returnOldData.setData(null);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
        }
        OperationStatus status = OperationStatus.NOTFOUND;
        boolean success = false;
        this.latchBIN();
        try {
            LockStanding lockStanding = this.lockLN(LockType.WRITE, true, false);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
            } else {
                status = this.updateRecordInternal(key != null ? Key.makeKey(key) : null, data, returnOldData, returnNewData, lockStanding, repContext);
            }
            success = true;
            OperationStatus operationStatus = status;
            return operationStatus;
        }
        finally {
            if (success && opStats != null && this.bin != null && this.bin.isBINDelta()) {
                opStats.increment(37);
            }
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus insertRecord(byte[] key, LN ln, boolean blindInsertion, ReplicationContext repContext) throws DatabaseException {
        assert (this.assertCursorState(false, true));
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        try {
            Pair<LockStanding, Boolean> result = this.insertRecordInternal(key, ln, blindInsertion, null, repContext);
            if (!result.second().booleanValue()) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<OperationStatus, Boolean> insertOrUpdateRecord(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext, ThroughputStatGroup opStats) {
        assert (key != null);
        assert (data != null);
        assert (ln != null);
        assert (putMode != null);
        assert (this.assertCursorState(false, true));
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        if (putMode != PutMode.OVERWRITE && putMode != PutMode.NO_OVERWRITE && putMode != PutMode.BLIND_INSERTION) {
            throw EnvironmentFailureException.unexpectedState(putMode.toString());
        }
        boolean success = false;
        boolean inserted = false;
        byte[] keyCopy = Key.makeKey(key);
        try {
            Pair<LockStanding, Boolean> insertResult = this.insertRecordInternal(keyCopy, ln, putMode == PutMode.BLIND_INSERTION, returnNewData, repContext);
            if (insertResult.second().booleanValue()) {
                inserted = true;
                success = true;
                Pair<OperationStatus, Boolean> pair = new Pair<OperationStatus, Boolean>(OperationStatus.SUCCESS, true);
                return pair;
            }
            if (putMode == PutMode.NO_OVERWRITE) {
                success = true;
                Pair<OperationStatus, Boolean> pair = new Pair<OperationStatus, Boolean>(OperationStatus.KEYEXIST, false);
                return pair;
            }
            OperationStatus status = this.updateRecordInternal(keyCopy, data, returnOldData, returnNewData, insertResult.first(), repContext);
            success = true;
            Pair<OperationStatus, Boolean> pair = new Pair<OperationStatus, Boolean>(status, false);
            return pair;
        }
        finally {
            if (success && opStats != null && this.bin != null && this.bin.isBINDelta()) {
                if (inserted) {
                    opStats.increment(36);
                } else {
                    opStats.increment(37);
                }
            }
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<LockStanding, Boolean> insertRecordInternal(byte[] key, LN ln, boolean blindInsertion, DatabaseEntry returnNewData, ReplicationContext repContext) {
        WriteLockInfo wli;
        boolean isSlotReuse;
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        LockStanding lockStanding = null;
        Tree tree = this.databaseImpl.getTree();
        this.bin = tree.findBinForInsert(key, this.getCacheMode());
        this.locker.preLogWithoutLock(this.databaseImpl);
        int insertIndex = this.bin.insertEntry1(ln, key, -1L, blindInsertion);
        if ((insertIndex & 0x20000) == 0) {
            boolean isDeleted;
            isSlotReuse = true;
            this.setIndex(insertIndex);
            this.addCursor();
            this.setInitialized();
            lockStanding = this.lockLN(LockType.WRITE, true, false);
            boolean bl = isDeleted = !lockStanding.recordExists();
            if (!isDeleted) {
                return new Pair<LockStanding, Boolean>(lockStanding, false);
            }
            assert (lockStanding != null);
            wli = lockStanding.prepareForUpdate();
        } else {
            isSlotReuse = false;
            this.setIndex(insertIndex &= 0xFFFDFFFF);
            this.addCursor();
            this.setInitialized();
            wli = LockStanding.prepareForInsert();
        }
        LN.LogResult logResult = null;
        try {
            logResult = ln.optionalLog(envImpl, this.databaseImpl, key, -1L, 0, this.locker, wli, repContext);
        }
        finally {
            if (logResult == null && !isSlotReuse) {
                this.bin.setKnownDeleted(this.index);
            }
        }
        if (lockStanding == null) {
            this.bin.updateEntry(this.index, logResult.newLsn, logResult.newSize);
            ln.addExtraMarshaledMemorySize(this.bin);
        } else {
            this.bin.prepareForSlotReuse(this.index);
            this.bin.updateEntry(this.index, (Node)ln, logResult.newLsn, logResult.newSize, key);
            this.bin.clearKnownDeleted(this.index);
            this.bin.clearPendingDeleted(this.index);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
            ln.setEntry(returnNewData);
        }
        this.setInitialized();
        this.setCurrentVersion(ln.getVLSNSequence(), this.bin.getLsn(this.index));
        if (this.databaseImpl.getSortedDuplicates() && !this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
            this.bin.evictLN(this.index);
        }
        this.traceInsert(Level.FINER, this.bin, logResult.newLsn, this.index);
        return new Pair<LockStanding, Boolean>(lockStanding, true);
    }

    private OperationStatus updateRecordInternal(byte[] key, DatabaseEntry data, DatabaseEntry returnOldData, DatabaseEntry returnNewData, LockStanding lockStanding, ReplicationContext repContext) {
        long oldLNMemSize;
        byte[] newData;
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        DbType dbType = this.databaseImpl.getDbType();
        assert (lockStanding.recordExists());
        long oldLsn = lockStanding.lsn;
        assert (oldLsn != -1L);
        int lastLoggedSize = this.bin.getLastLoggedSize(this.index);
        LN ln = returnOldData != null || data.getPartial() || lastLoggedSize == 0 && envImpl.getCleaner().getFetchObsoleteSize(this.databaseImpl) || !dbType.mayCreateUpdatedLN() ? this.bin.fetchLN(this.index, this.cacheMode) : (LN)this.bin.getTarget(this.index);
        byte[] oldKey = this.bin.getKey(this.index);
        byte[] foundDataBytes = ln != null ? ln.getData() : null;
        byte[] byArray = newData = data.getPartial() ? LN.resolvePartialEntry(data, foundDataBytes) : LN.copyEntryData(data);
        if (key != null && Key.compareKeys(oldKey, key, this.databaseImpl.getKeyComparator()) != 0) {
            throw new DuplicateDataException("Can't replace a duplicate with new data that is not equal to the existing data according to the duplicate  comparator.");
        }
        if (returnOldData != null) {
            assert (foundDataBytes != null);
            returnOldData.setData(null);
            LN.setEntry(returnOldData, foundDataBytes);
        }
        if (ln != null) {
            oldLNMemSize = ln.getMemorySizeIncludedByParent();
            ln.modify(newData);
        } else {
            ln = dbType.createUpdatedLN(envImpl, newData);
            this.bin.attachNode(this.index, ln, null);
            oldLNMemSize = ln.getMemorySizeIncludedByParent();
        }
        WriteLockInfo wli = lockStanding.prepareForUpdate();
        LN.LogResult logResult = ln.optionalLog(envImpl, this.databaseImpl, key != null ? key : oldKey, oldLsn, lastLoggedSize, this.locker, wli, repContext);
        if (returnNewData != null) {
            returnNewData.setData(null);
            ln.setEntry(returnNewData);
        }
        this.bin.updateEntry(this.index, oldLNMemSize, logResult.newLsn, logResult.newSize, key);
        this.setCurrentVersion(ln.getVLSNSequence(), logResult.newLsn);
        if (this.databaseImpl.getSortedDuplicates() && !this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
            this.bin.evictLN(this.index);
        }
        this.trace(Level.FINER, TRACE_MOD, this.bin, this.index, oldLsn, logResult.newLsn);
        return OperationStatus.SUCCESS;
    }

    public boolean positionFirstOrLast(boolean first) throws DatabaseException {
        assert (this.assertCursorState(false, true));
        boolean found = false;
        try {
            this.bin = first ? this.databaseImpl.getTree().getFirstNode(this.cacheMode) : this.databaseImpl.getTree().getLastNode(this.cacheMode);
            if (this.bin != null) {
                TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                if (this.bin.getNEntries() == 0) {
                    found = true;
                    this.index = -1;
                } else {
                    int n = this.index = first ? 0 : this.bin.getNEntries() - 1;
                    if (treeStatsAccumulator != null && !this.bin.isEntryKnownDeleted(this.index) && !this.bin.isEntryPendingDeleted(this.index)) {
                        treeStatsAccumulator.incrementLNCount();
                    }
                    found = true;
                }
            }
            this.addCursor(this.bin);
            this.setInitialized();
            return found;
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public int searchRange(DatabaseEntry searchKey, Comparator<byte[]> comparator) {
        assert (this.assertCursorState(false, true));
        boolean foundSomething = false;
        boolean foundExactKey = false;
        boolean foundLast = false;
        BINBoundary binBoundary = new BINBoundary();
        try {
            byte[] key = Key.makeKey(searchKey);
            this.bin = this.databaseImpl.getTree().search(key, Tree.SearchType.NORMAL, binBoundary, this.cacheMode, comparator);
            if (this.bin != null) {
                foundSomething = true;
                if (this.bin.isBINDelta() && comparator != null) {
                    this.bin.mutateToFullBIN();
                }
                this.index = this.bin.findEntry(key, true, false, comparator);
                if (this.bin.isBINDelta() && (this.index < 0 || (this.index & 0x10000) == 0 || binBoundary.isLastBin)) {
                    this.bin.mutateToFullBIN();
                    this.index = this.bin.findEntry(key, true, false, comparator);
                }
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExactKey = true;
                        this.index &= 0xFFFEFFFF;
                    }
                    foundLast = binBoundary.isLastBin && this.index == this.bin.getNEntries() - 1;
                }
                this.addCursor(this.bin);
            }
            this.setInitialized();
            return (foundSomething ? 1 : 0) | (foundExactKey ? 2 : 0) | (foundLast ? 4 : 0);
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public boolean searchExact(DatabaseEntry searchKey, LockType lockType) {
        return this.searchExact(searchKey, lockType, false, false) != null;
    }

    public LockStanding searchExact(DatabaseEntry searchKey, LockType lockType, boolean dirtyReadAll, boolean dataRequested) {
        assert (this.assertCursorState(false, true));
        LockStanding lockStanding = null;
        try {
            byte[] key = Key.makeKey(searchKey);
            this.bin = this.databaseImpl.getTree().search(key, this.cacheMode);
            if (this.bin != null) {
                this.index = this.bin.findEntry(key, false, true);
                if (this.index < 0 && this.bin.isBINDelta() && this.bin.mayHaveKeyInFullBin(key)) {
                    this.bin.mutateToFullBIN();
                    this.index = this.bin.findEntry(key, false, true);
                }
                this.addCursor(this.bin);
                if (this.index >= 0) {
                    lockStanding = this.lockLNAndCheckDeleted(lockType, dirtyReadAll, dataRequested);
                }
            }
            this.setInitialized();
            return lockStanding;
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public OperationStatus lockAndGetCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        return this.lockAndGetCurrent(foundKey, foundData, lockType, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus lockAndGetCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean dirtyReadAll, boolean isLatched, boolean unlatch) throws DatabaseException {
        boolean success = false;
        try {
            boolean dataRequested;
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
            if (!isLatched) {
                this.latchBIN();
            }
            assert (this.bin.getCursorSet().contains(this));
            TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
            if (this.index >= 0 && this.index < this.bin.getNEntries() && (this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index))) {
                this.bin.queueSlotDeletion();
            }
            if (this.index < 0 || this.index >= this.bin.getNEntries() || this.bin.isEntryKnownDeleted(this.index)) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                success = true;
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            assert (TestHookExecute.doHookIfSet(this.testHook));
            boolean bl = dataRequested = foundData != null && (!foundData.getPartial() || foundData.getPartialLength() != 0);
            if (this.lockLNAndCheckDeleted(lockType, dirtyReadAll, dataRequested) == null) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                success = true;
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            this.getCurrent(foundKey, foundData);
            success = true;
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            if (unlatch || !success) {
                this.releaseBIN();
            }
        }
    }

    private LockStanding lockLNAndCheckDeleted(LockType lockType, boolean dirtyReadAll, boolean dataRequested) {
        assert (!dirtyReadAll || lockType == LockType.NONE);
        assert (!dataRequested || !this.databaseImpl.getSortedDuplicates());
        LockStanding standing = this.lockLN(lockType);
        if (standing.recordExists()) {
            return standing;
        }
        if (lockType != LockType.NONE) {
            this.revertLock(standing);
            return null;
        }
        if (!dirtyReadAll) {
            return null;
        }
        standing = this.lockLN(LockType.READ, false, !dataRequested);
        if (standing.lockResult.getLockGrant() == LockGrantType.DENIED) {
            assert (!standing.recordExists());
            return standing;
        }
        this.revertLock(standing);
        if (standing.recordExists()) {
            return standing;
        }
        return null;
    }

    public void getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData) {
        LN ln;
        assert (this.bin.isLatchExclusiveOwner());
        assert (this.index >= 0 && this.index < this.bin.getNEntries());
        assert (!this.bin.isEntryKnownDeleted(this.index));
        boolean isEmptyLN = this.databaseImpl.isLNImmediatelyObsolete();
        boolean dataRequested = foundData != null && (!foundData.getPartial() || foundData.getPartialLength() != 0);
        LN lN = ln = !isEmptyLN && dataRequested ? this.bin.fetchLN(this.index, this.cacheMode) : null;
        if (dataRequested) {
            assert (ln != null || isEmptyLN);
            byte[] lnData = ln != null ? ln.getData() : LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            LN.setEntry(foundData, lnData);
        }
        if (foundKey != null) {
            LN.setEntry(foundKey, this.bin.getKey(this.index));
        }
        long vlsn = ln != null ? ln.getVLSNSequence() : this.bin.getVLSN(this.index, false, this.cacheMode);
        this.setCurrentVersion(vlsn, this.bin.getLsn(this.index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLN(boolean isLatched, boolean unlatch) throws DatabaseException {
        boolean success = false;
        try {
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
            if (!isLatched) {
                this.latchBIN();
            }
            assert (this.bin.getCursorSet().contains(this));
            LN ln = this.bin.fetchLN(this.index, this.cacheMode);
            success = true;
            LN lN = ln;
            return lN;
        }
        finally {
            if (unlatch || !success) {
                this.releaseBIN();
            }
        }
    }

    public LN lockAndGetCurrentLN(LockType lockType) throws DatabaseException {
        return this.lockAndGetCurrentLN(lockType, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN lockAndGetCurrentLN(LockType lockType, boolean isLatched, boolean unlatch) throws DatabaseException {
        boolean success = false;
        try {
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
            if (!isLatched) {
                this.latchBIN();
            }
            assert (this.bin.getCursorSet().contains(this));
            LockStanding lockStanding = this.lockLN(lockType);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                success = true;
                LN lN = null;
                return lN;
            }
            LN ln = this.bin.fetchLN(this.index, this.cacheMode);
            success = true;
            LN lN = ln;
            return lN;
        }
        finally {
            if (unlatch || !success) {
                this.releaseBIN();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordVersion getCurrentVersion(boolean allowFetch) {
        this.checkCursorState(true, false);
        if (this.isSecondaryCursor) {
            if (this.currentRecordVersion == null) {
                throw new IllegalStateException("Record version is available via a SecondaryCursor only if the associated primary record was retrieved.");
            }
            return this.currentRecordVersion;
        }
        if (!(this.currentRecordVersion == null || this.currentRecordVersion.getVLSN() == VLSN.NULL_VLSN.getSequence() && allowFetch && this.databaseImpl.getEnv().getPreserveVLSN())) {
            return this.currentRecordVersion;
        }
        this.latchBIN();
        try {
            this.setCurrentVersion(this.bin.getVLSN(this.index, allowFetch, this.cacheMode), this.bin.getLsn(this.index));
        }
        finally {
            this.releaseBIN();
        }
        return this.currentRecordVersion;
    }

    private void setCurrentVersion(long vlsn, long lsn) {
        if (this.isSecondaryCursor) {
            return;
        }
        this.currentRecordVersion = new RecordVersion(vlsn, lsn);
    }

    public RecordVersion getCachedRecordVersion() {
        return this.currentRecordVersion;
    }

    public void setSecondaryCurrentVersion(RecordVersion primaryVersion) {
        assert (this.isSecondaryCursor);
        this.currentRecordVersion = primaryVersion;
    }

    public boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        BIN oldBin = this.bin;
        int oldIndex = this.index;
        key.setData(null);
        data.setData(null);
        try {
            this.getNext(key, data, LockType.NONE, false, true, false, null);
        }
        catch (DatabaseException ignored) {
            // empty catch block
        }
        if (this.bin != oldBin || this.index != oldIndex) {
            if (key.getData() == null && this.bin != null && this.index > 0) {
                LN.setEntry(key, this.bin.getKey(this.index));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean dirtyReadAll, boolean forward, boolean isLatched, RangeConstraint rangeConstraint) throws DatabaseException {
        assert (this.assertCursorState(true, false));
        assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
        OperationStatus result = OperationStatus.NOTFOUND;
        IN anchorBIN = null;
        try {
            while (this.bin != null) {
                assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
                if (!isLatched) {
                    this.latchBIN();
                    isLatched = true;
                }
                this.bin.mutateToFullBIN();
                if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                    if (rangeConstraint != null && !rangeConstraint.inBounds(this.bin.getKey(this.index))) {
                        result = OperationStatus.NOTFOUND;
                        this.releaseBIN();
                    } else {
                        OperationStatus ret = this.lockAndGetCurrent(foundKey, foundData, lockType, dirtyReadAll, true, false);
                        if (LatchSupport.TRACK_LATCHES) {
                            LatchSupport.expectBtreeLatchesHeld(1);
                        }
                        if (ret != OperationStatus.SUCCESS) continue;
                        this.incrementLNCount();
                        this.releaseBIN();
                        result = OperationStatus.SUCCESS;
                    }
                    break;
                }
                anchorBIN = this.bin;
                anchorBIN.pin();
                this.bin.removeCursor(this);
                this.bin = null;
                Tree tree = this.databaseImpl.getTree();
                assert (TestHookExecute.doHookIfSet(this.testHook));
                if (forward) {
                    this.bin = tree.getNextBin((BIN)anchorBIN, this.cacheMode);
                    this.index = -1;
                } else {
                    this.bin = tree.getPrevBin((BIN)anchorBIN, this.cacheMode);
                    if (this.bin != null) {
                        this.index = this.bin.getNEntries();
                    }
                }
                isLatched = true;
                if (this.bin == null) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    result = OperationStatus.NOTFOUND;
                    break;
                }
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(1);
                }
                this.addCursor();
                anchorBIN.unpin();
                anchorBIN = null;
            }
        }
        finally {
            if (anchorBIN != null) {
                anchorBIN.unpin();
            }
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForInsertion(GetMode getMode, CursorImpl dupCursor) {
        CursorImpl origCursor = this;
        boolean forward = getMode.isForward();
        boolean ret = false;
        if (origCursor.bin != dupCursor.bin) {
            block7: {
                origCursor.latchBIN();
                BIN origBIN = origCursor.bin;
                origBIN.mutateToFullBIN();
                try {
                    if (forward) {
                        if (origBIN.getNEntries() - 1 <= origCursor.getIndex()) break block7;
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            if (origBIN.isEntryKnownDeleted(i) || origBIN.isEntryPendingDeleted(i)) continue;
                            ret = true;
                            break block7;
                        }
                        break block7;
                    }
                    if (origCursor.getIndex() <= 0) break block7;
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        if (origBIN.isEntryKnownDeleted(i) || origBIN.isEntryPendingDeleted(i)) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBIN();
                }
            }
            return ret;
        }
        return false;
    }

    public long skip(boolean forward, long maxCount, RangeConstraint rangeConstraint) {
        try (CursorImpl c = this.cloneCursor(true);){
            long l = c.skipInternal(forward, maxCount, rangeConstraint, this);
            return l;
        }
    }

    private long skipInternal(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor) {
        Tree tree = this.databaseImpl.getTree();
        this.latchBIN();
        IN parent = null;
        IN prevBin = null;
        BIN curBin = this.bin;
        int curIndex = this.getIndex();
        long count = 0L;
        boolean success = false;
        try {
            while (true) {
                block20: {
                    curBin.mutateToFullBIN();
                    count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, curIndex, count);
                    if (count < 0L) {
                        curBin.releaseLatch();
                        success = true;
                        long l = -count;
                        return l;
                    }
                    byte[] idKey = curBin.getNEntries() == 0 ? curBin.getIdentifierKey() : (forward ? curBin.getKey(curBin.getNEntries() - 1) : curBin.getKey(0));
                    SearchResult result = tree.getParentINForChildIN(curBin, false, true, CacheMode.DEFAULT);
                    parent = result.parent;
                    if (!result.exactParentFound) {
                        throw EnvironmentFailureException.unexpectedState("Cannot get parent of BIN id=" + curBin.getNodeId() + " key=" + Arrays.toString(idKey));
                    }
                    int parentIndex = parent.findEntry(idKey, false, false);
                    curBin = (BIN)parent.fetchIN(parentIndex);
                    curBin.latch();
                    if (forward ? parentIndex < parent.getNEntries() - 1 : parentIndex > 0) {
                        int incr = forward ? 1 : -1;
                        parentIndex += incr;
                        while (true) {
                            prevBin = curBin;
                            curBin = null;
                            if (forward ? parentIndex >= parent.getNEntries() : parentIndex < 0) {
                                parent.releaseLatch();
                                break block20;
                            }
                            curBin = (BIN)parent.getTarget(parentIndex);
                            if (curBin == null || !curBin.latchNoWait(CacheMode.DEFAULT)) {
                                parent.releaseLatch();
                                break block20;
                            }
                            prevBin.releaseLatch();
                            prevBin = null;
                            this.setPosition(curBin, -1);
                            curBin.mutateToFullBIN();
                            count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, forward ? -1 : curBin.getNEntries(), count);
                            if (count < 0L) {
                                parent.releaseLatch();
                                curBin.releaseLatch();
                                success = true;
                                long l = -count;
                                return l;
                            }
                            parentIndex += incr;
                        }
                    }
                    parent.releaseLatch();
                    prevBin = curBin;
                }
                BIN bIN = curBin = forward ? tree.getNextBin((BIN)prevBin, CacheMode.DEFAULT) : tree.getPrevBin((BIN)prevBin, CacheMode.DEFAULT);
                assert (!prevBin.isLatchOwner());
                if (curBin == null) {
                    success = true;
                    long l = count;
                    return l;
                }
                prevBin = null;
                curIndex = forward ? -1 : curBin.getNEntries();
                this.setPosition(curBin, -1);
            }
        }
        finally {
            if (curBin != null && !success) {
                curBin.releaseLatchIfOwner();
            }
            if (prevBin != null && !success) {
                prevBin.releaseLatchIfOwner();
            }
            if (parent != null && !success) {
                parent.releaseLatchIfOwner();
            }
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
        }
    }

    private long skipEntries(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor, BIN curBin, int curIndex, long count) {
        assert (!curBin.isBINDelta());
        int incr = forward ? 1 : -1;
        int i = curIndex + incr;
        while (!(!forward ? i < 0 : i >= curBin.getNEntries())) {
            if (rangeConstraint != null && !rangeConstraint.inBounds(curBin.getKey(i))) {
                return -count;
            }
            if (!curBin.isEntryKnownDeleted(i) && !curBin.isEntryPendingDeleted(i)) {
                finalPositionCursor.setPosition(curBin, i);
                if (maxCount > 0L && ++count >= maxCount) {
                    return -count;
                }
            }
            i += incr;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TrackingInfo> getAncestorPath() {
        long binLsn;
        ArrayList<TrackingInfo> trackingList = new ArrayList<TrackingInfo>();
        this.latchBIN();
        BIN origBin = this.bin;
        Tree tree = this.databaseImpl.getTree();
        SearchResult result = tree.getParentINForChildIN(origBin, false, true, CacheMode.UNCHANGED, trackingList);
        if (!result.exactParentFound) {
            return null;
        }
        try {
            if (origBin != result.parent.getTarget(result.index) || origBin != this.bin) {
                List<TrackingInfo> list = null;
                return list;
            }
            binLsn = result.parent.getLsn(result.index);
            this.bin.latch();
        }
        finally {
            result.parent.releaseLatch();
        }
        try {
            int binEntries = this.bin.getNEntries();
            int binIndex = this.getIndex();
            for (int i = this.bin.getNEntries() - 1; i >= 0; --i) {
                if (!this.bin.isEntryKnownDeleted(i) && !this.bin.isEntryPendingDeleted(i)) continue;
                --binEntries;
                if (i >= binIndex) continue;
                --binIndex;
            }
            TrackingInfo info = new TrackingInfo(binLsn, this.bin.getNodeId(), binEntries, binIndex);
            trackingList.add(info);
            ArrayList<TrackingInfo> arrayList = trackingList;
            return arrayList;
        }
        finally {
            this.bin.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextKeyForInsert(DatabaseEntry key) throws DatabaseException {
        DatabaseEntry tempKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        boolean lockedNextKey = false;
        boolean latched = true;
        try {
            int searchResult;
            while (((searchResult = this.searchRange(tempKey, null)) & 1) != 0 && (searchResult & 4) == 0) {
                DatabaseEntry tempData = new DatabaseEntry();
                tempData.setPartial(0, 0, true);
                OperationStatus status = this.getNext(tempKey, tempData, LockType.RANGE_INSERT, false, true, true, null);
                latched = false;
                if (status == OperationStatus.SUCCESS) {
                    Comparator<byte[]> comparator = this.databaseImpl.getKeyComparator();
                    int c = Key.compareKeys(tempKey, key, comparator);
                    if (c <= 0) {
                        tempKey.setData(key.getData(), key.getOffset(), key.getSize());
                        continue;
                    }
                    lockedNextKey = true;
                }
                break;
            }
        }
        finally {
            if (latched) {
                this.releaseBIN();
            }
        }
        if (!lockedNextKey) {
            this.lockEof(LockType.RANGE_INSERT);
        }
    }

    public LockStanding lockLN(LockType lockType) throws LockConflictException {
        return this.lockLN(lockType, false, false);
    }

    public LockStanding lockLN(LockType lockType, boolean allowUncontended, boolean noWait) throws LockConflictException {
        LockStanding standing;
        block13: {
            long newLsn;
            standing = new LockStanding();
            standing.lsn = this.bin.getLsn(this.index);
            standing.deleted = this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index);
            if (standing.lsn == -1L) {
                assert (this.bin.isEntryKnownDeleted(this.index));
                standing.nullLsn = true;
                return standing;
            }
            if (allowUncontended && this.databaseImpl.getEnv().getTxnManager().getLockManager().isLockUncontended(standing.lsn)) {
                this.locker.preLogWithoutLock(this.databaseImpl);
                assert (this.verifyPendingDeleted(lockType));
                return standing;
            }
            if (this.locker.getDefaultNoWait()) {
                try {
                    standing.lockResult = this.locker.lock(standing.lsn, lockType, true, this.databaseImpl);
                }
                catch (LockConflictException e) {
                    this.releaseBIN();
                    throw e;
                }
            } else {
                standing.lockResult = this.locker.nonBlockingLock(standing.lsn, lockType, false, this.databaseImpl);
            }
            if (noWait || standing.lockResult.getLockGrant() != LockGrantType.DENIED) {
                assert (this.verifyPendingDeleted(lockType));
                return standing;
            }
            do {
                this.releaseBIN();
                standing.lockResult = this.locker.lock(standing.lsn, lockType, false, this.databaseImpl);
                this.latchBIN();
                standing.deleted = this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index);
                newLsn = this.bin.getLsn(this.index);
                if (standing.lsn == newLsn) break block13;
                this.revertLock(standing);
                standing.lsn = newLsn;
            } while (newLsn != -1L);
            assert (this.bin.isEntryKnownDeleted(this.index));
            standing.nullLsn = true;
            return standing;
        }
        assert (this.verifyPendingDeleted(lockType));
        return standing;
    }

    public static void lockAfterLsnChange(DatabaseImpl dbImpl, long oldLsn, long newLsn, Locker excludeLocker) {
        Locker locker;
        LockManager lockManager = dbImpl.getEnv().getTxnManager().getLockManager();
        Set<LockInfo> owners = lockManager.getOwners(oldLsn);
        if (owners == null) {
            return;
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker) continue;
            locker.lockAfterLsnChange(oldLsn, newLsn, dbImpl);
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker || !locker.allowReleaseLockAfterLsnChange()) continue;
            locker.releaseLock(oldLsn);
        }
    }

    private void verifyCursor(BIN bin) throws DatabaseException {
        if (!bin.getCursorSet().contains(this)) {
            throw new EnvironmentFailureException(this.databaseImpl.getEnv(), EnvironmentFailureReason.UNEXPECTED_STATE, "BIN cursorSet is inconsistent");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized, boolean mustNotBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized, mustNotBeInitialized);
            return true;
        }
        catch (RuntimeException e) {
            assert (false) : e.toString() + " " + this.dumpToString(true);
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized, boolean mustNotBeInitialized) {
        switch (this.status) {
            case 1: {
                if (!mustBeInitialized) break;
                throw new IllegalStateException("Cursor not initialized.");
            }
            case 2: {
                if (!mustNotBeInitialized) break;
                throw EnvironmentFailureException.unexpectedState("Cursor is initialized.");
            }
            case 3: {
                throw new IllegalStateException("Cursor has been closed.");
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unknown cursor status: " + this.status);
            }
        }
    }

    private boolean verifyPendingDeleted(LockType lockType) {
        if (lockType == LockType.NONE) {
            return true;
        }
        if (this.bin == null || this.index < 0) {
            return true;
        }
        LN ln = (LN)this.bin.getTarget(this.index);
        if (ln == null) {
            return true;
        }
        boolean kd = this.bin.isEntryKnownDeleted(this.index);
        boolean pd = this.bin.isEntryPendingDeleted(this.index);
        boolean lnDeleted = ln.isDeleted();
        assert (lnDeleted && (kd || pd) || !lnDeleted && !pd) : "Deleted state mismatch LNDeleted = " + lnDeleted + " PD = " + pd + " KD = " + kd;
        return true;
    }

    public void revertLock(LockStanding standing) throws DatabaseException {
        if (standing.lockResult != null) {
            this.revertLock(standing.lsn, standing.lockResult);
            standing.lockResult = null;
        }
    }

    private void revertLock(long lsn, LockResult lockResult) throws DatabaseException {
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            this.locker.releaseLock(lsn);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            this.locker.demoteLock(lsn);
        }
    }

    public void lockEof(LockType lockType) throws DatabaseException {
        this.locker.lock(this.databaseImpl.getEofLsn(), lockType, false, this.databaseImpl);
    }

    public void checkEnv() {
        this.databaseImpl.getEnv().checkIfInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseDbWithCursor(DatabaseImpl db, LockType lockType, boolean allowEviction, WithCursor withCursor) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Locker locker = null;
        CursorImpl cursor = null;
        try {
            EnvironmentImpl envImpl = db.getEnv();
            locker = LockerFactory.getInternalReadOperationLocker(envImpl);
            cursor = new CursorImpl(db, locker);
            cursor.setAllowEviction(allowEviction);
            if (cursor.positionFirstOrLast(true)) {
                OperationStatus status = cursor.lockAndGetCurrent(key, data, lockType, false, true, true);
                boolean done = false;
                while (!done) {
                    if (status == OperationStatus.SUCCESS && !withCursor.withCursor(cursor, key, data)) {
                        done = true;
                    }
                    if (done || (status = cursor.getNext(key, data, lockType, false, true, false, null)) == OperationStatus.SUCCESS) continue;
                    done = true;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBIN();
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public StatGroup getLockStats() throws DatabaseException {
        return this.locker.collectStats();
    }

    private void trace(Level level, String changeType, BIN theBin, int lnIndex, long oldLsn, long newLsn) {
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(DbLsn.getNoFormatString(oldLsn));
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    private void traceInsert(Level level, BIN insertingBin, long lnLsn, int index) {
        EnvironmentImpl envImpl = this.databaseImpl.getEnv();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    public void setTestHook(TestHook hook) {
        this.testHook = hook;
    }

    private boolean checkAlreadyLatched(boolean isLatched) {
        if (isLatched && this.bin != null) {
            return this.bin.isLatchExclusiveOwner();
        }
        return true;
    }

    public static interface WithCursor {
        public boolean withCursor(CursorImpl var1, DatabaseEntry var2, DatabaseEntry var3) throws DatabaseException;
    }

    public static class LockStanding {
        private long lsn;
        private boolean nullLsn;
        private boolean deleted;
        private LockResult lockResult;

        public boolean recordExists() {
            return !this.nullLsn && !this.deleted;
        }

        public LockResult getLockResult() {
            return this.lockResult;
        }

        public WriteLockInfo prepareForUpdate() {
            WriteLockInfo wri;
            boolean abortKnownDeleted = !this.recordExists();
            WriteLockInfo writeLockInfo = wri = this.lockResult == null ? null : this.lockResult.getWriteLockInfo();
            if (wri == null) {
                wri = new WriteLockInfo();
                wri.setAbortLsn(this.lsn);
                wri.setAbortKnownDeleted(abortKnownDeleted);
            } else {
                this.lockResult.setAbortLsn(this.lsn, abortKnownDeleted);
            }
            return wri;
        }

        public static WriteLockInfo prepareForInsert() {
            WriteLockInfo wri = new WriteLockInfo();
            return wri;
        }
    }

    public static enum SearchMode {
        SET(true, false, "SET"),
        BOTH(true, true, "BOTH"),
        SET_RANGE(false, false, "SET_RANGE"),
        BOTH_RANGE(false, true, "BOTH_RANGE");

        private final boolean exactSearch;
        private final boolean dataSearch;
        private final String name;

        private SearchMode(boolean exactSearch, boolean dataSearch, String name) {
            this.exactSearch = exactSearch;
            this.dataSearch = dataSearch;
            this.name = "SearchMode." + name;
        }

        public final boolean isExactSearch() {
            return this.exactSearch;
        }

        public final boolean isDataSearch() {
            return this.dataSearch;
        }

        public String toString() {
            return this.name;
        }
    }
}

