/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.jmx.JEMBean;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class JEDiagnostics
extends JEMBean
implements DynamicMBean {
    protected static final String CONSOLEHANDLER_LEVEL = "consoleHandlerLevel";
    protected static final String FILEHANDLER_LEVEL = "fileHandlerLevel";
    protected static final MBeanAttributeInfo ATT_CONSOLEHANDLER_LEVEL = new MBeanAttributeInfo("consoleHandlerLevel", "java.lang.String", "ConsoleHandler level.", true, true, false);
    protected static final MBeanAttributeInfo ATT_FILEHANDLER_LEVEL = new MBeanAttributeInfo("fileHandlerLevel", "java.lang.String", "FileHandler level.", true, true, false);
    protected static final String OP_RESET_LOGGING = "resetLoggerLevel";
    protected static final MBeanParameterInfo[] resetLoggingParams = new MBeanParameterInfo[]{new MBeanParameterInfo("Logger Name", "java.lang.String", "Specify the target logger."), new MBeanParameterInfo("Logging Level", "java.lang.String", "The new logging level for the target logger.")};
    protected static final MBeanOperationInfo OP_RESET_LOGGING_LEVEL = new MBeanOperationInfo("resetLoggerLevel", "Change the logging level for the specified logger.", resetLoggingParams, "void", 3);

    protected JEDiagnostics(Environment env) {
        super(env);
    }

    public JEDiagnostics() {
    }

    @Override
    protected void initClassFields() {
        this.currentClass = JEDiagnostics.class;
        this.className = "JEDiagnostics";
        this.DESCRIPTION = "Logging Monitor on an open Environment.";
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException {
        if (attributeName == null) {
            throw new AttributeNotFoundException("Attribute name can't be null.");
        }
        try {
            EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(this.env);
            if (attributeName.equals(CONSOLEHANDLER_LEVEL)) {
                return envImpl.getConsoleHandler().getLevel().toString();
            }
            if (attributeName.equals(FILEHANDLER_LEVEL)) {
                return envImpl.getFileHandler().getLevel().toString();
            }
            throw new AttributeNotFoundException("Attributes " + attributeName + " is not valid.");
        }
        catch (DatabaseException e) {
            throw new MBeanException(new RuntimeException(e.getMessage()));
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        block8: {
            if (attribute == null) {
                throw new AttributeNotFoundException("Attribute can't be null.");
            }
            String name = attribute.getName();
            Object value = attribute.getValue();
            if (name == null) {
                throw new AttributeNotFoundException("Attribute name can't be null.");
            }
            if (value == null) {
                throw new InvalidAttributeValueException("Attribute value for attribute " + name + " can't be null");
            }
            try {
                EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(this.env);
                Level level = Level.parse((String)value);
                if (name.equals(CONSOLEHANDLER_LEVEL)) {
                    envImpl.getConsoleHandler().setLevel(level);
                    break block8;
                }
                if (name.equals(FILEHANDLER_LEVEL)) {
                    envImpl.getFileHandler().setLevel(level);
                    break block8;
                }
                throw new AttributeNotFoundException("Attribute " + name + " is not valid.");
            }
            catch (NullPointerException e) {
                throw new InvalidAttributeValueException("Setting value for attribute " + name + "is invalid because of " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new MBeanException(e, e.getMessage());
            }
        }
    }

    private Level getLevel(Object level) {
        try {
            return Level.parse((String)level);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Can't use null for level value.", e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes can't be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                results.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attribute list can't be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object newValue = this.getAttribute(name);
                results.add(new Attribute(name, newValue));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        if (actionName == null) {
            throw new IllegalArgumentException("ActionName can't be null.");
        }
        try {
            EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(this.env);
            if (actionName.equals(OP_RESET_LOGGING)) {
                if (params == null || params.length != 2) {
                    return new IllegalArgumentException("Parameter is not valid");
                }
                envImpl.resetLoggingLevel(((String)params[0]).trim(), Level.parse((String)params[1]));
                return null;
            }
            return new IllegalArgumentException("ActionName: " + actionName + " is not valid.");
        }
        catch (DatabaseException e) {
            throw new MBeanException(new RuntimeException(e.getMessage() + LoggerUtils.getStackTrace(e)));
        }
        catch (NullPointerException e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    @Override
    protected void doRegisterMBean(Environment env) throws Exception {
        this.server.registerMBean(new JEDiagnostics(env), this.jeName);
    }

    @Override
    protected MBeanAttributeInfo[] getAttributeList() {
        ArrayList<MBeanAttributeInfo> attrList = new ArrayList<MBeanAttributeInfo>();
        attrList.add(ATT_CONSOLEHANDLER_LEVEL);
        if (DbInternal.getEnvironmentImpl(this.env).getFileHandler() != null) {
            attrList.add(ATT_FILEHANDLER_LEVEL);
        }
        return attrList.toArray(new MBeanAttributeInfo[attrList.size()]);
    }

    @Override
    protected void addOperations() {
        this.operationList.add(OP_RESET_LOGGING_LEVEL);
    }
}

