/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.DurabilityQuorum;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.FeederTxnStatDefinition;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class FeederTxns {
    private final Map<Long, TxnInfo> txnMap = new ConcurrentHashMap<Long, TxnInfo>();
    private final RepImpl repImpl;
    private final StatGroup statistics;
    private final AtomicLongStat txnsAcked;
    private final AtomicLongStat txnsNotAcked;
    private final AtomicLongStat ackWaitMs;
    private final AtomicLongStat totalTxnMs;

    public FeederTxns(RepImpl repImpl) {
        this.repImpl = repImpl;
        this.statistics = new StatGroup("FeederTxns", "FeederTxns statistics");
        this.txnsAcked = new AtomicLongStat(this.statistics, FeederTxnStatDefinition.TXNS_ACKED);
        this.txnsNotAcked = new AtomicLongStat(this.statistics, FeederTxnStatDefinition.TXNS_NOT_ACKED);
        this.ackWaitMs = new AtomicLongStat(this.statistics, FeederTxnStatDefinition.ACK_WAIT_MS);
        this.totalTxnMs = new AtomicLongStat(this.statistics, FeederTxnStatDefinition.TOTAL_TXN_MS);
    }

    public void setupForAcks(MasterTxn txn) {
        if (txn.getRequiredAckCount() == 0) {
            return;
        }
        TxnInfo txnInfo = new TxnInfo(txn);
        TxnInfo prevInfo = this.txnMap.put(txn.getId(), txnInfo);
        assert (prevInfo == null);
    }

    public MasterTxn getAckTxn(long txnId) {
        TxnInfo txnInfo = this.txnMap.get(txnId);
        return txnInfo == null ? null : txnInfo.txn;
    }

    public void clearTransactionAcks(Txn txn) {
        this.txnMap.remove(txn.getId());
    }

    public VLSN noteReplicaAck(RepNodeImpl replica, long txnId) {
        DurabilityQuorum durabilityQuorum = this.repImpl.getRepNode().getDurabilityQuorum();
        if (!durabilityQuorum.replicaAcksQualify(replica)) {
            return null;
        }
        TxnInfo txnInfo = this.txnMap.get(txnId);
        if (txnInfo == null) {
            return null;
        }
        txnInfo.countDown();
        return txnInfo.getCommitVLSN();
    }

    public void awaitReplicaAcks(MasterTxn txn, int timeoutMs) throws InterruptedException {
        TxnInfo txnInfo = this.txnMap.get(txn.getId());
        if (txnInfo == null) {
            return;
        }
        txnInfo.await(timeoutMs);
        this.txnMap.remove(txn.getId());
        RepNode repNode = this.repImpl.getRepNode();
        if (repNode != null) {
            repNode.getDurabilityQuorum().ensureSufficientAcks(txnInfo, timeoutMs);
        }
    }

    public StatGroup getStats() {
        StatGroup ret = this.statistics.cloneGroup(false);
        return ret;
    }

    public void resetStats() {
        this.statistics.clear();
    }

    public StatGroup getStats(StatsConfig config) {
        StatGroup cloneStats = this.statistics.cloneGroup(config.getClear());
        return cloneStats;
    }

    public class TxnInfo {
        private final CountDownLatch latch;
        final MasterTxn txn;

        private TxnInfo(MasterTxn txn) {
            assert (txn != null);
            int numRequiredAcks = txn.getRequiredAckCount();
            this.latch = numRequiredAcks == 0 ? null : new CountDownLatch(numRequiredAcks);
            this.txn = txn;
        }

        public VLSN getCommitVLSN() {
            return this.txn.getCommitVLSN();
        }

        private final boolean await(int timeoutMs) throws InterruptedException {
            boolean isZero;
            long ackAwaitStartMs = System.currentTimeMillis();
            boolean bl = isZero = this.latch == null || this.latch.await(timeoutMs, TimeUnit.MILLISECONDS);
            if (isZero) {
                FeederTxns.this.txnsAcked.increment();
                long now = System.currentTimeMillis();
                FeederTxns.this.ackWaitMs.add(now - ackAwaitStartMs);
                FeederTxns.this.totalTxnMs.add(now - this.txn.getStartMs());
            } else {
                FeederTxns.this.txnsNotAcked.increment();
            }
            return isZero;
        }

        public final void countDown() {
            if (this.latch == null) {
                return;
            }
            this.latch.countDown();
        }

        public final int getPendingAcks() {
            if (this.latch == null) {
                return 0;
            }
            return (int)this.latch.getCount();
        }

        public final MasterTxn getTxn() {
            return this.txn;
        }
    }
}

