/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.util.ldiff.DiffTracker;
import com.sleepycat.je.rep.util.ldiff.LDiffRecordRequestException;
import com.sleepycat.je.rep.util.ldiff.MismatchedRegion;
import com.sleepycat.je.rep.util.ldiff.Protocol;
import com.sleepycat.je.rep.util.ldiff.Record;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashSet;
import java.util.List;

public class DiffRecordAnalyzer {
    public static final long DATABASE_END = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doAnalysis(Database localDb, Protocol protocol, DataChannel channel, DiffTracker tracker, boolean doPrint) throws Exception {
        List<MismatchedRegion> regions = tracker.getDiffRegions();
        try (Cursor localCursor = null;){
            localCursor = localDb.openCursor(null, null);
            for (MismatchedRegion region : regions) {
                if (region.isLocalAdditional()) {
                    DiffRecordAnalyzer.printLocalAdditional(localCursor, region, doPrint);
                    continue;
                }
                if (region.isRemoteAdditional()) {
                    HashSet<Record> records = DiffRecordAnalyzer.getDiffArea(protocol, channel, region);
                    if (doPrint) {
                        DiffRecordAnalyzer.printAdditional(records, true);
                    }
                    records.clear();
                    continue;
                }
                HashSet<Record> localRecords = DiffRecordAnalyzer.getDiffArea(localCursor, region.getLocalBeginKey(), region.getLocalBeginData(), region.getLocalDiffSize());
                HashSet<Record> remoteRecords = DiffRecordAnalyzer.getDiffArea(protocol, channel, region);
                if (doPrint) {
                    DiffRecordAnalyzer.printDiffs(localRecords, remoteRecords);
                }
                localRecords.clear();
                remoteRecords.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doAnalysis(Database localDb, Database remoteDb, DiffTracker tracker, boolean doPrint) throws Exception {
        List<MismatchedRegion> regions = tracker.getDiffRegions();
        Cursor localCursor = null;
        Cursor remoteCursor = null;
        try {
            localCursor = localDb.openCursor(null, null);
            remoteCursor = remoteDb.openCursor(null, null);
            for (MismatchedRegion region : regions) {
                if (region.isLocalAdditional()) {
                    DiffRecordAnalyzer.printLocalAdditional(localCursor, region, doPrint);
                    continue;
                }
                if (region.isRemoteAdditional()) {
                    HashSet<Record> records = DiffRecordAnalyzer.getDiffArea(remoteCursor, region.getRemoteBeginKey(), region.getRemoteBeginData(), region.getRemoteDiffSize());
                    if (doPrint) {
                        DiffRecordAnalyzer.printAdditional(records, true);
                    }
                    records.clear();
                    continue;
                }
                HashSet<Record> localRecords = DiffRecordAnalyzer.getDiffArea(localCursor, region.getLocalBeginKey(), region.getLocalBeginData(), region.getLocalDiffSize());
                HashSet<Record> remoteRecords = DiffRecordAnalyzer.getDiffArea(remoteCursor, region.getRemoteBeginKey(), region.getRemoteBeginData(), region.getRemoteDiffSize());
                if (doPrint) {
                    DiffRecordAnalyzer.printDiffs(localRecords, remoteRecords);
                }
                localRecords.clear();
                remoteRecords.clear();
            }
        }
        finally {
            if (localCursor != null) {
                localCursor.close();
            }
            if (remoteCursor != null) {
                remoteCursor.close();
            }
        }
    }

    private static void printLocalAdditional(Cursor cursor, MismatchedRegion region, boolean doPrint) throws Exception {
        HashSet<Record> records = DiffRecordAnalyzer.getDiffArea(cursor, region.getLocalBeginKey(), region.getLocalBeginData(), region.getLocalDiffSize());
        if (doPrint) {
            DiffRecordAnalyzer.printAdditional(records, false);
        }
        records.clear();
    }

    private static void printAdditional(HashSet<Record> diffRecords, boolean remote) {
        String side = remote ? "Remote" : "Local";
        System.err.println("************************************************");
        System.err.println(side + " database has additional records, the " + "additional range as following:");
        side = remote ? "remote" : "local";
        for (Record record : diffRecords) {
            DiffRecordAnalyzer.printRecord(record, side, false);
        }
        System.err.println("************************************************");
    }

    private static void printRecord(Record record, String side, boolean different) {
        System.err.print("Record with Key: [");
        byte[] keys = record.getKey();
        for (int i = 0; i < keys.length; ++i) {
            System.err.print(keys[i]);
            if (i >= keys.length - 1) continue;
            System.err.print(" ");
        }
        System.err.print("]");
        if (record.getVLSN().getSequence() != -1L) {
            System.err.print(", VLSN: " + record.getVLSN());
        }
        if (different) {
            System.err.print(" does not exist on " + side + " database");
        }
        System.err.println();
    }

    private static HashSet<Record> getDiffArea(Cursor cursor, byte[] beginKey, byte[] beginData, long diffSize) throws Exception {
        HashSet<Record> records = new HashSet<Record>();
        LogManager logManager = DbInternal.getEnvironmentImpl(cursor.getDatabase().getEnvironment()).getLogManager();
        DatabaseEntry key = new DatabaseEntry(beginKey);
        DatabaseEntry data = new DatabaseEntry(beginData);
        boolean scanToEnd = diffSize == -1L;
        OperationStatus status = cursor.getSearchBoth(key, data, LockMode.DEFAULT);
        for (long count = 1L; status == OperationStatus.SUCCESS && (scanToEnd || count <= diffSize); ++count) {
            records.add(new Record(key.getData(), data.getData(), DiffRecordAnalyzer.getVLSN(cursor, logManager)));
            status = cursor.getNext(key, data, LockMode.DEFAULT);
        }
        return records;
    }

    public static HashSet<Record> getDiffArea(Cursor cursor, Protocol.RemoteDiffRequest request) throws Exception {
        return DiffRecordAnalyzer.getDiffArea(cursor, request.getKey(), request.getData(), request.getDiffSize());
    }

    private static HashSet<Record> getDiffArea(Protocol protocol, DataChannel channel, MismatchedRegion region) throws Exception {
        Protocol protocol2 = protocol;
        protocol2.getClass();
        protocol.write((BinaryProtocol.Message)new Protocol.RemoteDiffRequest(protocol2, region), channel);
        BinaryProtocol.Message message = protocol.read(channel);
        if (message.getOp() == Protocol.ERROR) {
            throw new LDiffRecordRequestException(((Protocol.Error)message).getErrorMessage());
        }
        if (message.getOp() != Protocol.DIFF_AREA_START) {
            throw new BinaryProtocol.ProtocolException(message, Protocol.DiffAreaStart.class);
        }
        HashSet<Record> records = new HashSet<Record>();
        try {
            while (true) {
                Protocol.RemoteRecord record = protocol.read(channel, Protocol.RemoteRecord.class);
                records.add(new Record(record.getKey(), record.getData(), record.getVLSN()));
            }
        }
        catch (BinaryProtocol.ProtocolException pe) {
            if (pe.getUnexpectedMessage().getOp() != Protocol.DIFF_AREA_END) {
                throw pe;
            }
            return records;
        }
    }

    private static void printDiffs(HashSet<Record> localDiffs, HashSet<Record> remoteDiffs) {
        System.err.println("************************************************");
        System.err.println("Different records between local and remote database in a specific different area.");
        for (Record record : localDiffs) {
            if (remoteDiffs.contains(record)) continue;
            DiffRecordAnalyzer.printRecord(record, "remote", true);
        }
        for (Record record : remoteDiffs) {
            if (localDiffs.contains(record)) continue;
            DiffRecordAnalyzer.printRecord(record, "local", true);
        }
        System.err.println("************************************************");
    }

    private static VLSN getVLSN(Cursor cursor, LogManager logManager) throws Exception {
        CursorImpl cursorImpl = DbInternal.getCursorImpl(cursor);
        cursorImpl.latchBIN();
        long lsn = cursorImpl.getCurrentLsn();
        cursorImpl.releaseBIN();
        WholeEntry entry = logManager.getLogEntryAllowInvisible(lsn);
        VLSN vlsn = entry.getHeader().getVLSN();
        if (vlsn == null) {
            vlsn = VLSN.NULL_VLSN;
        }
        return vlsn;
    }
}

