/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.utilint.net.SimpleDataChannel;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.StatGroup;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class RepUtils {
    public static final boolean DEBUG_PRINT_THREAD = true;
    public static final boolean DEBUG_PRINT_TIME = true;
    private static final Map<String, ConsistencyPolicyFormat<?>> consistencyPolicyFormats = new HashMap();
    public static final DataChannel CHANNEL_EOF_MARKER;

    public static void addConsistencyPolicyFormat(String name, ConsistencyPolicyFormat<?> format) {
        consistencyPolicyFormats.put(name.toUpperCase(Locale.ENGLISH), format);
    }

    public static String getPropertyString(ReplicaConsistencyPolicy policy) throws IllegalArgumentException {
        ConsistencyPolicyFormat<?> format = consistencyPolicyFormats.get(policy.getName().toUpperCase());
        if (format == null) {
            throw new IllegalArgumentException("Policy: " + policy + " cannot be used as a property");
        }
        return format.policyToString(policy);
    }

    public static ReplicaConsistencyPolicy getReplicaConsistencyPolicy(String propertyValue) throws IllegalArgumentException {
        String upperCasePropertyValue = propertyValue.toUpperCase(Locale.ENGLISH);
        for (Map.Entry<String, ConsistencyPolicyFormat<?>> entry : consistencyPolicyFormats.entrySet()) {
            String name = entry.getKey();
            if (!upperCasePropertyValue.equals(name) && (!upperCasePropertyValue.startsWith(name) || upperCasePropertyValue.length() <= name.length() || Character.isLetter(upperCasePropertyValue.charAt(name.length())))) continue;
            ConsistencyPolicyFormat<?> format = entry.getValue();
            return format.stringToPolicy(propertyValue);
        }
        throw new IllegalArgumentException("Invalid consistency policy: " + propertyValue);
    }

    private static DatabaseException prepareTerminatingException(Exception e, EnvironmentImpl envImpl) {
        if (e == null) {
            return null;
        }
        DatabaseException de = e instanceof DatabaseException ? (DatabaseException)e : EnvironmentFailureException.unexpectedException(envImpl, e);
        de.addErrorMessage("Originally thrown by HA thread: " + Thread.currentThread().getName());
        return de;
    }

    private static DatabaseException addLocalStackTrace(DatabaseException e) {
        e.addRethrownStackTrace();
        return e;
    }

    public static void shutdownChannel(NamedChannel namedChannel) {
        if (namedChannel == null) {
            return;
        }
        RepUtils.shutdownChannel(namedChannel.getChannel());
    }

    public static void shutdownChannel(DataChannel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SocketChannel openSocketChannel(InetSocketAddress addr, DataChannelFactory.ConnectOptions connectOpts) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(connectOpts.getBlocking());
        Socket socket = channel.socket();
        if (connectOpts.getReceiveBufferSize() != 0) {
            socket.setReceiveBufferSize(connectOpts.getReceiveBufferSize());
        }
        socket.setTcpNoDelay(connectOpts.getTcpNoDelay());
        socket.setSoTimeout(connectOpts.getReadTimeout());
        socket.setReuseAddress(connectOpts.getReuseAddr());
        socket.connect(addr, connectOpts.getOpenTimeout());
        return channel;
    }

    public static DataChannel openBlockingChannel(InetSocketAddress addr, DataChannelFactory factory, DataChannelFactory.ConnectOptions connectOpts) throws IOException {
        return factory.connect(addr, connectOpts);
    }

    public static Throwable chainExceptionCause(Throwable newt, Throwable oldt) {
        Throwable tail = newt;
        while (tail.getCause() != null) {
            tail = tail.getCause();
        }
        tail.initCause(oldt);
        return newt;
    }

    public static String writeTimesString(StatGroup stats) {
        long nMessagesWritten = stats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
        long nWriteNanos = stats.getLong(BinaryProtocolStatDefinition.N_WRITE_NANOS);
        long avgWriteNanos = nMessagesWritten <= 0L ? 0L : nWriteNanos / nMessagesWritten;
        return String.format(" write time: %, dms Avg write time: %,dus", nWriteNanos / 1000000L, avgWriteNanos / 1000L);
    }

    public static Properties populateNetProps(Properties props, File accessPropsFile) {
        Properties rawProps = new Properties();
        DbConfigManager.applyFileConfig(accessPropsFile, rawProps, true);
        ReplicationNetworkConfig.applyRepNetProperties(rawProps, props);
        return props;
    }

    public static String exec(String ... args) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
        PrintStream output = new PrintStream(bao);
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                output.println(line);
            }
        }
        catch (Exception e) {
            output.println("EXCEPTION: class:" + e.getClass().getName() + " message:" + e.getMessage());
        }
        return bao.toString();
    }

    static {
        RepUtils.addConsistencyPolicyFormat("TimeConsistencyPolicy", new TimeConsistencyPolicyFormat());
        RepUtils.addConsistencyPolicyFormat("NoConsistencyRequiredPolicy", new NoConsistencyRequiredPolicyFormat());
        try {
            CHANNEL_EOF_MARKER = new SimpleDataChannel(SocketChannel.open());
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public static class ExceptionAwareBlockingQueue<T>
    extends LinkedBlockingQueue<T> {
        final EnvironmentImpl envImpl;
        final T dummyValue;
        private final AtomicReference<DatabaseException> terminatingException = new AtomicReference();

        public ExceptionAwareBlockingQueue(EnvironmentImpl envImpl, T dummyValue) {
            this.envImpl = envImpl;
            this.dummyValue = dummyValue;
        }

        public void releasePoll(Exception e) {
            this.terminatingException.compareAndSet(null, RepUtils.prepareTerminatingException(e, this.envImpl));
            this.add(this.dummyValue);
        }

        public T pollOrException(long timeout, TimeUnit unit) throws InterruptedException, DatabaseException {
            Object value = super.poll(timeout, unit);
            if (value == null) {
                return (T)value;
            }
            DatabaseException e = this.terminatingException.get();
            if (e != null) {
                throw RepUtils.addLocalStackTrace(e);
            }
            return (T)value;
        }

        @Override
        @Deprecated
        public T poll(long timeout, TimeUnit unit) {
            throw EnvironmentFailureException.unexpectedState("Use pollOrException() instead of poll()");
        }
    }

    public static class ExceptionAwareCountDownLatch
    extends CountDownLatch {
        final EnvironmentImpl envImpl;
        private final AtomicReference<DatabaseException> terminatingException = new AtomicReference();

        public ExceptionAwareCountDownLatch(EnvironmentImpl envImpl, int count) {
            super(count);
            this.envImpl = envImpl;
        }

        public void releaseAwait(Exception e) {
            this.terminatingException.compareAndSet(null, RepUtils.prepareTerminatingException(e, this.envImpl));
            for (long count = this.getCount(); count > 0L; --count) {
                this.countDown();
            }
            assert (this.getCount() == 0L);
        }

        public boolean awaitOrException(long timeout, TimeUnit unit) throws InterruptedException, DatabaseException {
            boolean done = super.await(timeout, unit);
            if (!done) {
                return done;
            }
            DatabaseException e = this.terminatingException.get();
            if (e != null) {
                throw RepUtils.addLocalStackTrace(e);
            }
            return done;
        }

        public void awaitOrException() throws InterruptedException, DatabaseException {
            this.awaitOrException(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        @Override
        @Deprecated
        public boolean await(long timeout, TimeUnit unit) {
            throw EnvironmentFailureException.unexpectedState("Use awaitOrException() instead of await");
        }
    }

    private static class NoConsistencyRequiredPolicyFormat
    implements ConsistencyPolicyFormat<NoConsistencyRequiredPolicy> {
        private NoConsistencyRequiredPolicyFormat() {
        }

        @Override
        public String policyToString(NoConsistencyRequiredPolicy policy) {
            return "NoConsistencyRequiredPolicy";
        }

        @Override
        public NoConsistencyRequiredPolicy stringToPolicy(String string) {
            return NoConsistencyRequiredPolicy.NO_CONSISTENCY;
        }
    }

    private static class TimeConsistencyPolicyFormat
    implements ConsistencyPolicyFormat<TimeConsistencyPolicy> {
        private TimeConsistencyPolicyFormat() {
        }

        @Override
        public String policyToString(TimeConsistencyPolicy policy) {
            return policy.getName() + "(" + policy.getPermissibleLag(TimeUnit.MILLISECONDS) + " ms," + policy.getTimeout(TimeUnit.MILLISECONDS) + " ms)";
        }

        @Override
        public TimeConsistencyPolicy stringToPolicy(String string) {
            String args = string.substring("TimeConsistencyPolicy".length());
            if (args.charAt(0) != '(' || args.charAt(args.length() - 1) != ')') {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int arg1 = args.indexOf(44);
            if (arg1 == -1) {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int lag = PropUtil.parseDuration(args.substring(1, arg1));
            int arg2 = args.indexOf(41);
            if (arg2 == -1) {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int timeout = PropUtil.parseDuration(args.substring(arg1 + 1, arg2));
            return new TimeConsistencyPolicy(lag, TimeUnit.MILLISECONDS, timeout, TimeUnit.MILLISECONDS);
        }
    }

    public static interface ConsistencyPolicyFormat<T extends ReplicaConsistencyPolicy> {
        public String policyToString(T var1);

        public T stringToPolicy(String var1);
    }
}

